/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.ICloneableParent;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.path.ISourceElementCountProvider;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProgrammingElement
extends NamedElement
implements ICloneableParent,
ISnapshotDependency.IDependencyEndpoint,
ISourceElementCountProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgrammingElement.class);
    private String m_shortName;
    private ArrayList<ParserDependency> m_dependencies;
    private int m_lineNumber = -1;
    private IModelServiceProvider m_msp;

    protected ProgrammingElement(NamedElement parent) {
        super(parent);
    }

    protected ProgrammingElement(IModelServiceProvider msp, NamedElement parent, String shortName) {
        this(parent);
        assert (msp != null) : "Parameter 'msp' of method 'ProgrammingElement' must not be null";
        this.m_shortName = shortName == null ? "" : shortName.intern();
        this.m_msp = msp;
    }

    protected ProgrammingElement(IModelServiceProvider msp, NamedElement parent, String shortName, int lineNumber) {
        this(msp, parent, shortName);
        this.m_lineNumber = lineNumber;
    }

    @Override
    public final ProgrammingElement getElement() {
        return this;
    }

    @Override
    public final StructureItem getStructureItem() {
        return StructureItem.PROGRAMMING_ELEMENT;
    }

    public final void mergeDependenciesFrom(ProgrammingElement other) {
        assert (other != null) : "Parameter 'other' of method 'transferDependenciesFrom' must not be null";
        ArrayList<ParserDependency> deps = other.m_dependencies;
        other.m_dependencies = null;
        if (deps != null) {
            deps.forEach(d -> d.replaceEndpoint(other, this));
            for (ParserDependency dep : deps) {
                if (this.m_dependencies == null) {
                    this.linkDependency(dep);
                    continue;
                }
                if (this.m_dependencies.stream().anyMatch(d -> d.isEqual(dep))) {
                    if (dep.getTo() != this) {
                        dep.getTo().unlinkDependency(dep);
                        continue;
                    }
                    if (dep.getFrom() == this) continue;
                    dep.getFrom().unlinkDependency(dep);
                    continue;
                }
                this.linkDependency(dep);
            }
        }
    }

    public final IModelServiceProvider getModelServiceProvider() {
        return this.m_msp;
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public ProgrammingElement getOriginal() {
        return this;
    }

    @Override
    public ProgrammingElement getRepresentative() {
        return this;
    }

    @Override
    public final List<NamedElement> getChildren() {
        return super.getChildren(this.getModelServiceProvider());
    }

    @Override
    public final NamedElement getParent() {
        return super.getParent(this.getModelServiceProvider());
    }

    @Override
    public final void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    @Override
    public final IDomainRoot.Domain getDomain() {
        return IDomainRoot.Domain.PHYSICAL;
    }

    public boolean hasMultipleDefinitions() {
        return false;
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    @Override
    public final IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    public List<? extends ProgrammingElement> getDefinitions() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean isExternal() {
        NamedElement parent = this.getParent();
        if (parent != null) {
            return parent.isExternal();
        }
        LOGGER.warn("Unable to determine 'isExternal' - has no parent: " + String.valueOf(this));
        return false;
    }

    @Override
    public String getName() {
        return this.m_shortName;
    }

    @Override
    public String getShortName() {
        return this.m_shortName;
    }

    public final void setShortName(String shortName) {
        assert (shortName != null) : "Parameter 'shortName' of method 'setShortName' must not be null";
        this.m_shortName = shortName.intern();
    }

    public abstract boolean isMember();

    @Override
    public void finishModification() {
        if (this.m_dependencies != null) {
            this.m_dependencies.trimToSize();
        }
        super.finishModification();
    }

    @Override
    public final int getIndexOfOutgoingDependency(ISnapshotDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getIndexOf' must not be null";
        assert (this.hasDependencies()) : "Has no dependencies";
        assert (dependency.getFrom() == this) : "Not an outgoing dependency: " + String.valueOf(dependency);
        ProgrammingElement original = this.getOriginal();
        int indexOfOutgoingDependency = -1;
        for (ParserDependency nextDependency : this.m_dependencies) {
            if (nextDependency.getOriginalFrom() != original) continue;
            ++indexOfOutgoingDependency;
            if (nextDependency != dependency) continue;
            return indexOfOutgoingDependency;
        }
        assert (false) : "Dependency not found: " + String.valueOf(dependency);
        return -1;
    }

    @Override
    public final ISnapshotDependency getOutgoingDependencyAt(int index) {
        assert (this.hasDependencies()) : "Has no dependencies";
        assert (index >= 0) : "'index' must not be negative";
        int indexOfOutgoingDependency = -1;
        for (ParserDependency nextDependency : this.m_dependencies) {
            if (nextDependency.getFrom() != this || index != ++indexOfOutgoingDependency) continue;
            return nextDependency;
        }
        assert (false) : "No outgoing dependency found at: " + index;
        return null;
    }

    public final boolean hasDependencies() {
        return this.m_dependencies != null && !this.m_dependencies.isEmpty();
    }

    public final boolean hasOutgoingDependencies() {
        if (this.hasDependencies()) {
            for (ParserDependency nextDependency : this.m_dependencies) {
                if (nextDependency.getFrom() != this) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasIncomingDependencies() {
        if (this.hasDependencies()) {
            for (ParserDependency nextDependency : this.m_dependencies) {
                if (nextDependency.getTo() != this) continue;
                return true;
            }
        }
        return false;
    }

    private void linkDependency(ParserDependency dependency) {
        if (this.m_dependencies == null) {
            this.m_dependencies = new ArrayList();
        }
        this.m_dependencies.add(dependency);
    }

    @Override
    public final void writeDependencyList(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'writeDependencyList' must not be null";
        if (this.m_dependencies != null) {
            ProgrammingElement original = this.getOriginal();
            for (ParserDependency next : this.m_dependencies) {
                if (!next.persist(writer.getMode()) || next.getOriginalFrom() != original) continue;
                writer.writeString(next.getClass().getName());
            }
        }
        writer.writeString(null);
    }

    @Override
    public final void readDependencyList(ISnapshotReader reader) throws IOException, ClassNotFoundException {
        ParserDependency dependency;
        SnapshotArgument argument = new SnapshotArgument(ProgrammingElement.class, this);
        while ((dependency = reader.read(ParserDependency.class, argument)) != null) {
            assert (dependency.getFrom() == this);
            this.linkDependency(dependency);
        }
    }

    public final void addDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addDependency' must not be null";
        assert (this == dependency.getFrom()) : "Not an outgoing dependency: " + String.valueOf(dependency);
        this.linkDependency(dependency);
        if (this != dependency.getTo()) {
            dependency.getTo().linkDependency(dependency);
        }
    }

    public final boolean addDependencyIfNotPresent(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addDependencyIfNotPresent' must not be null";
        if (this.m_dependencies != null) {
            for (ParserDependency other : this.m_dependencies) {
                if (!dependency.isEqual(other)) continue;
                return false;
            }
        }
        this.addDependency(dependency);
        return true;
    }

    public final ParserDependency getFirstDependencyByDependencyType(IStandardEnumeration dependencyType) {
        if (this.m_dependencies != null) {
            for (ParserDependency dep : this.m_dependencies) {
                if (dep.getFrom() != this || dep.getDependencyType() != dependencyType) continue;
                return dep;
            }
        }
        return null;
    }

    public final void transferIncomingDependenciesTo(ProgrammingElement target) {
        assert (target != null) : "Parameter 'target' of method 'transferIncomingDependenciesTo' must not be null";
        assert (this != target) : "Same instances";
        if (this.m_dependencies != null) {
            Iterator<ParserDependency> iter = this.m_dependencies.iterator();
            while (iter.hasNext()) {
                ParserDependency dep = iter.next();
                if (dep.getTo() != this) continue;
                iter.remove();
                dep.setTo(target);
                if (target.m_dependencies != null && target.m_dependencies.stream().anyMatch(d -> d.isEqual(dep))) {
                    dep.getFrom().unlinkDependency(dep);
                    continue;
                }
                target.linkDependency(dep);
            }
        }
    }

    public void unlinkDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'unlinkDependency' must not be null";
        if (this.m_dependencies == null || !this.m_dependencies.remove(dependency)) {
            if (dependency.getFrom() == this) {
                LOGGER.error("Trying to remove missing outgoing dependency: " + String.valueOf(dependency));
            } else {
                LOGGER.error("Trying to remove missing incoming dependency: " + String.valueOf(dependency));
            }
        } else if (this.m_dependencies.isEmpty()) {
            this.m_dependencies = null;
        }
    }

    public final void removeDependency(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'removeDependency' must not be null";
        assert (this == dependency.getFrom());
        this.unlinkDependency(dependency);
        if (this != dependency.getTo()) {
            dependency.getTo().unlinkDependency(dependency);
        }
        dependency.setTo(null);
    }

    public final void removeOutgoingDependencies(boolean recursively) {
        if (recursively) {
            this.getChildren(ProgrammingElement.class).forEach(c -> c.removeOutgoingDependencies(true));
        }
        if (this.hasDependencies()) {
            Iterator<ParserDependency> iterator = this.m_dependencies.iterator();
            while (iterator.hasNext()) {
                ParserDependency nextOutgoingDependency = iterator.next();
                if (nextOutgoingDependency.getFrom() != this) continue;
                if (nextOutgoingDependency.getFrom() != nextOutgoingDependency.getTo()) {
                    if (this == nextOutgoingDependency.getFrom()) {
                        nextOutgoingDependency.getTo().unlinkDependency(nextOutgoingDependency);
                    } else {
                        nextOutgoingDependency.getFrom().unlinkDependency(nextOutgoingDependency);
                    }
                }
                nextOutgoingDependency.setTo(null);
                iterator.remove();
            }
            if (this.m_dependencies.isEmpty()) {
                this.m_dependencies = null;
            }
        }
    }

    public final void removeDependencies(boolean recursively) {
        if (recursively) {
            this.getChildren(ProgrammingElement.class).forEach(c -> c.removeDependencies(true));
        }
        if (this.hasDependencies()) {
            for (ParserDependency next : this.m_dependencies) {
                if (next.getFrom() != next.getTo()) {
                    if (this.getRepresentative() == next.getFrom()) {
                        next.getTo().unlinkDependency(next);
                    } else {
                        next.getFrom().unlinkDependency(next);
                    }
                }
                next.setTo(null);
            }
            this.m_dependencies.clear();
            this.m_dependencies = null;
        }
    }

    public final List<ParserDependency> getDependencies() {
        return this.hasDependencies() ? Collections.unmodifiableList(this.m_dependencies) : Collections.emptyList();
    }

    @Override
    public final void dispose() {
        if (this.m_dependencies != null) {
            this.m_dependencies.clear();
            this.m_dependencies = null;
        }
        super.dispose();
    }

    public final Iterator<ParserDependency> getOutgoingDependencyIterator(IStandardEnumeration ... dependencyTypes) {
        if (!this.hasDependencies()) {
            return Collections.emptyIterator();
        }
        DependencyIterator result = new DependencyIterator(this.m_dependencies.iterator(), this, null);
        result.setDependencyTypeFilter(dependencyTypes);
        return result;
    }

    public final Iterator<ParserDependency> getDependencyIterator() {
        if (this.m_dependencies == null) {
            return Collections.emptyIterator();
        }
        return this.m_dependencies.iterator();
    }

    public final Iterator<ParserDependency> getOutgoingDependencyIterator(ProgrammingElement to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingDependencyIterator' must not be null";
        if (!this.hasDependencies()) {
            return Collections.emptyIterator();
        }
        return new DependencyIterator(this.m_dependencies.iterator(), this, to);
    }

    public final List<ParserDependency> getOutgoingDependencies(IParserDependencyType ... types) {
        if (!this.hasDependencies()) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        block0: for (ParserDependency nextDependency : this.m_dependencies) {
            if (nextDependency.getFrom() != this) continue;
            if (types.length == 0) {
                result.add(nextDependency);
                continue;
            }
            IParserDependencyType[] iParserDependencyTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IParserDependencyType dependencyType = iParserDependencyTypeArray[n2];
                if (dependencyType == nextDependency.getDependencyType() || dependencyType == nextDependency.getGenericDependencyType()) {
                    result.add(nextDependency);
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    public ProgrammingElement getOutgoingDependencyTargetAt(int index) {
        if (!this.hasDependencies()) {
            return null;
        }
        ProgrammingElement result = null;
        for (ParserDependency nextDependency : this.m_dependencies) {
            if (nextDependency.getFrom() != this) continue;
            if (index == 0) {
                result = nextDependency.getTo();
                break;
            }
            --index;
        }
        return result;
    }

    public final List<ParserDependency> getIncomingDependenciesRecursively() {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>(this.getIncomingDependencies(new IStandardEnumeration[0]));
        for (ProgrammingElement nextChild : this.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
            result.addAll(nextChild.getIncomingDependencies(new IStandardEnumeration[0]));
        }
        return result;
    }

    public final List<ParserDependency> getOutgoingDependenciesRecursively() {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>(this.getOutgoingDependencies(new IParserDependencyType[0]));
        for (ProgrammingElement nextChild : this.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
            result.addAll(nextChild.getOutgoingDependencies(new IParserDependencyType[0]));
        }
        return result;
    }

    public final Iterator<ParserDependency> getIncomingDependencyIterator(IStandardEnumeration ... dependencyTypes) {
        if (!this.hasDependencies()) {
            return Collections.emptyIterator();
        }
        DependencyIterator result = new DependencyIterator(this.m_dependencies.iterator(), null, this);
        result.setDependencyTypeFilter(dependencyTypes);
        return result;
    }

    public final Iterator<ParserDependency> getIncomingDependencyIterator() {
        if (!this.hasDependencies()) {
            return Collections.emptyIterator();
        }
        return new DependencyIterator(this.m_dependencies.iterator(), null, this);
    }

    public final Iterator<ParserDependency> getIncomingDependencyIterator(IVirtualModel mapper, ProgrammingElement from) {
        assert (from != null) : "Parameter 'from' of method 'getIncomingDependencyIterator' must not be null";
        assert (mapper != null) : "Parameter 'mapper' of method 'getIncomingDependencyIterator' must not be null";
        if (!this.hasDependencies()) {
            return Collections.emptyIterator();
        }
        return new DependencyIterator(this.m_dependencies.iterator(), from, this);
    }

    public final List<ParserDependency> getIncomingDependencies(IStandardEnumeration ... types) {
        if (!this.hasDependencies()) {
            return Collections.emptyList();
        }
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        block0: for (ParserDependency nextDependency : this.m_dependencies) {
            if (nextDependency.getTo() != this) continue;
            if (types.length == 0) {
                result.add(nextDependency);
                continue;
            }
            IStandardEnumeration[] iStandardEnumerationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IStandardEnumeration dependencyType = iStandardEnumerationArray[n2];
                if (dependencyType == nextDependency.getDependencyType() || dependencyType == nextDependency.getGenericDependencyType()) {
                    result.add(nextDependency);
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    public boolean includeInLogicalModel() {
        return true;
    }

    @Override
    public final void parentRemoved() {
        this.removeDependencies(true);
    }

    @Override
    public void remove() {
        this.removeDependencies(false);
        super.remove();
    }

    @Override
    public final int getLineNumber() {
        return this.m_lineNumber;
    }

    public final void setLineNumber(int lineNumber) {
        this.m_lineNumber = lineNumber;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_shortName);
        writer.writeInt(this.m_lineNumber);
        if (this.m_dependencies != null) {
            for (ParserDependency next : this.m_dependencies) {
                if (!next.persist(writer.getMode()) || next.getOriginalFrom() != this) continue;
                next.store(writer);
            }
        }
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_shortName = reader.readString();
        this.m_lineNumber = reader.readInt();
        if (this.m_dependencies != null) {
            for (ParserDependency dep : this.m_dependencies) {
                if (dep.getFrom() != this) continue;
                dep.retrieve(reader);
                if (dep.getTo() == this) continue;
                dep.getTo().linkDependency(dep);
            }
            this.m_dependencies.trimToSize();
        }
        if (this.m_shortName != null) {
            this.m_shortName = this.m_shortName.intern();
        }
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    @IntProperty(undefinedValue=-1)
    public int getSourceElementCount() {
        if (!this.isDefinedInEnclosingElement() || this.isExternal()) {
            return -1;
        }
        return 1;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (Annotation next : this.getAnnotations()) {
            builder.append("\n");
            builder.append(next.getDebugInfo());
        }
        return builder.toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        if (this.m_msp != null && this.m_msp.getCurrentModel().getOriginal(this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    final class DependencyIterator
    implements Iterator<ParserDependency> {
        private final Iterator<ParserDependency> m_dependencyIterator;
        private final ProgrammingElement m_from;
        private final ProgrammingElement m_to;
        private IStandardEnumeration[] m_dependencyTypeFilter;
        private ParserDependency m_nextDependency;

        private DependencyIterator(Iterator<ParserDependency> iterator, ProgrammingElement from, ProgrammingElement to) {
            assert (iterator != null) : "Parameter 'iterator' of method 'DependencyIterator' must not be null";
            this.m_dependencyIterator = iterator;
            this.m_from = from;
            this.m_to = to;
        }

        private boolean hasMatchingDependencyType(ParserDependency dependency) {
            assert (this.m_dependencyTypeFilter != null);
            IStandardEnumeration[] iStandardEnumerationArray = this.m_dependencyTypeFilter;
            int n = this.m_dependencyTypeFilter.length;
            int n2 = 0;
            while (n2 < n) {
                IStandardEnumeration dependencyType = iStandardEnumerationArray[n2];
                if (dependency.getDependencyType() == dependencyType || dependency.getGenericDependencyType() == dependencyType) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void setDependencyTypeFilter(IStandardEnumeration[] dependencyTypeFilter) {
            this.m_dependencyTypeFilter = dependencyTypeFilter.length > 0 ? dependencyTypeFilter : null;
        }

        @Override
        public boolean hasNext() {
            while (this.m_dependencyIterator.hasNext() && this.m_nextDependency == null) {
                ParserDependency nextDependency = this.m_dependencyIterator.next();
                if (this.m_from != null && nextDependency.getFrom() != this.m_from || this.m_to != null && nextDependency.getTo() != this.m_to || this.m_dependencyTypeFilter != null && !this.hasMatchingDependencyType(nextDependency)) continue;
                this.m_nextDependency = nextDependency;
            }
            return this.m_nextDependency != null;
        }

        @Override
        public ParserDependency next() {
            assert (this.m_nextDependency != null) : "'m_NextDependency' of method 'next' must not be null";
            ParserDependency nextDependency = this.m_nextDependency;
            this.m_nextDependency = null;
            return nextDependency;
        }

        @Override
        public void remove() {
            this.m_dependencyIterator.remove();
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitProgrammingElement(ProgrammingElement var1);
    }
}

