/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameContributor;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementOwner;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElementHelper;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LogicalProgrammingElement
extends NamedElementContainer
implements ILogicalElement,
IAssignableToArtifact,
ILogicalProgrammingElementOwner {
    private final List<ProgrammingElement> m_programmingElements;
    private final String m_fqNamePart;

    public static final boolean includeInLogicalModel(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeInLogicalModel' must not be null";
        return element.includeInLogicalModel() && !element.isExcluded() && !element.getRefactoringState().hasBeenDeleted();
    }

    protected LogicalProgrammingElement(NamedElement parent, List<ProgrammingElement> programmingElements, String fqNamePart) {
        super(parent);
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'LogicalProgrammingElement' must not be empty";
        assert (fqNamePart != null && fqNamePart.length() > 0) : "Parameter 'fqNamePart' of method 'LogicalProgrammingElement' must not be empty";
        for (ProgrammingElement next : programmingElements) {
            assert (LogicalProgrammingElement.includeInLogicalModel(next)) : "No to be included in logical domain: " + String.valueOf(next);
        }
        this.m_programmingElements = new ArrayList<ProgrammingElement>(programmingElements);
        this.m_fqNamePart = fqNamePart;
    }

    @Override
    public final List<? extends NamedElement> getAllChildren() {
        return super.getAllChildren();
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public boolean ignoreIssues() {
        for (ProgrammingElement next : this.m_programmingElements) {
            if (next.ignoreIssues()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String getShortName() {
        return this.getPrimaryProgrammingElement().getShortName();
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return this.m_fqNamePart;
    }

    @Override
    public final String getPresentationName(boolean shortName) {
        return this.getPrimaryProgrammingElement().getPresentationName(shortName);
    }

    @Property
    public final String getFullyQualifiedTypeName() {
        ProgrammingElement element = this.getPrimaryProgrammingElement();
        return element instanceof IType ? ((IType)((Object)element)).getFullyQualifiedTypeName() : "";
    }

    @Override
    public final String getImageResourceName() {
        return this.getPrimaryProgrammingElement().getImageResourceName();
    }

    @Override
    public final String getName() {
        return this.getPrimaryProgrammingElement().getName();
    }

    @Override
    public final boolean isDefinedInEnclosingElement() {
        return this.getPrimaryProgrammingElement().isDefinedInEnclosingElement();
    }

    @Override
    public final boolean isExternal() {
        return this.getPrimaryProgrammingElement().isExternal();
    }

    @Override
    public final boolean isExcluded() {
        return false;
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public final StructureItem getStructureItem() {
        return StructureItem.LOGICAL_PROGRAMMING_ELEMENT;
    }

    @Override
    public final String getDescription() {
        return "";
    }

    public ProgrammingElement getPrimaryProgrammingElement() {
        return this.m_programmingElements.get(0);
    }

    public final List<? extends ProgrammingElement> getProgrammingElements() {
        return Collections.unmodifiableList(this.m_programmingElements);
    }

    @Override
    public final int getLineNumber() {
        return this.getPrimaryProgrammingElement().getLineNumber();
    }

    protected void createDirectChildren(List<ProgrammingElement> programmingElements) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'createDirectChildren' must not be empty";
        LogicalProgrammingElementHelper.createDirectChildren(programmingElements, this);
    }

    private static void collectDirectProgrammingElementChildren(ProgrammingElement programmingElement, List<ProgrammingElement> collector) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'collectDirectProgrammingElementChildren' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectDirectProgrammingElementChildren' must not be null";
        for (ProgrammingElement nextProgrammingElement : programmingElement.getChildren(ProgrammingElement.class)) {
            if (nextProgrammingElement.isGhost()) {
                LogicalProgrammingElement.collectDirectProgrammingElementChildren(nextProgrammingElement, collector);
                continue;
            }
            if (!LogicalProgrammingElement.includeInLogicalModel(nextProgrammingElement)) continue;
            collector.add(nextProgrammingElement);
        }
    }

    @Override
    public final void finishModification() {
        ArrayList<ProgrammingElement> directProgrammingElementChildren = new ArrayList<ProgrammingElement>();
        for (ProgrammingElement nextProgrammingElement : this.m_programmingElements) {
            LogicalProgrammingElement.collectDirectProgrammingElementChildren(nextProgrammingElement, directProgrammingElementChildren);
        }
        if (!directProgrammingElementChildren.isEmpty()) {
            this.createDirectChildren(directProgrammingElementChildren);
            this.getChildren().forEach(c -> c.finishModification());
        }
        super.finishModification();
    }

    @Override
    public final List<NamedElement> getChildren() {
        return super.getChildren();
    }

    @Override
    public final NamedElement resolveByFullyQualifiedNamePart(String fqNamePart) {
        return super.resolveByFullyQualifiedNamePart(fqNamePart);
    }

    @Override
    public final NamedElement resolveOriginalByFullyQualifiedNamePart(String fqNamePart) {
        return super.resolveOriginalByFullyQualifiedNamePart(fqNamePart);
    }

    @Override
    public final String getArchitectureFilterName() {
        NamedElement parent = this.getParent();
        if (!(parent instanceof LogicalProgrammingElement)) {
            IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
            assert (provider != null) : "'provider' of method 'getArchitectureFilterName' must not be null";
            IArchitectureFilterNameContributor contributor = this.getParent(IArchitectureFilterNameContributor.class, new Class[0]);
            return provider.getArchitectureFilterNamePrefix() + (contributor != null ? contributor.getArchitectureFilterNamePart() : "") + this.getShortName().replace("/", " slash").replace("*", " star ");
        }
        return IAssignableToArtifact.super.getArchitectureFilterName();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitLogicalProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    @IntProperty(undefinedValue=0)
    public final int getSourceElementCount() {
        int sec = 0;
        for (ProgrammingElement programmingElement : this.getProgrammingElements()) {
            int nextSec = programmingElement.getSourceElementCount();
            if (nextSec == -1) continue;
            sec += nextSec;
        }
        return sec;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (ProgrammingElement programmingElement : this.getProgrammingElements()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Programming element: [");
            builder.append(Integer.toHexString(programmingElement.hashCode()));
            builder.append("] ");
            builder.append(programmingElement.getFullyQualifiedName());
            builder.append(" [");
            builder.append(programmingElement.getClass().getName());
            builder.append("]");
            IFile file = programmingElement.getParent(IFile.class, ParentMode.FIRST_PARENT);
            if (file == null) continue;
            builder.append(" - File: " + file.getIdentifyingPath());
        }
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitLogicalProgrammingElement(LogicalProgrammingElement var1);
    }
}

