/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.ILogicalProgrammingElementOwner;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElementHelper;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public abstract class LogicalNamespace
extends NamedElementContainer
implements IRecursiveElement,
ILogicalProgrammingElementContainer,
ILogicalElement,
ILogicalProgrammingElementOwner {
    public static final String NAMESPACE_FRAGMENT = "NamespaceFragment";
    public static final String NAMESPACE_FRAGMENT_PART = "NamespaceFragmentPart";
    private final ArrayList<NamedElement> m_sourceNamespaces = new ArrayList();
    private final String m_shortName;
    private boolean m_isValid = true;

    public LogicalNamespace(NamedElement parent, String shortName) {
        super(parent);
        assert (shortName != null) : "Parameter 'name' of method 'LogicalNamespace' must not be null";
        this.m_shortName = shortName.intern();
    }

    @Override
    public final String getSeparator() {
        Language language = this.getLanguage();
        assert (language != null) : "'language' of method 'getSeparator' must not be null";
        return language.getNamespaceSeparator();
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    public abstract IMetricLevel getMetricLevel();

    public final boolean isGlobal() {
        return this.m_shortName.equals(this.getGlobalNamespaceName());
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart();
    }

    @Override
    public final RefactoringState getRefactoringState() {
        for (NamedElement next : this.m_sourceNamespaces) {
            if (next.getRepresentative().getRefactoringState() != RefactoringState.REFACTORED) continue;
            return RefactoringState.REFACTORED;
        }
        return RefactoringState.NONE;
    }

    @Override
    public final boolean hasBeenDirectlyRefactored() {
        for (NamedElement next : this.m_sourceNamespaces) {
            if (!next.getRepresentative().hasBeenDirectlyRefactored()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Property
    public final String getInformation() {
        IDomainRoot context = this.getParent(IDomainRoot.class, new Class[0]);
        return context != null ? context.getDomainInfo() : "";
    }

    @Override
    public final List<? extends NamedElement> getAllChildren() {
        return super.getAllChildren();
    }

    protected void createDirectChildren(List<ProgrammingElement> programmingElements) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'createDirectChildren' must not be empty";
        LogicalProgrammingElementHelper.createDirectChildren(programmingElements, this);
    }

    @Override
    public final void finishModification() {
        this.m_sourceNamespaces.trimToSize();
        super.finishModification();
    }

    public final void finishCreation(List<ProgrammingElement> programmingElements) {
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'finishCreation' must not be null";
        if (!programmingElements.isEmpty()) {
            this.createDirectChildren(Collections.unmodifiableList(programmingElements));
            this.getChildren(LogicalProgrammingElement.class).forEach(c -> c.finishModification());
        }
    }

    public abstract LogicalNamespaceScope getScope();

    @Override
    public final String getShortName() {
        return this.m_shortName;
    }

    private void appendShortName(StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'appendShortName' must not be null";
        NamedElement parent = this.getParent();
        if (parent != null && this.getClass().isAssignableFrom(parent.getClass())) {
            ((LogicalNamespace)parent).appendShortName(builder);
            builder.append(this.getSeparator());
        }
        builder.append(this.getShortName());
    }

    @Override
    public final String getName() {
        StringBuilder builder = new StringBuilder();
        this.appendShortName(builder);
        return builder.toString();
    }

    @Override
    public final String getImageResourceName() {
        if (this.isPart()) {
            return NAMESPACE_FRAGMENT_PART;
        }
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResource() {
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResourcePart() {
        return NAMESPACE_FRAGMENT_PART;
    }

    @Override
    public final boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public final StructureItem getStructureItem() {
        return StructureItem.LOGICAL_NAMESPACE;
    }

    protected abstract String getGlobalNamespaceName();

    protected abstract String getNamespaceSeparator();

    public final List<ProgrammingElement> getTopLevelProgrammingElements() {
        ArrayList<ProgrammingElement> toplevel = new ArrayList<ProgrammingElement>();
        for (LogicalProgrammingElement nextToplevel : this.getChildren(LogicalProgrammingElement.class)) {
            toplevel.addAll(nextToplevel.getProgrammingElements());
        }
        return toplevel;
    }

    public final List<ProgrammingElement> getAllProgrammingElements() {
        ArrayList<ProgrammingElement> all = new ArrayList<ProgrammingElement>();
        for (LogicalProgrammingElement nextToplevel : this.getChildren(LogicalProgrammingElement.class)) {
            all.addAll(nextToplevel.getProgrammingElements());
            for (LogicalProgrammingElement nextChild : nextToplevel.getChildrenRecursively(LogicalProgrammingElement.class, new Class[0])) {
                all.addAll(nextChild.getProgrammingElements());
            }
        }
        return all;
    }

    public final List<ProgrammingElement> getAllProgrammingElementsRecursively(LogicalNamespace ... except) {
        List<ProgrammingElement> all = this.getAllProgrammingElements();
        block0: for (LogicalNamespace nextNs : this.getChildren(LogicalNamespace.class)) {
            LogicalNamespace[] logicalNamespaceArray = except;
            int n = except.length;
            int n2 = 0;
            while (n2 < n) {
                LogicalNamespace exceptedNs = logicalNamespaceArray[n2];
                if (exceptedNs == nextNs) continue block0;
                ++n2;
            }
            all.addAll(nextNs.getAllProgrammingElementsRecursively(except));
        }
        return all;
    }

    public final List<ProgrammingElement> getAllProgrammingElements(boolean isRecursive, LogicalNamespace ... except) {
        assert (except.length == 0 || isRecursive) : "Excepted namespaces only make sense if recursion is on";
        if (isRecursive) {
            return this.getAllProgrammingElementsRecursively(except);
        }
        return this.getAllProgrammingElements();
    }

    public List<LogicalProgrammingElement> getPath(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getPath' must not be null";
        LogicalProgrammingElementFinder finder = new LogicalProgrammingElementFinder(this, programmingElement);
        this.accept(finder);
        LogicalProgrammingElement found = finder.getFound();
        if (found != null) {
            List<LogicalProgrammingElement> parents = found.getParents(LogicalProgrammingElement.class, LogicalNamespace.class);
            ArrayList<LogicalProgrammingElement> path = new ArrayList<LogicalProgrammingElement>(parents.size() + 1);
            if (!parents.isEmpty()) {
                ListIterator<LogicalProgrammingElement> iter = parents.listIterator(parents.size());
                while (iter.hasPrevious()) {
                    LogicalProgrammingElement nextParent = iter.previous();
                    path.add(nextParent);
                }
            }
            path.add(found);
            return path;
        }
        return Collections.emptyList();
    }

    @Override
    @Property
    public final boolean isPart() {
        return !this.hasChildren(false, LogicalProgrammingElement.class);
    }

    @Override
    @Property
    public final boolean isMixable() {
        List<NamedElement> children = this.getChildren();
        return children.size() == 1 && children.get(0) instanceof IRecursiveElement;
    }

    @Override
    @Property
    public final boolean isExternal() {
        return this.getParent().isExternal();
    }

    public final void connect(ISourceNamespace sourceNamespace) {
        assert (sourceNamespace != null) : "Parameter 'sourceNamespace' of method 'connect' must not be null";
        switch (this.getScope()) {
            case SYSTEM: {
                sourceNamespace.setSystemNamespace(this);
                break;
            }
            case MODULE: {
                sourceNamespace.setModuleNamespace(this);
                break;
            }
            default: {
                assert (false) : "Unhandled scope: " + String.valueOf((Object)this.getScope());
                break;
            }
        }
        NamedElement original = sourceNamespace.getNamedElement().getOriginal();
        assert (original != null && original instanceof ISourceNamespace) : "Unexpected class in method 'connect': " + String.valueOf(original);
        assert (!this.m_sourceNamespaces.contains(original)) : "'m_sourceNamespaces' of method 'connect' already contains: " + String.valueOf(original);
        this.m_sourceNamespaces.add(original);
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public final void disconnect() {
        switch (this.getScope()) {
            case SYSTEM: {
                this.m_sourceNamespaces.forEach(sn -> ((ISourceNamespace)((Object)sn.getRepresentative())).setSystemNamespace(null));
                break;
            }
            case MODULE: {
                this.m_sourceNamespaces.forEach(sn -> ((ISourceNamespace)((Object)sn.getRepresentative())).setModuleNamespace(null));
                break;
            }
            default: {
                assert (false) : "Unhandled scope: " + String.valueOf((Object)this.getScope());
                break;
            }
        }
        this.m_isValid = false;
    }

    public final boolean hasSourceNamespaces() {
        return !this.m_sourceNamespaces.isEmpty();
    }

    public final List<ISourceNamespace> getRepresentativeSourceNamespaces() {
        return Collections.unmodifiableList(this.m_sourceNamespaces.stream().map(n -> n.getRepresentative()).map(ISourceNamespace.class::cast).collect(Collectors.toList()));
    }

    public final List<ISourceNamespace> getOriginalSourceNamespaces() {
        return Collections.unmodifiableList(this.m_sourceNamespaces.stream().map(ISourceNamespace.class::cast).collect(Collectors.toList()));
    }

    public final List<LogicalNamespace> getNonPartLogicalNamespaces() {
        ArrayList<LogicalNamespace> nonParts = new ArrayList<LogicalNamespace>();
        for (LogicalNamespace next : this.getChildrenRecursively(LogicalNamespace.class, new Class[0])) {
            if (next.isPart()) continue;
            nonParts.add(next);
        }
        return nonParts;
    }

    @Override
    public final String getArchitectureFilterNamePart() {
        if (this.isGlobal()) {
            return "";
        }
        String part = this.getName().replace(this.getNamespaceSeparator(), "/");
        return part.isEmpty() ? part : part + "/";
    }

    @Override
    public final String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getArchitectureFilterName' must not be null";
        if (this.isGlobal()) {
            return provider.getArchitectureFilterNamePrefix() + "*";
        }
        return provider.getArchitectureFilterNamePrefix() + this.getArchitectureFilterNamePart() + "**";
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitLogicalNamespace(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        if (!this.m_sourceNamespaces.isEmpty()) {
            builder.append("Has ").append(this.m_sourceNamespaces.size()).append(" source namespace(s):");
            builder.append("\n");
            int i = 1;
            for (NamedElement next : this.m_sourceNamespaces) {
                builder.append("[").append(i).append("] ").append(next);
                builder.append("\n");
                NamedElement representative = next.getRepresentative();
                if (next != representative) {
                    builder.append("-> Representative: ").append(representative);
                    builder.append("\n");
                }
                ++i;
            }
        }
        return builder.toString();
    }

    public static interface ISourceNamespace {
        public NamedElement getNamedElement();

        public LogicalNamespace getModuleNamespace();

        public void setModuleNamespace(LogicalNamespace var1);

        public LogicalNamespace getSystemNamespace();

        public void setSystemNamespace(LogicalNamespace var1);

        public TFile getPhysicalCorrespondent();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitLogicalNamespace(LogicalNamespace var1);
    }

    static final class LogicalProgrammingElementFinder
    extends NamedElementVisitor
    implements IVisitor,
    LogicalProgrammingElement.IVisitor {
        private final LogicalNamespace m_inLogicalNamespace;
        private final ProgrammingElement m_programmingElement;
        private LogicalProgrammingElement m_found;

        LogicalProgrammingElementFinder(LogicalNamespace inLogicalNamespace, ProgrammingElement programmingElement) {
            assert (inLogicalNamespace != null) : "Parameter 'inLogicalNamespace' of method 'LogicalProgrammingElementFinder' must not be null";
            assert (programmingElement != null) : "Parameter 'programmingElement' of method 'LogicalProgrammingElementFinder' must not be null";
            this.m_inLogicalNamespace = inLogicalNamespace;
            this.m_programmingElement = programmingElement;
        }

        @Override
        public boolean done() {
            return this.m_found != null;
        }

        @Override
        public void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitLogicalProgrammingElement' must not be null";
            for (ProgrammingElement programmingElement : element.getProgrammingElements()) {
                if (programmingElement != this.m_programmingElement) continue;
                this.m_found = element;
                break;
            }
            this.visitChildrenOf(element);
        }

        @Override
        public void visitLogicalNamespace(LogicalNamespace element) {
            assert (element != null) : "Parameter 'element' of method 'visitLogicalNamespace' must not be null";
            if (element == this.m_inLogicalNamespace) {
                this.visitChildrenOf(element);
            }
        }

        LogicalProgrammingElement getFound() {
            return this.m_found;
        }
    }
}

