/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graphview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNodeDependencyFlags;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GraphViewCycleGroupNode
extends GraphViewNode {
    private final String m_id;
    private AnalyzerCycleGroup m_basedOn;

    public GraphViewCycleGroupNode(GraphViewElement parent, int level, int index) {
        super(parent, level);
        this.m_id = "CycleGroup_" + String.valueOf(index);
    }

    @Override
    public String getShortName() {
        return (this.m_basedOn != null ? this.m_basedOn.getShortName() : "Cycle group") + " (" + this.getNumberOfChildren() + ")";
    }

    @Override
    public String getPresentationKind() {
        return "Cycle Group";
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.m_id;
    }

    @Override
    public NamedElement getNamedElement() {
        return this.m_basedOn != null ? this.m_basedOn : this;
    }

    @Override
    public NamedElement getUnderlyingObject() {
        return this.getNamedElement();
    }

    @Override
    public boolean isCyclic() {
        return false;
    }

    public void setIsExpandable(boolean cycleGroupsAreExpandable) {
        this.setFlags(GraphViewNodeDependencyFlags.setEnabled(cycleGroupsAreExpandable, this.getFlags(), (byte)4));
    }

    @Override
    public boolean isExpandable() {
        return GraphViewNodeDependencyFlags.isEnabled(this.getFlags(), (byte)4);
    }

    public synchronized void setBasedOn(AnalyzerCycleGroup basedOn) {
        this.m_basedOn = basedOn;
    }

    public synchronized AnalyzerCycleGroup getBasedOn() {
        return this.m_basedOn;
    }

    @Override
    protected List<IDependency> getDependencyAdapters(GraphViewNode to) {
        assert (to != null) : "Parameter 'to' of method 'getDependencyAdapters' must not be null";
        List<GraphViewNode> childNodes = this.getChildren(GraphViewNode.class);
        if (!childNodes.isEmpty()) {
            ArrayList<IDependency> dependencyAdapters = new ArrayList<IDependency>();
            for (GraphViewNode nextChild : childNodes) {
                GraphViewNode.GraphViewDependency nextOut = nextChild.getOutgoingDependency(to);
                if (nextOut == null) continue;
                dependencyAdapters.add(new DependenciesViewDependencyAdapter((NamedElement)nextChild.getUnderlyingObject(), (NamedElement)to.getUnderlyingObject(), new ArrayList<ParserDependency>(nextOut.getParserDependencies())));
            }
            return dependencyAdapters;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized List<NamedElement> getAdaptedTo() {
        return this.m_basedOn != null ? Collections.singletonList(this.m_basedOn) : Collections.emptyList();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGraphViewCycleGroupNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGraphViewCycleGroupNode(GraphViewCycleGroupNode var1);
    }
}

