/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.generic.programming;

import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;

public class GenericWorkspaceDependency
extends WorkspaceDependency {
    public static final WorkspaceDependency.IWorkspaceDependencyType DEFAULT_TYPE = GenericWorkspaceDependencyType.WORKSPACE_DEPENDENCY;
    private GenericWorkspaceDependencyType m_type;

    public GenericWorkspaceDependency(IWorkspaceDependencyElement from) {
        super(from);
        this.m_type = GenericWorkspaceDependencyType.WORKSPACE_DEPENDENCY;
    }

    public GenericWorkspaceDependency(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to, WorkspaceDependency.IWorkspaceDependencyType type) {
        super(from, to);
        this.m_type = (GenericWorkspaceDependencyType)type;
    }

    @Override
    public WorkspaceDependency.IWorkspaceDependencyType getType() {
        return DEFAULT_TYPE;
    }

    @Override
    public boolean isGenerated() {
        return this.m_type == GenericWorkspaceDependencyType.GENERATED_WORKSPACE_DEPENDENCY;
    }

    @Override
    public String getPresentationKind() {
        return "Workspace Dependency";
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_type.name());
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() >= 27) {
            this.m_type = GenericWorkspaceDependencyType.valueOf(reader.readString());
        }
    }

    public static enum GenericWorkspaceDependencyType implements WorkspaceDependency.IWorkspaceDependencyType
    {
        WORKSPACE_DEPENDENCY,
        GENERATED_WORKSPACE_DEPENDENCY;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

