/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.generic.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class GenericFunction
extends ProgrammingElementWithChildren
implements IRoutine {
    private int m_numberOfParameters = -1;

    public GenericFunction(NamedElement parent) {
        super(parent);
    }

    public GenericFunction(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int numberOfParameters) {
        super(msp, parent, name, lineNumber);
        this.m_numberOfParameters = numberOfParameters;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.getLineNumber());
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return "Function";
    }

    @Override
    @IntProperty
    public int getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    @Override
    public int getNumberOfStatements() {
        return -1;
    }

    @Override
    public int getCyclomaticComplexity() {
        return -1;
    }

    @Override
    public int getExtendedCyclomaticComplexity() {
        return -1;
    }

    @Override
    public int getModifiedExtendedCyclomaticComplexity() {
        return -1;
    }

    @Override
    public int getModifiedCyclomaticComplexity() {
        return -1;
    }

    @Override
    public int getMaxNesting() {
        return -1;
    }

    @Override
    public List<String> getArgumentTypes() {
        return Collections.emptyList();
    }

    @Override
    public String getReturnType() {
        return null;
    }

    @Override
    public boolean isMember() {
        return this.getParent() instanceof IType;
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfParameters = reader.readInt();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfParameters);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitGenericFunctionWithoutBody(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitGenericFunctionWithoutBody(GenericFunction var1);
    }
}

