/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactFilterOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilterOperation;

public final class EditArtifactOperation
extends ArtifactFilterOperation {
    private final String m_artifact;
    private ManualFilterOperation m_filterOperation = ManualFilterOperation.NONE;

    public EditArtifactOperation(NamedElement parent, PresentationMode presentationMode, String targetParent, int targetPos, ArtifactProperties properties, String artifact, String artifactName) {
        super(parent, presentationMode, targetParent, targetPos, properties, artifactName);
        assert (artifact != null && artifact.length() > 0) : "Parameter 'artifact' of method 'EditArtifactOperation' must not be empty";
        this.m_artifact = artifact;
    }

    private EditArtifactOperation(NamedElement parent, EditArtifactOperation copyOf) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'EditArtifactOperation' must not be null";
        this.m_artifact = copyOf.m_artifact;
    }

    @Override
    public ArchitecturalViewOperation copy(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'copy' must not be null";
        return new EditArtifactOperation(parent, this);
    }

    public String getArtifact() {
        return this.m_artifact;
    }

    @Override
    public String getShortName() {
        return "Edit artifact";
    }

    public final void setFilterOperation(ManualFilterOperation filterOperation) {
        assert (filterOperation != null) : "Parameter 'filterOperation' of method 'setFilterOperation' must not be null";
        this.m_filterOperation = filterOperation;
    }

    @Override
    public String getInformation() {
        StringBuilder builder = new StringBuilder(super.getInformation());
        builder.append(" '").append(this.getArtifactName()).append("'");
        String targetParent = this.getTargetParentPresentationName();
        if (!targetParent.isEmpty()) {
            builder.append(" underneath '").append(targetParent).append("'");
        }
        switch (this.m_filterOperation) {
            case ADDED: 
            case MODIFIED: 
            case REMOVED: {
                builder.append(" [Manual filter ").append(this.m_filterOperation.getPresentationName().toLowerCase()).append("]");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false) : "Unhandled filter operation: " + String.valueOf((Object)this.m_filterOperation);
                break;
            }
        }
        return builder.toString();
    }

    @Override
    public void apply(IArchitecturalViewOperationExecutor executor) {
        assert (executor != null) : "Parameter 'executor' of method 'apply' must not be null";
        this.m_filterOperation = executor.editArtifact(this, this.getTargetParent(), this.getTargetPos(), this.getArtifactProperties(), this.m_artifact, this.getArtifactName(), this.getManualFilter());
        assert (this.m_filterOperation != null) : "'m_filterOperation' of method 'apply' must not be null";
    }
}

