/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public final class ArchitecturalViewFinding
extends NamedElement {
    private final String m_name;
    private final String m_description;
    private final boolean m_ignoreViolations;
    private final Set<ParserDependency> m_parserDependencies;
    private final int m_index;
    private String m_information = "";

    public ArchitecturalViewFinding(NamedElement parent, String name, String description, boolean ignoreViolations, Set<ParserDependency> parserDependencies, int index) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewFinding' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ArchitecturalViewFinding' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'ArchitecturalViewFinding' must not be null";
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "Parameter 'parserDependencies' of method 'ArchitecturalViewFinding' must not be empty";
        this.m_name = name;
        this.m_description = description;
        this.m_ignoreViolations = ignoreViolations;
        this.m_parserDependencies = new THashSet(parserDependencies);
        this.m_index = index;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public int getIndex() {
        return this.m_index;
    }

    @Override
    public ImageDecoratorInfo getImageResourceDecoratorInfo() {
        if (this.hasIssues(CoreIssueId.ARCHITECTURAL_VIEW_FINDING_CONTAINS_SAME_DEPENDENCIES)) {
            return new ImageDecoratorInfo("WarningMarker", null, null, null);
        }
        return super.getImageResourceDecoratorInfo();
    }

    public void setInformation(String information) {
        assert (information != null) : "Parameter 'information' of method 'setInformation' must not be null";
        this.m_information = information;
    }

    @Override
    public String getInformation() {
        return this.m_information;
    }

    public boolean ignoreViolations() {
        return this.m_ignoreViolations;
    }

    public Set<ParserDependency> getParserDependencies() {
        return Collections.unmodifiableSet(this.m_parserDependencies);
    }
}

