/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.List;
import java.util.Set;

public abstract class Issue
extends Element
implements IIssue {
    public static final String KEY_SEPARATOR = ":";
    private IResolution m_resolution;

    protected Issue() {
    }

    public abstract IIssueId getId();

    public abstract IProviderId getProvider();

    public Severity getSeverity() {
        List<Severity> supportedSeverities = this.getId().getSupportedSeverities();
        assert (supportedSeverities != null && supportedSeverities.size() == 1) : "Unexpected number of severities for issue " + String.valueOf(this);
        return supportedSeverities.get(0);
    }

    @Override
    public Set<AnalyzerGroup> getAdditionallyAffectedAnalyzerGroups() {
        return null;
    }

    public final boolean isIgnored() {
        return this.m_resolution != null && this.m_resolution.ignores();
    }

    public final boolean toBeFixed() {
        return this.m_resolution != null && !this.m_resolution.ignores();
    }

    @Property
    public final String getCategory() {
        return this.getId().getCategory().getStandardName();
    }

    @Property
    public final String id() {
        return this.getId().getStandardName();
    }

    @Property
    public final String getType() {
        return this.getId().getQualifiedName();
    }

    public final boolean previewOnly() {
        return this.getId().previewOnly();
    }

    @Override
    public String getKey() {
        return this.getId().getStandardName();
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return this.getId().persist();
    }

    @Override
    public int getLineNumber() {
        return this.getAffectedElement().getLineNumber();
    }

    @Override
    public String getImageResourceName() {
        IResolution resolution = this.getResolution();
        if (resolution != null) {
            return resolution.getImageResourceName();
        }
        return this.getSeverity().getStandardName();
    }

    @Override
    public final String getShortName() {
        return this.getId().getPresentationName();
    }

    @Override
    public final boolean isExternal() {
        return false;
    }

    @Override
    public final RefactoringState getRefactoringState() {
        return RefactoringState.NONE;
    }

    @Override
    public boolean hasBeenDirectlyRefactored() {
        return false;
    }

    public int getColumn() {
        return -1;
    }

    public String getDescriptorContribution() {
        return "n/a";
    }

    public final void setResolution(IResolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'setResolution' must not be null";
        this.m_resolution = resolution;
        resolution.addAssociatedIssue(this);
    }

    public final IResolution getResolution() {
        return this.m_resolution;
    }

    public final <T extends IResolution> T getResolution(Class<T> resolutionClass) {
        assert (resolutionClass != null) : "Parameter 'resolutionClass' of method 'getResolution' must not be null";
        if (this.m_resolution == null) {
            return null;
        }
        if (resolutionClass.isAssignableFrom(this.m_resolution.getClass())) {
            return (T)this.m_resolution;
        }
        return null;
    }

    @Override
    public final void reset() {
        this.m_resolution = null;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n");
        builder.append("Id: ");
        builder.append(this.getId().getStandardName());
        builder.append("\n");
        builder.append("Affected element class: ");
        builder.append(this.getAffectedElement().getClass().getName());
        builder.append("\n");
        builder.append("### Affected element ###");
        builder.append("\n");
        builder.append(this.getAffectedElement().getDebugInfo());
        builder.append("\n");
        builder.append("### Affected element ###");
        return builder.toString();
    }
}

