/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Set;

public class NotFilter
extends NamedElement
implements IAssignableFilter {
    private final IAssignableFilter m_filter;
    private int m_matchingCount = 0;

    public NotFilter(IAssignableFilter filter) {
        super(null);
        this.m_filter = filter;
    }

    @Override
    public String getShortName() {
        return this.getOriginalPattern();
    }

    @Override
    public int getLineNumber() {
        return this.m_filter.getLineNumber();
    }

    @Override
    public void reset() {
        this.m_matchingCount = 0;
        this.m_filter.reset();
    }

    @Override
    public boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable) {
        if (!this.m_filter.matches(workerContext, assignable)) {
            ++this.m_matchingCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(IWorkerContext workerContext, IAssignableToArtifact assignable, String context, Set<String> multipleAttributeInfoCollector) {
        if (!this.m_filter.matches(workerContext, assignable, context, multipleAttributeInfoCollector)) {
            ++this.m_matchingCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStrong() {
        return this.m_filter.isStrong();
    }

    @Override
    public String getOriginalPattern() {
        return "not \"" + this.m_filter.getOriginalPattern() + "\"";
    }

    @Override
    public String[] getLastCaptureGroups() {
        return this.m_filter.getLastCaptureGroups();
    }

    @Override
    public int getMatchingCount() {
        return this.m_matchingCount;
    }

    @Override
    public NotFilter clone() {
        return (NotFilter)super.clone();
    }
}

