/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ConnectionSchemeConnection;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Identifier;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConnectionScheme
extends NamedElement
implements IArchitectureElement {
    private final String m_name;
    private final FilePath m_definingFile;
    private final int m_lineNumber;
    private List<ConnectionSchemeConnection> m_connections = new ArrayList<ConnectionSchemeConnection>();
    private final String m_fromClassName;
    private final String m_toClassName;

    public ConnectionScheme(NamedElement parent, String name, FilePath definingFile, int line, String fromClassName, String toClassName) {
        super(parent);
        this.m_name = name;
        this.m_definingFile = definingFile;
        this.m_lineNumber = line;
        this.m_connections = new ArrayList<ConnectionSchemeConnection>();
        this.m_fromClassName = fromClassName;
        this.m_toClassName = toClassName;
    }

    public ConnectionScheme(NamedElement parent, ConnectionScheme copyFrom) {
        super(parent);
        this.m_name = copyFrom.m_name;
        this.m_definingFile = copyFrom.m_definingFile;
        this.m_lineNumber = copyFrom.m_lineNumber;
        this.m_connections = copyFrom.m_connections;
        this.m_fromClassName = copyFrom.m_fromClassName;
        this.m_toClassName = copyFrom.m_toClassName;
    }

    public String getFromClassName() {
        return this.m_fromClassName;
    }

    public String getToClassName() {
        return this.m_toClassName;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.getParent(IDomainRoot.class, new Class[0]).getDomain();
    }

    @Override
    public FilePath getDefiningFile() {
        return this.m_definingFile;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return "scheme " + this.getShortName();
    }

    public void addConnection(Identifier from, List<Identifier> to, boolean any) {
        this.m_connections.add(new ConnectionSchemeConnection(from, to, any));
    }

    public List<ConnectionSchemeConnection> getConnections() {
        return Collections.unmodifiableList(this.m_connections);
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitConnectionScheme(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitConnectionScheme(ConnectionScheme var1);
    }
}

