/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;

public final class AssignedElement
extends NamedElement
implements IArchitectureAssignmentElement,
IArchitectureFilterNameProvider,
IWorkspaceFilterNameProvider {
    private final IAssignableToArtifact m_element;

    public AssignedElement(NamedElement parent, IAssignableToArtifact assignable) {
        super(parent);
        assert (assignable != null) : "Parameter 'assignable' of method 'AssignedElement' must not be null";
        this.m_element = assignable;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        IDomainRoot domainRoot = this.getParent(IDomainRoot.class, new Class[0]);
        assert (domainRoot != null) : "'domainRoot' of method 'getDomain' must not be null";
        return domainRoot.getDomain();
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    public IAssignableToArtifact getAssignable() {
        return this.m_element;
    }

    @Override
    public String getPresentationKind() {
        return this.m_element.getNamedElement().getPresentationKind();
    }

    @Override
    public NamedElement getRepresentedElement() {
        return this.m_element.getNamedElement();
    }

    @Override
    public RefactoringState getRefactoringState() {
        return this.getRepresentedElement().getRefactoringState();
    }

    @Override
    public boolean hasBeenDirectlyRefactored() {
        return this.getRepresentedElement().hasBeenDirectlyRefactored();
    }

    @Override
    public String getImageResourceName() {
        return this.getRepresentedElement().getImageResourceName();
    }

    @Override
    public Language getLanguage() {
        return this.getRepresentedElement().getLanguage();
    }

    @Override
    public String getName() {
        return this.getRepresentedElement().getName();
    }

    @Override
    public String getShortName() {
        return this.getRepresentedElement().getShortName();
    }

    @Override
    public boolean isExternal() {
        return this.getRepresentedElement().isExternal();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getRepresentedElement().getFullyQualifiedNamePart();
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return this.getRepresentedElement().getPresentationName(parentIsPresented);
    }

    @Override
    public String getDescription() {
        return this.getRepresentedElement().getDescription();
    }

    @Override
    public int getLineNumber() {
        return this.getRepresentedElement().getLineNumber();
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public StructureItem getStructureItem() {
        if (this.getDomain() == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            return StructureItem.LOGICAL_PROGRAMMING_ELEMENT;
        }
        return StructureItem.COMPONENT;
    }

    @Override
    public boolean isOfStructureItem(StructureItem structureItem) {
        assert (structureItem != null) : "Parameter 'structureItem' of method 'isOfStructureItem' must not be null";
        if (this.getDomain() == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            return structureItem == StructureItem.LOGICAL_PROGRAMMING_ELEMENT;
        }
        return structureItem == StructureItem.COMPONENT;
    }

    @Override
    public String getWorkspaceFilterName() {
        return this.m_element.getWorkspaceFilterName();
    }

    @Override
    public String getArchitectureFilterName() {
        return this.m_element.getArchitectureFilterName();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitAssignedElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitAssignedElement(AssignedElement var1);
    }
}

