/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArtifactClass
extends NamedElement
implements IArchitectureElement {
    private final String m_name;
    private final FilePath m_definingFile;
    private final int m_lineNumber;
    private List<String> m_interfaces = new ArrayList<String>();
    private List<String> m_connectors = new ArrayList<String>();

    public ArtifactClass(NamedElement parent, String name, FilePath definingFile, int lineNumber) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArtifactClass' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ArtifactClass' must not be empty";
        assert (definingFile != null) : "Parameter 'definingFile' of method 'ArtifactClass' must not be null";
        assert (lineNumber > 0);
        this.m_name = name;
        this.m_definingFile = definingFile;
        this.m_lineNumber = lineNumber;
    }

    public ArtifactClass(NamedElement parent, ArtifactClass other) {
        super(parent);
        assert (other != null) : "Parameter 'other' of method 'ArtifactClass' must not be null";
        this.m_name = other.m_name;
        this.m_definingFile = other.m_definingFile;
        this.m_lineNumber = other.m_lineNumber;
        this.m_interfaces = other.m_interfaces;
        this.m_connectors = other.m_connectors;
    }

    @Override
    public String getImageResourceName() {
        return "Class";
    }

    public void addInterface(String name) {
        assert (name != null) : "Parameter 'name' of method 'addInterface' must not be null";
        this.m_interfaces.add(name);
    }

    public void addConnector(String name) {
        assert (name != null) : "Parameter 'name' of method 'addConnector' must not be null";
        this.m_connectors.add(name);
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(this.m_interfaces);
    }

    public List<String> getConnectors() {
        return Collections.unmodifiableList(this.m_connectors);
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public FilePath getDefiningFile() {
        return this.m_definingFile;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.getParent(IDomainRoot.class, new Class[0]).getDomain();
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifactClass(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifactClass(ArtifactClass var1);
    }
}

