/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class LogicalToplevelElementCyclesAnalyzerConfiguration
extends AnalyzerConfiguration {
    public static final IConfigurationCreator CREATOR_LOGICAL_TOPLEVEL_ELEMENT_CYCLES = new IConfigurationCreator(){

        @Override
        public AnalyzerConfiguration create(NamedElement parent, IAnalyzerId analyzerId) {
            return new LogicalToplevelElementCyclesAnalyzerConfiguration(parent, analyzerId);
        }

        @Override
        public String getImageResourceName() {
            return "CriticalCycleGroupSizeConfiguration";
        }
    };
    private static final String DESCRIPTION = "Logical toplevel elements (Namespaces view) are the logical equivalents to the physical components (Navigation view). They are the smallest assignable units used when creating logical Architecture (DSL) aspects. Logical toplevel element cycles that share the exact same parser dependencies as Component cycles are marked as a Duplicate and do not create issues. Logical toplevel element cycles potentially increase the Entanglement metrics.\n\nNOTE: For a system using a language that does not support a logical model the analyzer will remain inactive!";
    private final ExecutionModeConfigurationEntryDescriptor m_executionMode;
    private final CycleGroupSizeEntryDescriptor m_criticalSizeModule;
    private final CycleGroupSizeEntryDescriptor m_criticalSizeSystem;

    public LogicalToplevelElementCyclesAnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent, analyzerId);
        this.m_executionMode = new ExecutionModeConfigurationEntryDescriptor();
        this.addValue(this.m_executionMode.getStandardName(), this.m_executionMode.getDefaultValue());
        this.m_criticalSizeModule = CycleGroupSizeEntryDescriptor.CRITICAL_SIZE_MODULE;
        this.addValue(this.m_criticalSizeModule.getStandardName(), this.m_criticalSizeModule.getDefaultValue());
        this.m_criticalSizeSystem = CycleGroupSizeEntryDescriptor.CRITICAL_SIZE_SYSTEM;
        this.addValue(this.m_criticalSizeSystem.getStandardName(), this.m_criticalSizeSystem.getDefaultValue());
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void reset() {
        super.reset();
        this.addValue(this.m_executionMode.getStandardName(), this.m_executionMode.getDefaultValue());
        this.addValue(this.m_criticalSizeModule.getStandardName(), this.m_criticalSizeModule.getDefaultValue());
        this.addValue(this.m_criticalSizeSystem.getStandardName(), this.m_criticalSizeSystem.getDefaultValue());
    }

    private LogicalToplevelElementCyclesAnalyzerConfiguration(LogicalToplevelElementCyclesAnalyzerConfiguration configuration) {
        super(configuration);
        assert (configuration != null) : "Parameter 'configuration' of method 'CycleAnalyzerConfiguration' must not be null";
        this.m_executionMode = configuration.m_executionMode;
        this.m_criticalSizeModule = configuration.m_criticalSizeModule;
        this.m_criticalSizeSystem = configuration.m_criticalSizeSystem;
    }

    @Override
    public AnalyzerConfiguration copy() {
        return new LogicalToplevelElementCyclesAnalyzerConfiguration(this);
    }

    @Override
    public void validateValuesFromPersistence(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'validateValuesFromPersistence' must not be null";
        Object executionMode = this.getValue(this.m_executionMode.getStandardName());
        if (!(executionMode instanceof String) || !"Inactive".equals(executionMode) && !"Active".equals(executionMode)) {
            result.addWarning((OperationResult.IMessageCause)AnalyzerConfiguration.AnalyzerConfigurationCause.INVALID_VALUE_IN_ANALYZER_CONFIGURATION, "\nAnalyzer configuration: " + this.getAnalyzerId().getStandardName() + ".xml\n'" + String.valueOf(executionMode) + "' is not a supported value for 'ExecutionMode'\nSupported values are: Inactive, Active\nExecution mode set to: Inactive", new Object[0]);
            this.setValue(this.m_executionMode.getStandardName(), "Inactive");
        }
    }

    public AnalyzerConfiguration.IOptionConfigurationEntryDescriptor getDescriptorExecutionMode() {
        return this.m_executionMode;
    }

    @Property
    public String getDefaultExecutionModeValue() {
        return this.m_executionMode.getDefaultValue();
    }

    @Property
    public String getExecutionModeValue() {
        return (String)this.getValue(this.m_executionMode.getStandardName());
    }

    public void setExecutionModeValue(String mode) {
        this.setValue(this.m_executionMode.getStandardName(), mode);
    }

    public boolean isActive() {
        switch (this.getExecutionModeValue()) {
            case "Inactive": {
                return false;
            }
            case "Active": {
                return true;
            }
        }
        assert (false) : "Unhandled execution mode value: " + this.getExecutionModeValue();
        return false;
    }

    public AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor getDescriptorCriticalSizeModule() {
        return this.m_criticalSizeModule;
    }

    @Property
    public int getDefaultValueCriticalSizeModule() {
        return this.m_criticalSizeModule.getDefaultValue();
    }

    @Property
    public int getCriticalSizeModule() {
        return (Integer)this.getValue(this.m_criticalSizeModule.getStandardName());
    }

    public void setCriticalSizeModule(int criticalCycleGroupSize) {
        this.setValue(this.m_criticalSizeModule.getStandardName(), criticalCycleGroupSize);
    }

    public AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor getDescriptorCriticalSizeSystem() {
        return this.m_criticalSizeSystem;
    }

    @Property
    public int getDefaultValueCriticalSizeSystem() {
        return this.m_criticalSizeSystem.getDefaultValue();
    }

    @Property
    public int getCriticalCycleSizeSystem() {
        return (Integer)this.getValue(this.m_criticalSizeSystem.getStandardName());
    }

    public void setCriticalSizeSystem(int criticalCycleGroupSize) {
        this.setValue(this.m_criticalSizeSystem.getStandardName(), criticalCycleGroupSize);
    }

    private static final class CycleGroupSizeEntryDescriptor
    extends Enum<CycleGroupSizeEntryDescriptor>
    implements AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor {
        public static final /* enum */ CycleGroupSizeEntryDescriptor CRITICAL_SIZE_MODULE = new CycleGroupSizeEntryDescriptor(6, 2, 9999999, "Critical Cycle Group Size (Module): Logical toplevel element cycle groups with this number of elements or more are marked as critcal (error marker).");
        public static final /* enum */ CycleGroupSizeEntryDescriptor CRITICAL_SIZE_SYSTEM = new CycleGroupSizeEntryDescriptor(6, 2, 9999999, "Critical Cycle Group Size (System): Logical toplevel element cycle groups with this number of elements or more are marked as critcal (error marker).");
        private final int m_defaultValue;
        private final int m_minimalValue;
        private final int m_maximalValue;
        private final String m_description;
        private static final /* synthetic */ CycleGroupSizeEntryDescriptor[] ENUM$VALUES;

        static {
            ENUM$VALUES = new CycleGroupSizeEntryDescriptor[]{CRITICAL_SIZE_MODULE, CRITICAL_SIZE_SYSTEM};
        }

        private CycleGroupSizeEntryDescriptor(int defaultValue, int minimalValue, int maximalValue, String description) {
            assert (description != null && description.length() > 0) : "Parameter 'description' of method 'ConfigurationEntryDescriptor' must not be empty";
            this.m_defaultValue = defaultValue;
            this.m_description = description;
            this.m_minimalValue = minimalValue;
            this.m_maximalValue = maximalValue;
        }

        @Override
        public Integer getDefaultValue() {
            return this.m_defaultValue;
        }

        @Override
        public int getMaxValue() {
            return this.m_maximalValue;
        }

        @Override
        public int getMinValue() {
            return this.m_minimalValue;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_description;
        }

        public static CycleGroupSizeEntryDescriptor[] values() {
            CycleGroupSizeEntryDescriptor[] cycleGroupSizeEntryDescriptorArray = ENUM$VALUES;
            int n = cycleGroupSizeEntryDescriptorArray.length;
            CycleGroupSizeEntryDescriptor[] cycleGroupSizeEntryDescriptorArray2 = new CycleGroupSizeEntryDescriptor[n];
            System.arraycopy(ENUM$VALUES, 0, cycleGroupSizeEntryDescriptorArray2, 0, n);
            return cycleGroupSizeEntryDescriptorArray2;
        }

        public static CycleGroupSizeEntryDescriptor valueOf(String string) {
            return Enum.valueOf(CycleGroupSizeEntryDescriptor.class, string);
        }
    }

    static final class ExecutionModeConfigurationEntryDescriptor
    implements AnalyzerConfiguration.IOptionConfigurationEntryDescriptor {
        static final String INACTIVE = "Inactive";
        static final String ACTIVE = "Active";
        final String[] m_options = new String[]{"Inactive", "Active"};

        ExecutionModeConfigurationEntryDescriptor() {
        }

        public String getStandardName() {
            return "ExecutionMode";
        }

        public String getPresentationName() {
            return "Execution Mode: Set to 'Inactive' disables the analyzer. Set to 'Active' analyzes the cycles and computes metrics on module and system level.";
        }

        @Override
        public String getDefaultValue() {
            return this.m_options[0];
        }

        @Override
        public int getNumberOfOptions() {
            return this.m_options.length;
        }

        @Override
        public String[] getOptions() {
            return this.m_options;
        }
    }
}

