/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.Attribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.AttributeReference;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.DataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.HorizontalLayout;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.LeafNode;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.NonLeafNode;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.RecursiveDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SequenceAttribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SizeAttribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SubdivisionNode;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapData;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapLayout;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMapGenerator<E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeMapGenerator.class);
    private static final int NODES_PROGRESS_START_THRESHOLD = 1000;
    private static final int NODES_PROGRESS_THRESHOLD = 100;
    private float m_minSize = Float.MAX_VALUE;

    private void createChildNodes(TreeMapNode<E, D> node, List<IDataEntry[]> dataRecords, AttributeReference sizeAttrRef, AttributeReference attrRef, INodeCreationListener<E, D> listener, boolean isLastAttribute) {
        assert (node != null) : "Parameter 'node' of method 'createChildNodes' must not be null";
        assert (dataRecords != null && !dataRecords.isEmpty()) : "Parameter 'dataRecords' of method 'createChildNodes' must not be empty";
        assert (sizeAttrRef != null) : "Parameter 'sizeAttrRef' of method 'createChildNodes' must not be null";
        assert (attrRef != null) : "Parameter 'attrRef' of method 'createChildNodes' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'createChildNodes' must not be null";
        THashMap valueToNode = new THashMap();
        for (IDataEntry[] nextDataRecord : dataRecords) {
            if (!node.matches(nextDataRecord, -1)) continue;
            float nextSize = SizeAttribute.getSize(nextDataRecord, sizeAttrRef);
            IDataEntry nextDataEntry = nextDataRecord[attrRef.getIndexInDataRecord()];
            assert (nextDataEntry != null && nextDataEntry instanceof DataEntry) : "Unexpected class in method 'createChildNodes': " + String.valueOf(nextDataEntry);
            String nextAttributeValue = ((DataEntry)nextDataEntry).getValue();
            Object nextAsociatedElement = ((DataEntry)nextDataEntry).getAssociatedElement();
            SubdivisionNode nextNode = (LeafNode<E, D>)valueToNode.get(nextAttributeValue);
            if (nextNode == null) {
                if (isLastAttribute) {
                    nextNode = new LeafNode<E, D>(node, attrRef, nextAttributeValue);
                    nextNode.setAssociatedElement(nextAsociatedElement);
                    valueToNode.put(nextAttributeValue, nextNode);
                    nextNode.incrementSize(nextSize);
                    this.m_minSize = Math.min(nextSize, this.m_minSize);
                    listener.leafNodeCreated(nextNode);
                    continue;
                }
                nextNode = new NonLeafNode<E, D>(node, attrRef, nextAttributeValue);
                nextNode.setAssociatedElement(nextAsociatedElement);
                valueToNode.put(nextAttributeValue, nextNode);
                nextNode.incrementSize(nextSize);
                listener.nonLeafNodeCreated(nextNode);
                continue;
            }
            nextNode.incrementSize(nextSize);
        }
    }

    private void createChildNodesRecursively(TreeMapNode<E, D> node, List<IDataEntry[]> dataRecords, AttributeReference sizeAttrRef, AttributeReference attrRef, INodeCreationListener<E, D> listener, boolean isLastAttribute) {
        assert (node != null) : "Parameter 'node' of method 'createChildNodesRecursively' must not be null";
        assert (dataRecords != null) : "Parameter 'dataRecords' of method 'createChildNodesRecursively' must not be null";
        assert (sizeAttrRef != null) : "Parameter 'sizeAttrRef' of method 'createChildNodesRecursively' must not be null";
        assert (attrRef != null) : "Parameter 'attrRef' of method 'createChildNodesRecursively' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'createChildNodesRecursively' must not be null";
        THashMap valueToNode = new THashMap();
        for (IDataEntry[] nextDataRecord : dataRecords) {
            if (!((TreeMapNode)node).matches(nextDataRecord, -1)) continue;
            float nextSize = SizeAttribute.getSize(nextDataRecord, sizeAttrRef);
            IDataEntry nextDataEntry = nextDataRecord[attrRef.getIndexInDataRecord()];
            assert (nextDataEntry != null && nextDataEntry instanceof RecursiveDataEntry) : "Unexpected class in method 'createChildNodes': " + String.valueOf(nextDataEntry);
            String[] nextValues = ((RecursiveDataEntry)nextDataEntry).getValues();
            E[] nextAssociatedElements = ((RecursiveDataEntry)nextDataEntry).getAssociatedElements();
            SubdivisionNode currentNode = node;
            int index = 0;
            String[] stringArray = nextValues;
            int n = nextValues.length;
            int n2 = 0;
            while (n2 < n) {
                String nextAttributeValue = stringArray[n2];
                SubdivisionNode nextNode = (LeafNode)valueToNode.get(nextAttributeValue);
                if (nextNode == null) {
                    if (isLastAttribute) {
                        nextNode = new LeafNode(currentNode, attrRef, nextAttributeValue);
                        nextNode.setAssociatedElement(nextAssociatedElements != null ? (Object)nextAssociatedElements[index] : null);
                        valueToNode.put(nextAttributeValue, nextNode);
                        nextNode.incrementSize(nextSize);
                        this.m_minSize = Math.min(nextSize, this.m_minSize);
                        currentNode = nextNode;
                        listener.leafNodeCreated(nextNode);
                    } else {
                        nextNode = new NonLeafNode(currentNode, attrRef, nextAttributeValue);
                        nextNode.setAssociatedElement(nextAssociatedElements != null ? (Object)nextAssociatedElements[index] : null);
                        valueToNode.put(nextAttributeValue, nextNode);
                        nextNode.incrementSize(nextSize);
                        currentNode = nextNode;
                        listener.nonLeafNodeCreated(nextNode);
                    }
                } else {
                    nextNode.incrementSize(nextSize);
                    currentNode = nextNode;
                }
                ++index;
                ++n2;
            }
        }
    }

    private void process(TreeMap<E, D> treeMap, TreeMapData data, List<SequenceAttribute> sequence, AttributeReference sizeAttrRef, INodeCreationListener<E, D> listener, IWorkerContext workerContext) {
        assert (treeMap != null) : "Parameter 'treeMap' of method 'Processor' must not be null";
        assert (data != null) : "Parameter 'data' of method 'Processor' must not be null";
        assert (!data.getDataRecords().isEmpty()) : "No data records: " + String.valueOf(data);
        assert (sequence != null && !sequence.isEmpty()) : "Parameter 'sequence' of method 'Processor' must not be empty";
        assert (sizeAttrRef != null) : "Parameter 'sizeAttrRef' of method 'process' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'process' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        ArrayList<TreeMap<E, D>> currentNodesToProcess = new ArrayList<TreeMap<E, D>>(50);
        final ArrayList nextChildNodesToProcess = new ArrayList(50);
        LOGGER.debug("Create nodes and cumulated sizes");
        currentNodesToProcess.add(treeMap);
        int index = 0;
        for (Attribute attribute : sequence) {
            workerContext.working("Processing subdivision attribute '" + attribute.getName() + "'", true);
            AttributeReference nextAttrRef = data.getAttributeReference(attribute);
            assert (nextAttrRef != null) : "'nextAttrRef' of method 'generate' must not be null";
            boolean isLastAttribute = index == sequence.size() - 1;
            LOGGER.debug("Create nodes using " + String.valueOf(nextAttrRef.getDefinition()) + (isLastAttribute ? " <last attribute in sequence>" : ""));
            int numberOfParentNodes = currentNodesToProcess.size();
            int currentParentNode = 0;
            if (nextAttrRef.getDefinition().isRecursive()) {
                for (TreeMapNode treeMapNode : currentNodesToProcess) {
                    if (currentParentNode >= 1000 && currentParentNode % 100 == 0) {
                        workerContext.working("Processing subdivision attribute '" + attribute.getName() + "' underneath node " + currentParentNode + " of " + numberOfParentNodes, true);
                    }
                    this.createChildNodesRecursively(treeMapNode, data.getDataRecords(), sizeAttrRef, nextAttrRef, listener, isLastAttribute);
                    for (TreeMapNode nextChild : treeMapNode.getChildren()) {
                        nextChild.accept(new TreeMapNode.IVisitor<E, D>(){

                            @Override
                            public boolean visitNode(TreeMapNode<E, D> node) {
                                if (!$assertionsDisabled && node == null) {
                                    throw new AssertionError((Object)"Parameter 'node' of method 'visitNode' must not be null");
                                }
                                nextChildNodesToProcess.add(node);
                                return true;
                            }
                        });
                    }
                    ++currentParentNode;
                }
            } else {
                for (TreeMapNode treeMapNode : currentNodesToProcess) {
                    if (currentParentNode >= 1000 && currentParentNode % 100 == 0) {
                        workerContext.working("Processing subdivision attribute '" + attribute.getName() + "' underneath node " + currentParentNode + " of " + numberOfParentNodes, true);
                    }
                    this.createChildNodes(treeMapNode, data.getDataRecords(), sizeAttrRef, nextAttrRef, listener, isLastAttribute);
                    nextChildNodesToProcess.addAll(treeMapNode.getChildren());
                    ++currentParentNode;
                }
            }
            LOGGER.debug("Create nodes using " + String.valueOf(nextAttrRef.getDefinition()) + (isLastAttribute ? " <last attribute in sequence> - done" : " - done"));
            currentNodesToProcess.clear();
            currentNodesToProcess.addAll(nextChildNodesToProcess);
            nextChildNodesToProcess.clear();
            ++index;
        }
        currentNodesToProcess.clear();
        nextChildNodesToProcess.clear();
        treeMap.getChildren().forEach(c -> treeMap.incrementSize(c.getSize()));
        treeMap.accept(new TreeMapNode.IVisitor<E, D>(){

            @Override
            public boolean visitNode(TreeMapNode<E, D> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'process' must not be null");
                }
                node.finishModification();
                return true;
            }
        });
        LOGGER.debug("Create nodes and cumulated sizes - done [detected minimum size: " + this.m_minSize + "]");
        HorizontalLayout<E, D> horizontalLayout = new HorizontalLayout<E, D>();
        LOGGER.debug("Apply layout '" + horizontalLayout.getClass().getSimpleName() + "'");
        ((TreeMapLayout)horizontalLayout).layout(treeMap, this.m_minSize);
        LOGGER.debug("Apply layout '" + horizontalLayout.getClass().getSimpleName() + "' - done");
    }

    public TreeMap<E, D> generate(String name, E associatedElement, TreeMapData data, List<SequenceAttribute> sequence, SizeAttribute sizeAttribute, IWorkerContext workerContext, INodeCreationListener<E, D> listener) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'generate' must not be empty";
        assert (data != null) : "Parameter 'data' of method 'generate' must not be null";
        assert (!data.getDataRecords().isEmpty()) : "No data records provided: " + String.valueOf(data);
        assert (sequence != null && !sequence.isEmpty()) : "Parameter 'sequence' of method 'generate' must not be empty";
        assert (sizeAttribute != null) : "Parameter 'sizeAttribute' of method 'generate' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'generate' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generate' must not be null";
        LOGGER.debug("Generate treemap");
        for (SequenceAttribute nextAttribute : sequence) {
            assert (data.getAttributeReference(nextAttribute) != null) : "Unknown attribute in sequence: " + String.valueOf(nextAttribute);
        }
        AttributeReference sizeAttrRef = data.getAttributeReference(sizeAttribute);
        assert (sizeAttrRef != null) : "Size attribute not found: " + String.valueOf(sizeAttribute);
        TreeMap treeMap = new TreeMap(name);
        treeMap.setAssociatedElement(associatedElement);
        listener.nonLeafNodeCreated(treeMap);
        this.process(treeMap, data, sequence, sizeAttrRef, listener, workerContext);
        this.m_minSize = Float.MAX_VALUE;
        LOGGER.debug("Generate treemap - done: " + String.valueOf(treeMap));
        return treeMap;
    }

    public static interface INodeCreationListener<E, D> {
        default public void nonLeafNodeCreated(TreeMapNode<E, D> node) {
        }

        default public void leafNodeCreated(TreeMapNode<E, D> node) {
        }
    }
}

