/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.AlignmentLine;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapLayout;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AlternatingLayout<E, D>
extends TreeMapLayout<E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlternatingLayout.class);

    AlternatingLayout() {
    }

    private List<TreeMapNode<E, D>> sortChildrenForVerticalAlignment(List<TreeMapNode<E, D>> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'sortChildrenForVerticalAlignment' must not be empty";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'sortChildrenForVerticalAlignment' must not be empty";
        return nodes.parallelStream().sorted(Comparator.comparingInt(TreeMapNode::getWidth).reversed()).collect(Collectors.toList());
    }

    private List<TreeMapNode<E, D>> sortChildrenForHorizontalAlignment(List<TreeMapNode<E, D>> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'sortChildrenForHorizontalAlignment' must not be empty";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'sortChildrenForHorizontalAlignment' must not be empty";
        return nodes.parallelStream().sorted(Comparator.comparingInt(TreeMapNode::getHeight).reversed()).collect(Collectors.toList());
    }

    private void layoutChildrenOf(TreeMapNode<E, D> node) {
        assert (node != null) : "Parameter 'node' of method 'layoutChildrenOf' must not be null";
        assert (!node.isLeaf()) : "Is leaf: " + String.valueOf(node);
        assert (node.hasChildren()) : "Non leaf must have children: " + String.valueOf(node);
        LOGGER.debug("Layout children of '" + String.valueOf(node) + "'");
        List<TreeMapNode<E, D>> children = this.sortChildrenForHorizontalAlignment(node.getChildren());
        TreeMapNode<E, D> firstChild = children.get(0);
        LOGGER.trace("Add to first fixed position '" + String.valueOf(firstChild) + "'");
        firstChild.setLocation(2, 2);
        int numberOfChildren = children.size();
        if (numberOfChildren > 1) {
            AlternatingAlignmentLine currentAlignmentLine = new VerticalAlignmentLine<E, D>(firstChild.getRelativeX() + firstChild.getWidth(), 2, firstChild.getHeight());
            List<TreeMapNode<E, D>> currentChildren = children.subList(1, children.size());
            block8: while (!currentChildren.isEmpty()) {
                switch (((AlignmentLine)currentAlignmentLine).getDirection()) {
                    case VERTICAL: {
                        currentChildren = this.sortChildrenForVerticalAlignment(currentChildren);
                        break;
                    }
                    case HORIZONTAL: {
                        currentChildren = this.sortChildrenForHorizontalAlignment(currentChildren);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled direction: " + String.valueOf((Object)((AlignmentLine)currentAlignmentLine).getDirection());
                        break;
                    }
                }
                currentChildren = ((AlternatingAlignmentLine)currentAlignmentLine).align(currentChildren);
                if (currentChildren.isEmpty()) continue;
                switch (((AlignmentLine)currentAlignmentLine).getDirection()) {
                    case VERTICAL: {
                        currentAlignmentLine = new HorizontalAlignmentLine(2, currentAlignmentLine.getRelativeY() + currentAlignmentLine.getLength(), currentAlignmentLine.getRelativeX() + currentAlignmentLine.getMaxExtentWidth());
                        break;
                    }
                    case HORIZONTAL: {
                        currentAlignmentLine = new VerticalAlignmentLine(currentAlignmentLine.getRelativeX() + currentAlignmentLine.getLength(), 2, currentAlignmentLine.getRelativeY() + currentAlignmentLine.getMaxExtentHeight());
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled direction: " + String.valueOf((Object)((AlignmentLine)currentAlignmentLine).getDirection());
                        continue block8;
                    }
                }
            }
        }
        if (!node.isLeaf()) {
            int width = 0;
            int height = 0;
            for (TreeMapNode<E, D> nextChild : children) {
                width = Math.max(nextChild.getRelativeX() + nextChild.getWidth(), width);
                height = Math.max(nextChild.getRelativeY() + nextChild.getHeight(), height);
            }
            node.setDimensions(width + 2, height + 2);
            LOGGER.debug("Calculated dimensions of non-leaf '" + String.valueOf(node) + "'");
        }
        LOGGER.debug("Layout children of '" + String.valueOf(node) + "' - done");
    }

    @Override
    void layout(TreeMap<E, D> treeMap, float minimumSize) {
        assert (treeMap != null) : "Parameter 'treeMap' of method 'layout' must not be null";
        final TreeSet nonLeafNodes = new TreeSet(new Comparator<TreeMapNode<E, D>>(){

            @Override
            public int compare(TreeMapNode<E, D> n1, TreeMapNode<E, D> n2) {
                if (!$assertionsDisabled && n1 == null) {
                    throw new AssertionError((Object)"Parameter 'n1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && n2 == null) {
                    throw new AssertionError((Object)"Parameter 'n2' of method 'compare' must not be null");
                }
                int compare = n2.getLevel() - n1.getLevel();
                if (compare == 0) {
                    if (n1.equals(n2)) {
                        return 0;
                    }
                    compare = 1;
                }
                return compare;
            }
        });
        final float sizeFactor = minimumSize != 1.0f ? 1.0f / minimumSize : 1.0f;
        treeMap.accept(new TreeMapNode.IVisitor<E, D>(){

            @Override
            public boolean visitNode(TreeMapNode<E, D> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'visitNode' must not be null");
                }
                if (!node.isLeaf()) {
                    nonLeafNodes.add(node);
                } else {
                    int side = AlternatingLayout.this.calculateSquareLengthOfSide(node, sizeFactor);
                    node.setDimensions(side, side);
                }
                return true;
            }
        });
        nonLeafNodes.forEach(n -> this.layoutChildrenOf((TreeMapNode<E, D>)n));
    }

    private static abstract class AlternatingAlignmentLine<E, D>
    extends AlignmentLine<E, D> {
        private int m_maxExtentWidth;
        private int m_maxExtentHeight;

        AlternatingAlignmentLine(int x, int y, int length) {
            super(x, y, length);
        }

        protected abstract List<TreeMapNode<E, D>> align(List<TreeMapNode<E, D>> var1);

        protected final void added(TreeMapNode<E, D> node) {
            assert (node != null) : "Parameter 'node' of method 'added' must not be null";
            this.m_maxExtentWidth = Math.max(this.m_maxExtentWidth, node.getWidth());
            this.m_maxExtentHeight = Math.max(this.m_maxExtentHeight, node.getHeight());
        }

        final int getMaxExtentWidth() {
            return this.m_maxExtentWidth;
        }

        final int getMaxExtentHeight() {
            return this.m_maxExtentHeight;
        }
    }

    private static final class HorizontalAlignmentLine<E, D>
    extends AlternatingAlignmentLine<E, D> {
        HorizontalAlignmentLine(int x, int y, int length) {
            super(x, y, length);
        }

        @Override
        AlignmentLine.Direction getDirection() {
            return AlignmentLine.Direction.HORIZONTAL;
        }

        @Override
        protected final List<TreeMapNode<E, D>> align(List<TreeMapNode<E, D>> nodes) {
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'align' must not be empty";
            Iterator<TreeMapNode<E, D>> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                TreeMapNode<E, D> nextNode = iterator.next();
                assert (nextNode.hasDimensions()) : "Has no dimensions set: " + String.valueOf(nextNode);
                if (this.getUsedLength() + nextNode.getWidth() > this.getLength()) break;
                int x = this.getRelativeX() + this.getUsedLength();
                int y = this.getRelativeY() + 2;
                nextNode.setLocation(x, y);
                this.incrementUsedLength(nextNode.getWidth() + 2);
                this.added(nextNode);
                iterator.remove();
            }
            return nodes;
        }
    }

    private static final class VerticalAlignmentLine<E, D>
    extends AlternatingAlignmentLine<E, D> {
        VerticalAlignmentLine(int x, int y, int length) {
            super(x, y, length);
        }

        @Override
        AlignmentLine.Direction getDirection() {
            return AlignmentLine.Direction.VERTICAL;
        }

        @Override
        protected final List<TreeMapNode<E, D>> align(List<TreeMapNode<E, D>> nodes) {
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'align' must not be empty";
            Iterator<TreeMapNode<E, D>> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                TreeMapNode<E, D> nextNode = iterator.next();
                assert (nextNode.hasDimensions()) : "Has no dimensions set: " + String.valueOf(nextNode);
                if (this.getUsedLength() + nextNode.getHeight() > this.getLength()) break;
                int x = this.getRelativeX() + 2;
                int y = this.getRelativeY() + this.getUsedLength();
                nextNode.setLocation(x, y);
                this.incrementUsedLength(nextNode.getHeight() + 2);
                this.added(nextNode);
                iterator.remove();
            }
            return nodes;
        }
    }
}

