/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TreeNode<T extends TreeNode> {
    private T m_parent;
    private List<T> m_children;

    protected TreeNode() {
    }

    public final T getParent() {
        return this.m_parent;
    }

    public final T getSelf() {
        return (T)this;
    }

    public final boolean isParentOf(T of) {
        assert (of != null) : "Parameter 'of' of method 'isParentOf' must not be null";
        if (this != of) {
            T currentParent = ((TreeNode)of).getParent();
            while (currentParent != null) {
                if (currentParent == this) {
                    return true;
                }
                currentParent = ((TreeNode)currentParent).getParent();
            }
        }
        return false;
    }

    protected final void setParent(T parent) {
        this.m_parent = parent;
    }

    public final void remove() {
        if (this.m_parent != null) {
            ((TreeNode)this.m_parent).removeChild(this);
            this.m_parent = null;
        }
    }

    public final int getNumberOfParents() {
        if (this.m_parent == null) {
            return 0;
        }
        return 1 + ((TreeNode)this.m_parent).getNumberOfParents();
    }

    public final int getIndexOf(T element) {
        assert (element != null) : "Parameter 'element' of method 'getIndexOf' must not be null";
        if (this.m_children == null) {
            return -1;
        }
        return this.m_children.indexOf(element);
    }

    public final void addChild(T child, int index) {
        assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
        if (this.m_children == null) {
            this.m_children = new ArrayList<T>();
        }
        if (index > this.m_children.size()) {
            index = this.m_children.size();
        }
        if (child.getParent() == this) {
            int currentPos = this.m_children.indexOf(child);
            assert (currentPos != -1) : "Not a child: " + String.valueOf(child);
            if (currentPos != index) {
                if (currentPos < index) {
                    this.m_children.add(index, child);
                    this.m_children.remove(currentPos);
                } else {
                    if (index == this.m_children.size()) {
                        this.m_children.add(child);
                    } else {
                        this.m_children.add(index, child);
                    }
                    this.m_children.remove(currentPos + 1);
                }
            }
        } else {
            if (child.getParent() != null) {
                ((TreeNode)child.getParent()).removeChild(child);
            }
            if (index == this.m_children.size()) {
                this.m_children.add(child);
            } else {
                this.m_children.add(index, child);
            }
            child.setParent((TreeNode)this);
        }
    }

    public final int addChild(T child) {
        assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
        if (this.m_children == null) {
            this.m_children = new ArrayList<T>();
        }
        if (child.getParent() != null) {
            ((TreeNode)child.getParent()).removeChild(child);
        }
        this.m_children.add(child);
        child.setParent((TreeNode)this);
        return this.m_children.size() - 1;
    }

    public final List<T> getChildren() {
        if (this.m_children != null) {
            return Collections.unmodifiableList(this.m_children);
        }
        return Collections.emptyList();
    }

    public final int getNumberOfChildren() {
        return this.m_children == null ? 0 : this.m_children.size();
    }

    public final List<T> getChildrenRecursively() {
        ArrayList<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
        for (TreeNode next : this.getChildren()) {
            children.add(next);
            children.addAll(next.getChildrenRecursively());
        }
        return Collections.unmodifiableList(children);
    }

    public final boolean isLeaf() {
        return this.m_children == null || this.m_children.isEmpty();
    }

    public final void removeChild(TreeNode child) {
        assert (child != null) : "Parameter 'child' of method 'removeChild' must not be null";
        assert (this.m_children != null) : "'m_children' of method 'removeChild' must not be null";
        assert (this.m_children.contains(child)) : "'m_children' of method 'removeChild' does not contain: " + String.valueOf(child);
        this.m_children.remove(child);
        if (this.m_children.size() == 0) {
            this.m_children = null;
        }
    }

    public final void removeAllChildren() {
        if (this.m_children != null) {
            for (TreeNode next : this.m_children) {
                next.setParent(null);
            }
            this.m_children = null;
        }
    }

    public abstract String getName();

    public String toString() {
        return this.getName() + " [" + this.getClass().getName() + "]";
    }
}

