/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INodeRankAdapter;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class NodeRank {
    private static final double EPS = 1.0E-4;
    private static final double DAMPING = 0.85;

    public void compute(INodeRankAdapter adapter, IWorkerContext workerContext) {
        double maxDelta;
        assert (adapter != null) : "Parameter 'adapter' of method 'compute' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        Collection<INode<?>> nodes = adapter.getNodes();
        THashMap rankTable = new THashMap();
        THashMap outgoingLinks = new THashMap();
        Double initialRank = 1.0 / (double)nodes.size();
        nodes.forEach(arg_0 -> NodeRank.lambda$0((Map)rankTable, initialRank, arg_0));
        nodes.forEach(arg_0 -> NodeRank.lambda$1((Map)outgoingLinks, arg_0));
        List sinks = outgoingLinks.entrySet().stream().filter(p -> (Long)p.getValue() == 0L).map(p -> (INode)p.getKey()).collect(Collectors.toList());
        double dampingConstant = 0.15000000000000002 / (double)nodes.size();
        THashMap rank = rankTable;
        do {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            THashMap nextRank = new THashMap();
            THashMap previousRank = rank;
            double cumulatedSinkRankContribution = 0.85 * sinks.stream().mapToDouble(arg_0 -> NodeRank.lambda$5((Map)previousRank, arg_0)).sum() / (double)nodes.size();
            maxDelta = 0.0;
            for (INode<?> node : nodes) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                double newRank = dampingConstant + cumulatedSinkRankContribution;
                for (INode.IEdge edge : node.getIncomingEdges()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    INode<?> from = edge.getFrom();
                    if (from == node) continue;
                    newRank += 0.85 * (Double)rank.get(from) / (double)((Long)outgoingLinks.get(from)).longValue();
                }
                nextRank.put(node, newRank);
                double delta = Math.abs((Double)rank.get(node) - newRank);
                maxDelta = Math.max(delta, maxDelta);
            }
            rank = nextRank;
        } while (maxDelta > 1.0E-4);
        for (INode<?> node : nodes) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            adapter.setRank(node, 100.0 * (Double)rank.get(node));
        }
    }

    private static /* synthetic */ void lambda$0(Map map, Double d, INode n) {
        Double d2 = map.put(n, d);
    }

    private static /* synthetic */ void lambda$1(Map map, INode n) {
        Long l = map.put(n, n.getOutgoingEdges().stream().filter(e -> e.getTo() != n).count());
    }

    private static /* synthetic */ double lambda$5(Map map, INode n) {
        return (Double)map.get(n);
    }
}

