/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.IntValueAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

final class SourceFileMetricIntValueAdapter
extends IntValueAdapter {
    private final SoftwareSystem m_softwareSystem;
    private final IMetricAccessor m_metricAccessor;
    private final IMetricDescriptor m_metricDescriptor;

    SourceFileMetricIntValueAdapter(SoftwareSystem softwareSystem, IMetricAccessor metricAccessor, IMetricDescriptor metricDescriptor) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SourceFileMetricIntValueAdapter' must not be null";
        assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'SourceFileMetricIntValueAdapter' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'SourceFileMetricIntValueAdapter' must not be null";
        assert (!metricDescriptor.isFloat()) : "Int metric expected: " + String.valueOf(metricDescriptor);
        this.m_softwareSystem = softwareSystem;
        this.m_metricAccessor = metricAccessor;
        this.m_metricDescriptor = metricDescriptor;
    }

    @Override
    public int getValue(NamedElement element) {
        Number number;
        assert (element != null && element instanceof SourceFile) : "Unexpected class in method 'getValue': " + String.valueOf(element);
        IMetricValue metricValue = this.m_metricAccessor.getMetricValue(this.m_softwareSystem, (IWorkerContext)DefaultWorkerContext.INSTANCE, element, this.m_metricDescriptor, false);
        if (metricValue != null && (number = metricValue.getValue()) != null) {
            return number.intValue();
        }
        return -1;
    }
}

