/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import java.util.List;

final class IssueInfoProvider
implements ILeafInfoProvider {
    private final List<Issue> m_issues;

    IssueInfoProvider(List<Issue> issues) {
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'IssueProvider' must not be empty";
        this.m_issues = issues;
    }

    @Override
    public String getInformation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_issues.size()).append(" issue(s)");
        int i = 1;
        for (Issue nextIssue : this.m_issues) {
            builder.append("\n").append("<").append(i).append("> ").append(nextIssue.getId().getPresentationName()).append(": ").append(nextIssue.getDescription().trim());
            IResolution resolution = nextIssue.getResolution();
            if (resolution != null) {
                if (resolution.ignores()) {
                    builder.append(" <ignored>");
                } else {
                    builder.append(" <task>");
                }
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public int getValue() {
        return this.m_issues.size();
    }

    public String toString() {
        return this.getInformation();
    }
}

