/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.Map;
import java.util.Set;

public final class ProgrammingElementCheckerCollector
extends ExtendableEndpointCollector {
    private final Set<ProgrammingElement> m_programmingElementsForAdditionalNodes;
    private final Set<ProgrammingElement> m_programmingElementsForMainNodes;
    private final boolean m_allowTransitiveDependencies;

    public ProgrammingElementCheckerCollector(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, boolean allowTransitiveDependencies, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively, EndpointType endpointType) {
        super(softwareSystem, mainNodes, additionalNodes, namedElementToProxy, dependencyTypes, domain, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, endpointType);
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'ProgrammingElementCheckerCollector' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'ProgrammingElementCheckerCollector' must not be null";
        this.m_programmingElementsForAdditionalNodes = programmingElementsForAdditionalNodes;
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_allowTransitiveDependencies = allowTransitiveDependencies;
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        boolean isDependencyOfAdditionals;
        assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addDependency': " + String.valueOf(dependency);
        ParserDependency parserDependency = (ParserDependency)dependency;
        ProgrammingElement fromDependencyEndpoint = parserDependency.getFrom();
        ProgrammingElement toDependencyEndpoint = parserDependency.getTo();
        boolean fromIsAdditional = this.m_programmingElementsForAdditionalNodes.contains(fromDependencyEndpoint);
        boolean toIsAdditional = this.m_programmingElementsForAdditionalNodes.contains(toDependencyEndpoint);
        boolean bl = isDependencyOfAdditionals = fromIsAdditional && toIsAdditional;
        if ((!isDependencyOfAdditionals || this.m_allowTransitiveDependencies) && ExtendableEndpointCollector.isParserDependencyInRepresentation(this.getMainNodes(), this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionalNodes, from, to, parserDependency)) {
            return super.addDependency(from, to, dependency) || !fromIsAdditional && !toIsAdditional;
        }
        return false;
    }

    protected Set<ProgrammingElement> getProgrammingElementsForAdditionalNodes() {
        return this.m_programmingElementsForAdditionalNodes;
    }

    protected Set<ProgrammingElement> getProgrammingElementsForMainNodes() {
        return this.m_programmingElementsForMainNodes;
    }
}

