/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class PotentialDependencyCollector
extends NamedElementVisitor
implements Module.IVisitor,
External.IVisitor,
ProgrammingElement.IVisitor,
LogicalNamespaceRoot.IVisitor,
ExternalLogicalNamespaceRoot.IVisitor,
LogicalProgrammingElement.IVisitor,
Artifact.IVisitor {
    private final StructureInfo m_structureInfo;
    private final Representation m_representation;
    private final Map<NamedElement, MatchingType> m_calculatedAdditionals = new HashMap<NamedElement, MatchingType>();
    private final NamedElement m_elementForAdditionals;
    private final NamedElement m_endpoint;
    private final StructureItem m_referenceStructureItem;
    private final IDomainRoot.Domain m_domain;
    private final IRepresentationProvider m_representationProvider;

    public PotentialDependencyCollector(IRepresentationProvider representationProvider, StructureInfo structureInfo, Representation representation, NamedElement elementForAdditionals, NamedElement endpoint, IDomainRoot.Domain domain) {
        assert (representationProvider != null) : "Parameter 'representationProvider' of method 'PotentialDependencyCollector' must not be null";
        assert (structureInfo != null) : "Parameter 'structureInfo' of method 'PotentialDependencyCollector' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'PotentialDependencyCollector' must not be null";
        assert (elementForAdditionals != null) : "Parameter 'elementForAdditionals' of method 'PotentialInputCollector' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'PotentialDependencyCollector' must not be null";
        this.m_representationProvider = representationProvider;
        this.m_elementForAdditionals = elementForAdditionals;
        this.m_endpoint = endpoint;
        this.m_structureInfo = structureInfo;
        this.m_representation = representation;
        this.m_referenceStructureItem = elementForAdditionals.getStructureItem();
        assert (this.m_referenceStructureItem != null) : "Parameter 'm_structureItem' of method 'PotentialInputCollector' must not be null" + String.valueOf(elementForAdditionals);
        assert (this.m_structureInfo.isInStructure(this.m_referenceStructureItem)) : "Element of class " + elementForAdditionals.getClass().getName() + " returns wrong structure item " + this.m_referenceStructureItem.name() + ". Allowed items: " + this.m_structureInfo.toString();
        this.m_domain = domain;
    }

    @Override
    public final void visitModule(Module element) {
        assert (element != null) : "Parameter 'element' of method 'visitModule' must not be null";
        if (element.isOfStructureItem(this.m_referenceStructureItem) && this.m_domain == IDomainRoot.Domain.PHYSICAL) {
            this.addElementToCalculated(element, MatchingType.EXACT);
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitExternal(External element) {
        assert (element != null) : "Parameter 'element' of method 'visitExternal' must not be null";
        if (element.isOfStructureItem(this.m_referenceStructureItem) && this.m_domain == IDomainRoot.Domain.PHYSICAL) {
            this.addElementToCalculated(element, MatchingType.EXACT);
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitExternalLogicalNamespaceRoot(ExternalLogicalNamespaceRoot element) {
        assert (element != null) : "Parameter 'visitExternalLogicalNamespaceRoot' of method 'visitExternal' must not be null";
        if (element.isOfStructureItem(this.m_referenceStructureItem) && (this.m_domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || this.m_domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE)) {
            this.addElementToCalculated(element, MatchingType.EXACT);
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitLogicalNamespaceRoot(LogicalNamespaceRoot element) {
        assert (element != null) : "Parameter 'element' of method 'visitLogicalNamespaceRoot' must not be null";
        if (element.isOfStructureItem(this.m_referenceStructureItem) && (this.m_domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || this.m_domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE)) {
            this.addElementToCalculated(element, MatchingType.EXACT);
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public void visitArtifact(Artifact element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitectureElement' must not be null";
        if (element.isOfStructureItem(this.m_referenceStructureItem) && (this.m_domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || this.m_domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL)) {
            this.addElementToCalculated(element, MatchingType.EXACT);
            if (element.hasAllChildren(false, Artifact.class)) {
                this.visitChildrenOf(element);
            }
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        StructureItem elementStructureItem = element.getStructureItem();
        if (!element.hasAsParent(this.m_elementForAdditionals, false) && element != this.m_endpoint && this.m_representation.getRootElement() != element) {
            if (element.isOfStructureItem(this.m_referenceStructureItem)) {
                if (this.m_referenceStructureItem.allowsFlat()) {
                    this.addElementToCalculated(element, MatchingType.EXACT);
                    if (element.hasChildren(namedElement -> namedElement.isOfStructureItem(this.m_referenceStructureItem), NamedElement.class)) {
                        this.visitChildrenOf(element);
                    }
                } else {
                    this.addElementToCalculated(element, MatchingType.EXACT);
                }
            } else if (this.m_structureInfo.isInStructure(elementStructureItem) && this.m_structureInfo.compare(this.m_referenceStructureItem, elementStructureItem) > 0) {
                this.visitChildrenOf(element);
            } else if (this.m_structureInfo.isInStructure(elementStructureItem) && this.m_structureInfo.compare(this.m_referenceStructureItem, elementStructureItem) < 0 && !this.m_calculatedAdditionals.containsKey(element.getParent())) {
                MatchingType matchingType = MatchingType.UNMATCHED;
                NamedElement currentParent = element.getParent();
                while (currentParent != null) {
                    if (currentParent.isOfStructureItem(this.m_referenceStructureItem)) {
                        matchingType = MatchingType.EXACT;
                        break;
                    }
                    currentParent = currentParent.getParent();
                }
                this.addElementToCalculated(this.getParentForFlatMode(element), matchingType);
            }
        } else {
            this.visitChildrenOf(element);
        }
    }

    @Override
    public abstract void visitProgrammingElement(ProgrammingElement var1);

    @Override
    public abstract void visitLogicalProgrammingElement(LogicalProgrammingElement var1);

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement next : this.m_representationProvider.getChildrenFromPresentationMode(element, this.m_domain, PresentationMode.FLAT, true)) {
            next.accept(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private NamedElement getParentForFlatMode(NamedElement element) {
        if (!PotentialDependencyCollector.$assertionsDisabled && element == null) {
            throw new AssertionError((Object)"Parameter 'element' of method 'getParentForFlatMode' must not be null");
        }
        item = element.getStructureItem();
        if (!PotentialDependencyCollector.$assertionsDisabled && item == null) {
            throw new AssertionError((Object)"'item' of method 'getParentForFlatOrHierarchical' must not be null");
        }
        if (!(element instanceof IRecursiveElement)) {
            return element.getParent();
        }
        parentItem = this.m_structureInfo.getPrevious(item);
        if (PotentialDependencyCollector.$assertionsDisabled || parentItem != null) ** GOTO lbl14
        throw new AssertionError((Object)"Parameter 'parentItem' of method 'getParentForFlatOrHierarchical' must not be null");
lbl-1000:
        // 1 sources

        {
            parentItem = this.m_structureInfo.getPrevious(parentItem);
            if (!PotentialDependencyCollector.$assertionsDisabled && parentItem == null) {
                throw new AssertionError((Object)"'parentItem' of method 'getParentForFlatOrHierarchical' must not be null");
            }
lbl14:
            // 3 sources

            ** while (parentItem.allowsFlat())
        }
lbl15:
        // 1 sources

        parent = element;
        while (parent != null && !parent.isOfStructureItem(parentItem)) {
            if (this.m_representation.getRootElement() == parent) {
                parent = element;
                parentItem = this.m_structureInfo.getPrevious(parentItem);
                continue;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    protected final void addElementToCalculated(NamedElement namedElement, MatchingType matchingType) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'addElementToCalculated' must not be null";
        MatchingType actualMatchingType = this.useMatchingType() ? matchingType : MatchingType.EXACT;
        this.m_calculatedAdditionals.put(namedElement, actualMatchingType);
    }

    protected boolean useMatchingType() {
        return true;
    }

    public final Map<NamedElement, MatchingType> getCalculatedAdditionals() {
        return Collections.unmodifiableMap(this.m_calculatedAdditionals);
    }

    protected final NamedElement getElementForAdditionals() {
        return this.m_elementForAdditionals;
    }

    protected final NamedElement getEndpoint() {
        return this.m_endpoint;
    }

    protected final StructureInfo getStructureInfo() {
        return this.m_structureInfo;
    }

    protected final StructureItem getReferenceStructureItem() {
        return this.m_referenceStructureItem;
    }

    protected final IDomainRoot.Domain getDomain() {
        return this.m_domain;
    }

    public final IRepresentationProvider getRepresentationProvider() {
        return this.m_representationProvider;
    }

    public static enum MatchingType {
        EXACT,
        UNMATCHED;

    }
}

