/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import java.util.Collection;

public class AllFlatChildrenCollector
extends NamedElementVisitor {
    private final NamedElement m_parent;
    private final Collection<NamedElement> m_collector;

    public AllFlatChildrenCollector(NamedElement parent, Collection<NamedElement> collector) {
        assert (parent != null) : "Parameter 'parent' of method 'AllFlatChildrenCollector' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'AllFlatChildrenCollector' must not be null";
        this.m_parent = parent;
        this.m_collector = collector;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (element instanceof IRecursiveElement) {
            if (this.m_parent != element) {
                this.m_collector.add(element);
            }
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement namedElement : element.getAllChildrenExceptGhosts(RepresentationUtility.REPRESENTATION_FILTER)) {
            namedElement.accept(this);
        }
    }
}

