/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.migration;

import com.hello2morrow.sonargraph.core.controller.system.migration.RegexBasedFileMigration;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.integration.access.foundation.MigrationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VirtualModelMigration
extends RegexBasedFileMigration {
    static final Logger LOGGER = LoggerFactory.getLogger(VirtualModelMigration.class);
    private static final String THRESHOLD_ERROR_PATTERN = "<type class=\"com\\.hello2morrow\\.sonargraph\\.core\\.model\\.element\\.CoreIssueId\" name=\"ThresholdViolationError\" descriptor=\"ThresholdViolationError:(.*)\"></type>";
    private static final String THRESHOLD_REPLACEMENT = "<type class=\"com\\.hello2morrow\\.sonargraph\\.core\\.model\\.element\\.CoreIssueId\" name=\"ThresholdViolation\" descriptor=\"ThresholdViolation:$1\"></type>";
    private static final String CRITICAL_CYCLE_PATTERN = "<type class=\"com\\.hello2morrow\\.sonargraph\\.core\\.model\\.element\\.CoreIssueId\" name=\"Critical(.*)CycleGroup\" descriptor=\"(.*)CycleGroup\"></type>";
    private static final String CYCLE_REPLACEMENT = "<type class=\"com.hello2morrow.sonargraph.core.model.element.CoreIssueId\" name=\"$1CycleGroup\" descriptor=\"$2CycleGroup\"></type>";
    private static final String PLUGIN_RESOLUTION_PATTERN = "(<type class=\"Plugin\" .* descriptor=)\"(com\\.hello2morrow\\.sonargraph\\.plugin\\..*):(.*):";
    private static final String PLUGIN_RESOLUTION_REPLACEMENT = "$1\"$3:$2\"></type>";

    public VirtualModelMigration(boolean writeToDisk) {
        super(CoreFileType.MODEL, "virtualModel", writeToDisk, true);
    }

    @Override
    protected String migrateContent(String original, OperationResult result) {
        assert (original != null && original.length() > 0) : "Parameter 'original' of method 'migrateContent' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'migrateContent' must not be null";
        String migrated = this.migrateThresholdErrors(original);
        migrated = this.migrateCriticalCycleGroups(migrated);
        migrated = this.migratePluginResolutions(migrated);
        return migrated;
    }

    private String migrateThresholdErrors(String content) {
        assert (content != null) : "Parameter 'content' of method 'migrateLine' must not be null";
        return content.replaceAll(THRESHOLD_ERROR_PATTERN, THRESHOLD_REPLACEMENT);
    }

    private String migrateCriticalCycleGroups(String content) {
        assert (content != null) : "Parameter 'content' of method 'migrateCriticalComponentCycleGroups' must not be null";
        return content.replaceAll(CRITICAL_CYCLE_PATTERN, CYCLE_REPLACEMENT);
    }

    private String migratePluginResolutions(String content) {
        Severity[] severities;
        assert (content != null) : "Parameter 'content' of method 'migratePluginResolutions' must not be null";
        String migrated = content;
        Severity[] severityArray = severities = new Severity[]{Severity.INFO, Severity.WARNING, Severity.ERROR};
        int n = severities.length;
        int n2 = 0;
        while (n2 < n) {
            Severity next = severityArray[n2];
            String searchPattern = PLUGIN_RESOLUTION_PATTERN + next.getStandardName() + "\"></type>";
            migrated = migrated.replaceAll(searchPattern, PLUGIN_RESOLUTION_REPLACEMENT);
            ++n2;
        }
        return migrated;
    }

    @Override
    protected boolean needsMigration(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'needsMigration' must not be empty";
        return MigrationCheck.isPreUnificationOfIssueIds((String)version);
    }

    @Override
    protected String addAdditionalVersionAttribute(String oldVersion, String currentVersion) {
        assert (oldVersion != null && oldVersion.length() > 0) : "Parameter 'oldVersion' of method 'addAdditionalVersionAttribute' must not be empty";
        assert (currentVersion != null && currentVersion.length() > 0) : "Parameter 'currentVersion' of method 'addAdditionalVersionAttribute' must not be empty";
        return " versionBeforeMigration=\"" + oldVersion + "\"";
    }
}

