/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NonDeletedComponentDetector;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentStructureNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.LibraryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PhysicalCreator
extends ArchitecturalViewNodeCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalCreator.class);
    private static final List<Class<?>> CLASSES = Arrays.asList(RootDirectoryPath.class, Module.class, External.class, LibraryPath.class, IRecursiveElement.class, IComponent.class, SourceFile.class, ProgrammingElement.class);
    private ProgrammingElementAggregatingNode m_leafNodeCandidate;
    private boolean m_componentReached;

    protected PhysicalCreator(IWorkerContext workerContext, ExplorationViewRepresentation representation) {
        super(workerContext, representation);
    }

    public static NamedElement getPhysicalParent(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getPhysicalParent' must not be null";
        SourceFile sourceFile = element.getParent(SourceFile.class, new Class[0]);
        if (sourceFile != null) {
            return sourceFile;
        }
        IComponent component = element.getParent(IComponent.class, new Class[0]);
        if (component != null) {
            return component.getNamedElement();
        }
        LOGGER.warn("Neither source file nor component parent found for: " + String.valueOf(element));
        return null;
    }

    private static boolean canHandle(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeElement' must not be null";
        if (!element.isExcluded()) {
            Class<?> elementClass = element.getClass();
            for (Class<?> nextClass : CLASSES) {
                if (!nextClass.isAssignableFrom(elementClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCreateExplorationViewOnDemandPossible(NamedElement element, Set<NamedElement> select) {
        assert (element != null) : "Parameter 'element' of method 'isCreateExplorationViewOnDemandPossible' must not be null";
        assert (select != null) : "Parameter 'select' of method 'isCreateExplorationViewOnDemandPossible' must not be null";
        if (ArchitecturalViewNodeCreator.canBeShownInExplorationView(element) && PhysicalCreator.canHandle(element)) {
            if (element instanceof IRecursiveElement) {
                IComponent component = element.getParent(IComponent.class, new Class[0]);
                if (component != null) {
                    select.add(component.getNamedElement());
                } else {
                    select.add(element);
                }
            } else {
                select.add(element);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean includeElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeElement' must not be null";
        return PhysicalCreator.canHandle(element);
    }

    protected abstract NonRecursiveNonRootNode createRootDirectoryNode(ArchitecturalViewElement var1, RootDirectoryPath var2);

    protected abstract RecursiveNode createRecursiveNode(ArchitecturalViewElement var1, IRecursiveElement var2);

    protected abstract ComponentNode createComponentNode(ArchitecturalViewElement var1, IComponent var2);

    @Override
    protected final ArchitecturalViewNode processElement(ArchitecturalViewElement parent, NamedElement element) {
        assert (parent != null) : "Parameter 'parent' of method 'processElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'processElement' must not be null";
        AssignableNode node = null;
        String unhandledClass = element.getClass().getName();
        if (element instanceof IComponent) {
            node = this.createComponentNode(parent, (IComponent)((Object)element));
            this.m_leafNodeCandidate = node;
            unhandledClass = null;
        } else if (element instanceof ProgrammingElement) {
            unhandledClass = null;
        } else if (element instanceof SourceFile) {
            node = new ComponentStructureNode(parent, this.getPresentationMode(), this.isReadOnly(), (SourceFile)element);
            parent.addChild(node);
            this.m_leafNodeCandidate = (ComponentStructureNode)node;
            unhandledClass = null;
        } else if (element instanceof IRecursiveElement) {
            if (!this.m_componentReached) {
                node = this.createRecursiveNode(parent, (IRecursiveElement)((Object)element));
            }
            unhandledClass = null;
        } else if (element instanceof RootDirectoryPath) {
            RootDirectoryPath rootDirectoryPath = (RootDirectoryPath)element;
            if (rootDirectoryPath.mayContainSourceFiles()) {
                node = this.createRootDirectoryNode(parent, rootDirectoryPath);
            } else {
                NonDeletedComponentDetector detector = new NonDeletedComponentDetector();
                rootDirectoryPath.accept(detector);
                if (detector.containsNonDeletedComponents()) {
                    node = this.createRootDirectoryNode(parent, rootDirectoryPath);
                }
            }
            unhandledClass = null;
        } else if (element instanceof ComponentContainer) {
            node = new NonRecursiveRootNode(parent, this.getPresentationMode(), this.isReadOnly(), element);
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof LibraryPath) {
            node = new NonRecursiveNonRootNode(parent, this.getPresentationMode(), this.isReadOnly(), element);
            parent.addChild(node);
            unhandledClass = null;
        }
        assert (unhandledClass == null) : "Unhandled class: " + unhandledClass;
        return node;
    }

    @Override
    protected void enter(NamedElement element, ArchitecturalViewNode node) {
        EmptyNodeProgrammingElement emptyNodeProgrammingElement;
        assert (element != null) : "Parameter 'element' of method 'enter' must not be null";
        if (node instanceof ComponentNode) {
            this.m_componentReached = true;
        }
        if (element instanceof ProgrammingElement) {
            if (this.getCurrentLeafNode() == null) {
                if (this.m_leafNodeCandidate != null) {
                    this.startLeafNode(this.m_leafNodeCandidate);
                    this.m_leafNodeCandidate.setIsLazyExpandable(true);
                    this.m_leafNodeCandidate = null;
                }
            } else assert (this.m_leafNodeCandidate == null) : "'m_leafNodeCandidate' of method 'enter' must be null";
            this.processProgrammingElement((ProgrammingElement)element);
        }
        if (node != null && (emptyNodeProgrammingElement = node.getEmptyNodeProgrammingElement()) != null) {
            this.processEmptyProgrammingElement(node, emptyNodeProgrammingElement);
        }
    }

    @Override
    protected void leave(NamedElement element, ArchitecturalViewNode node) {
        assert (element != null) : "Parameter 'element' of method 'leave' must not be null";
        if (node instanceof ComponentNode) {
            this.m_componentReached = false;
        }
        if (node != null && this.getCurrentLeafNode() == node) {
            this.finishLeafNode(this.getCurrentLeafNode());
        }
    }
}

