/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewNodePositionUtility;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodesWithPotentialDependenciesCollector;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ParserDependencyNumbers;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetric;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetrics;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyState;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.TopLevelLogicalProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsHandler.class);

    public static ExplorationViewOperationMode isCalculateMetricsPossible(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isCalculateMetricsPossible' must not be null";
        if (!elements.isEmpty()) {
            ExplorationViewRepresentation representation = null;
            for (Element next : elements) {
                if (!(next instanceof ArchitecturalViewElement)) {
                    return null;
                }
                ExplorationViewRepresentation nextRepresentation = ((ArchitecturalViewElement)next).getParent(ExplorationViewRepresentation.class, ParentMode.SELF_OR_FIRST_PARENT);
                if (nextRepresentation == null || !nextRepresentation.isValid()) {
                    return null;
                }
                if (representation == null) {
                    representation = nextRepresentation;
                    continue;
                }
                if (representation == nextRepresentation) continue;
                return null;
            }
            assert (representation != null) : "Parameter 'representation' of method 'isCalculateMetricsPossible' must not be null";
            return representation.getOperationMode();
        }
        return null;
    }

    public static ExplorationViewMetrics calculateMetrics(IWorkerContext workerContext, List<Element> elements, Set<String> namespacePresentationNames) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateMetrics' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculateMetrics' must not be empty";
        assert (namespacePresentationNames != null && !namespacePresentationNames.isEmpty()) : "Parameter 'namespacePresentationNames' of method 'calculateMetrics' must not be empty";
        LOGGER.debug("Calculate metrics");
        ArrayList<ArchitecturalViewElement> architecturalViewElements = new ArrayList<ArchitecturalViewElement>();
        ExplorationViewRepresentation representation = null;
        for (Element next : elements) {
            if (workerContext.hasBeenCanceled()) {
                LOGGER.debug("Calculate metrics - cancelled");
                return null;
            }
            if (!(next instanceof ArchitecturalViewElement)) {
                return null;
            }
            if (!((ArchitecturalViewElement)next).isVisible()) {
                return null;
            }
            ExplorationViewRepresentation nextRepresentation = ((ArchitecturalViewElement)next).getParent(ExplorationViewRepresentation.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (nextRepresentation == null || !nextRepresentation.isValid()) {
                return null;
            }
            if (representation == null) {
                representation = nextRepresentation;
            } else if (representation != nextRepresentation) {
                return null;
            }
            architecturalViewElements.add((ArchitecturalViewElement)next);
        }
        if (workerContext.hasBeenCanceled()) {
            LOGGER.debug("Calculate metrics - cancelled");
            return null;
        }
        assert (representation != null) : "'representation' of method 'calculateMetrics' must not be null";
        ExplorationViewMetrics metrics = new ExplorationViewMetrics(NamedElementUtility.normalize(architecturalViewElements, true, new Class[0]), namespacePresentationNames, representation);
        THashSet relevantNodes = new THashSet();
        NodesWithPotentialDependenciesCollector collector = new NodesWithPotentialDependenciesCollector(workerContext, (Collection<ArchitecturalViewNode>)relevantNodes);
        for (ArchitecturalViewElement next : metrics.getElements()) {
            if (workerContext.hasBeenCanceled()) {
                LOGGER.debug("Calculate metrics - cancelled");
                return null;
            }
            next.accept(collector);
        }
        if (workerContext.hasBeenCanceled() || relevantNodes.isEmpty()) {
            LOGGER.debug("Calculate metrics - cancelled");
            return null;
        }
        MetricsCalculator metricsCalculator = representation.getOperationMode().isLogical() ? new LogicalMetricsCalculator(workerContext, metrics, (Set<ArchitecturalViewNode>)relevantNodes) : new PhysicalMetricsCalculator(workerContext, metrics, (Set<ArchitecturalViewNode>)relevantNodes);
        for (ArchitecturalViewElement next : metrics.getElements()) {
            if (workerContext.hasBeenCanceled()) {
                LOGGER.debug("Calculate metrics - cancelled");
                return null;
            }
            next.accept(metricsCalculator);
        }
        metricsCalculator.finish();
        if (workerContext.hasBeenCanceled()) {
            LOGGER.debug("Calculate metrics - cancelled");
            return null;
        }
        LOGGER.debug("Calculate metrics - done");
        return metrics;
    }

    static final class LogicalMetricsCalculator
    extends MetricsCalculator
    implements TopLevelLogicalProgrammingElementNode.IVisitor {
        private int m_topLevelLogicalProgrammingElements;
        private int m_cyclicTopLevelLogicalProgrammingElements;
        private int m_externalTopLevelLogicalProgrammingElements;

        LogicalMetricsCalculator(IWorkerContext workerContext, ExplorationViewMetrics metrics, Set<ArchitecturalViewNode> relevantNodes) {
            super(workerContext, metrics, relevantNodes);
        }

        @Override
        protected void finish() {
            super.finish();
            this.getMetrics().addMetric(new ExplorationViewMetric("Top-level logical programming elements", this.m_topLevelLogicalProgrammingElements, 10));
            this.getMetrics().addMetric(new ExplorationViewMetric("Top-level logical programming elements (cyclic)", this.m_cyclicTopLevelLogicalProgrammingElements, 11));
            this.getMetrics().addMetric(new ExplorationViewMetric("Top-level logical programming elements (external)", this.m_externalTopLevelLogicalProgrammingElements, 30));
        }

        @Override
        public void visitTopLevelLogicalProgrammingElementNode(TopLevelLogicalProgrammingElementNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitTopLevelLogicalProgrammingElementNode' must not be null";
            if (this.done()) {
                return;
            }
            ++this.m_visited;
            if (this.include(element)) {
                boolean isExternal = element.isExternal();
                if (!isExternal) {
                    ++this.m_topLevelLogicalProgrammingElements;
                } else {
                    ++this.m_externalTopLevelLogicalProgrammingElements;
                }
                if (element.getCycleIndex() != -1) {
                    ++this.m_cyclicTopLevelLogicalProgrammingElements;
                }
                this.processArchitecturalViewNode(element);
                this.processProgrammingElements(element.getRelevantProgrammingElements(), isExternal);
                this.visitChildrenOf(element);
            }
        }

        @Override
        protected void processArchitecturalViewNode(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'processArchitecturalViewNode' must not be null";
            if (this.done()) {
                return;
            }
            NamedElement underlying = node.getFirstUnderlyingElement();
            if (underlying instanceof ModuleBasedLogicalNamespaceRoot) {
                this.processModule(node);
            } else if (underlying instanceof LogicalNamespace) {
                assert (node != null && node instanceof RecursiveNode) : "Unexpected class in method 'processArchitecturalViewNode': " + String.valueOf(node);
                if (!((RecursiveNode)node).isPart()) {
                    this.processNamespace(node);
                }
            }
            super.processArchitecturalViewNode(node);
        }
    }

    static abstract class MetricsCalculator
    extends ArchitecturalViewVisitor
    implements ArchitecturalViewNode.IVisitor,
    ArtifactPropertiesNode.IVisitor,
    ProgrammingElementNode.IVisitor {
        private static final String WORKING = "Working";
        private static final int WORKING_THRESHOLD = 1000;
        private final Set<ArchitecturalViewNode.ArchitecturalViewDependency> m_upwardDependencies = new THashSet();
        private final Set<ArchitecturalViewNode.ArchitecturalViewDependency> m_downwardDependencies = new THashSet();
        private final Set<ArchitecturalViewNode.ArchitecturalViewDependency> m_incomingDependencies = new THashSet();
        private final Set<ArchitecturalViewNode.ArchitecturalViewDependency> m_outgoingDependencies = new THashSet();
        private final Map<String, Integer> m_moduleToDistributed = new THashMap();
        private final Map<String, Integer> m_namespaceToDistributed = new THashMap();
        private final Set<String> m_externalNamespaces = new THashSet();
        private final Set<ArchitecturalViewNode> m_relevantNodes;
        private final IWorkerContext m_workerContext;
        private final ExplorationViewMetrics m_metrics;
        private final ExplorationViewFocus m_focus;
        private int m_cyclicModule;
        private int m_cyclicNamespace;
        private int m_artifacts;
        private int m_cyclicArtifacts;
        private int m_types;
        private int m_methods;
        private int m_fields;
        private int m_other;
        private int m_programmingElements;
        private int m_sourceElementCount;
        private int m_sourceElementCountFullyAnalyzed;
        private int m_sourceElementCountIssueIgnoring;
        private int m_externalTypes;
        private int m_externalMethods;
        private int m_externalFields;
        private int m_externalOther;
        private int m_externalProgrammingElements;
        protected int m_visited = 1;

        MetricsCalculator(IWorkerContext workerContext, ExplorationViewMetrics metrics, Set<ArchitecturalViewNode> relevantNodes) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'SearchVisitor' must not be null";
            assert (metrics != null) : "Parameter 'metrics' of method 'MetricsCalculator' must not be null";
            assert (relevantNodes != null && !relevantNodes.isEmpty()) : "Parameter 'relevantNodes' of method 'MetricsCalculator' must not be empty";
            this.m_workerContext = workerContext;
            this.m_metrics = metrics;
            this.m_relevantNodes = relevantNodes;
            this.m_focus = this.m_metrics.getRepresentation().getFocus().isEmpty() ? null : this.m_metrics.getRepresentation().getFocus();
        }

        protected final IWorkerContext getWorkerContext() {
            return this.m_workerContext;
        }

        @Override
        protected final boolean done() {
            if (this.m_visited % 1000 == 0) {
                this.m_workerContext.working(WORKING, false);
            }
            return this.m_workerContext.hasBeenCanceled();
        }

        protected final ExplorationViewMetrics getMetrics() {
            return this.m_metrics;
        }

        protected final boolean include(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'include' must not be null";
            return !node.isDeleted() && !node.isRemovedByFocus();
        }

        protected void processArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'processArchitecturalViewNode' must not be null";
            if (!this.m_metrics.completeRepresentation()) {
                ExplorationViewNodePositionUtility.Position position;
                for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : element.getOutgoingDependencies()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ArchitecturalViewNode nextTo = nextOut.getTo();
                    position = ExplorationViewNodePositionUtility.getPosition(element, nextTo);
                    switch (position) {
                        case UNDER: {
                            this.m_upwardDependencies.add(nextOut);
                            break;
                        }
                        case ABOVE: {
                            this.m_downwardDependencies.add(nextOut);
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled position: " + String.valueOf((Object)position);
                            break;
                        }
                    }
                    if (this.m_relevantNodes.contains(nextTo)) continue;
                    this.m_outgoingDependencies.add(nextOut);
                }
                for (ArchitecturalViewNode.ArchitecturalViewDependency nextIn : element.getIncomingDependencies()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ArchitecturalViewNode nextFrom = nextIn.getFrom();
                    position = ExplorationViewNodePositionUtility.getPosition(nextFrom, element);
                    switch (position) {
                        case UNDER: {
                            this.m_upwardDependencies.add(nextIn);
                            break;
                        }
                        case ABOVE: {
                            this.m_downwardDependencies.add(nextIn);
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled position: " + String.valueOf((Object)position);
                            break;
                        }
                    }
                    if (this.m_relevantNodes.contains(nextFrom)) continue;
                    this.m_incomingDependencies.add(nextIn);
                }
            } else {
                block17: for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : element.getOutgoingDependencies()) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ArchitecturalViewNode nextTo = nextOut.getTo();
                    ExplorationViewNodePositionUtility.Position position = ExplorationViewNodePositionUtility.getPosition(element, nextTo);
                    switch (position) {
                        case UNDER: {
                            this.m_upwardDependencies.add(nextOut);
                            break;
                        }
                        case ABOVE: {
                            this.m_downwardDependencies.add(nextOut);
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled position: " + String.valueOf((Object)position);
                            continue block17;
                        }
                    }
                }
            }
        }

        protected final void processModule(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'processModule' must not be null";
            String name = node.getName();
            Integer distributed = this.m_moduleToDistributed.get(name);
            if (distributed == null) {
                this.m_moduleToDistributed.put(name, 1);
            } else {
                this.m_moduleToDistributed.put(name, distributed + 1);
            }
            if (node.getCycleIndex() != -1) {
                ++this.m_cyclicModule;
            }
        }

        protected final void processNamespace(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'processNamespace' must not be null";
            String name = node.getName();
            if (node.isExternal()) {
                this.m_externalNamespaces.add(name);
            } else {
                Integer distributed = this.m_namespaceToDistributed.get(name);
                if (distributed == null) {
                    this.m_namespaceToDistributed.put(name, 1);
                } else {
                    this.m_namespaceToDistributed.put(name, distributed + 1);
                }
                if (node.getCycleIndex() != -1) {
                    ++this.m_cyclicNamespace;
                }
            }
        }

        protected final void processProgrammingElements(Collection<? extends ProgrammingElement> programmingElements, boolean isExternal) {
            assert (programmingElements != null) : "Parameter 'programmingElements' of method 'processProgrammingElement' must not be null";
            if (isExternal) {
                for (ProgrammingElement programmingElement : programmingElements) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (programmingElement instanceof EmptyNodeProgrammingElement || this.m_focus != null && !this.m_focus.includesProgrammingElement(programmingElement)) continue;
                    if (programmingElement instanceof IType) {
                        ++this.m_externalTypes;
                    } else if (programmingElement instanceof IRoutine) {
                        ++this.m_externalMethods;
                    } else if (programmingElement instanceof IField) {
                        ++this.m_externalFields;
                    } else {
                        ++this.m_externalOther;
                    }
                    ++this.m_externalProgrammingElements;
                }
            } else {
                for (ProgrammingElement programmingElement : programmingElements) {
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (programmingElement instanceof EmptyNodeProgrammingElement || this.m_focus != null && !this.m_focus.includesProgrammingElement(programmingElement)) continue;
                    if (programmingElement instanceof IType) {
                        ++this.m_types;
                    } else if (programmingElement instanceof IRoutine) {
                        ++this.m_methods;
                    } else if (programmingElement instanceof IField) {
                        ++this.m_fields;
                    } else {
                        ++this.m_other;
                    }
                    ++this.m_programmingElements;
                    int sec = programmingElement.getSourceElementCount();
                    if (sec == -1) continue;
                    this.m_sourceElementCount += sec;
                    if (programmingElement.ignoreIssues()) {
                        this.m_sourceElementCountIssueIgnoring += sec;
                        continue;
                    }
                    this.m_sourceElementCountFullyAnalyzed += sec;
                }
            }
        }

        @Override
        public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            ++this.m_visited;
            if (this.include(element)) {
                this.processArchitecturalViewNode(element);
                this.visitChildrenOf(element);
            }
        }

        @Override
        public final void visitArtifactPropertiesNode(ArtifactPropertiesNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactPropertiesNode' must not be null";
            ++this.m_visited;
            if (this.include(element)) {
                ++this.m_artifacts;
                if (element.getCycleIndex() != -1) {
                    ++this.m_cyclicArtifacts;
                }
                this.processArchitecturalViewNode(element);
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitProgrammingElementNode(ProgrammingElementNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElementNode' must not be null";
            ++this.m_visited;
            if (this.include(element)) {
                this.processArchitecturalViewNode(element);
                this.processProgrammingElements(element.getRelevantProgrammingElements(), element.isExternal());
                this.visitChildrenOf(element);
            }
        }

        protected void finish() {
            this.m_metrics.addMetric(new ExplorationViewMetric("Modules", this.m_moduleToDistributed.size(), 0));
            int distributed = 0;
            for (Integer next : this.m_moduleToDistributed.values()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                distributed += next.intValue();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Modules (distributed)", distributed, 1));
            this.m_metrics.addMetric(new ExplorationViewMetric("Modules (distributed, cyclic)", this.m_cyclicModule, 2));
            this.m_metrics.addMetric(new ExplorationViewMetric("Artifacts", this.m_artifacts, 3));
            this.m_metrics.addMetric(new ExplorationViewMetric("Artifacts (cyclic)", this.m_cyclicArtifacts, 4));
            this.m_metrics.addMetric(new ExplorationViewMetric(this.m_metrics.getNamespacePresentationNames(), this.m_namespaceToDistributed.size(), 5));
            distributed = 0;
            for (Integer next : this.m_namespaceToDistributed.values()) {
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                distributed += next.intValue();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric(this.m_metrics.getNamespacePresentationNames() + " (distributed)", distributed, 6));
            this.m_metrics.addMetric(new ExplorationViewMetric(this.m_metrics.getNamespacePresentationNames() + " (distributed, cyclic)", this.m_cyclicNamespace, 7));
            this.m_metrics.addMetric(new ExplorationViewMetric("Types", this.m_types, 20));
            this.m_metrics.addMetric(new ExplorationViewMetric("Methods", this.m_methods, 21));
            this.m_metrics.addMetric(new ExplorationViewMetric("Fields", this.m_fields, 22));
            this.m_metrics.addMetric(new ExplorationViewMetric("Other", this.m_other, 23));
            this.m_metrics.addMetric(new ExplorationViewMetric("Programming elements", this.m_programmingElements, 24));
            this.m_metrics.addMetric(new ExplorationViewMetric("Source element count", this.m_sourceElementCount, 25));
            this.m_metrics.addMetric(new ExplorationViewMetric("Source element count (fully analyzed)", this.m_sourceElementCountFullyAnalyzed, 26));
            this.m_metrics.addMetric(new ExplorationViewMetric("Source element count (issue ignoring)", this.m_sourceElementCountIssueIgnoring, 27));
            this.m_metrics.addMetric(new ExplorationViewMetric(this.m_metrics.getNamespacePresentationNames() + " (external)", this.m_externalNamespaces.size(), 28));
            this.m_metrics.addMetric(new ExplorationViewMetric("Types (external)", this.m_externalTypes, 40));
            this.m_metrics.addMetric(new ExplorationViewMetric("Methods (external)", this.m_externalMethods, 41));
            this.m_metrics.addMetric(new ExplorationViewMetric("Fields (external)", this.m_externalFields, 42));
            this.m_metrics.addMetric(new ExplorationViewMetric("Other (external)", this.m_externalOther, 43));
            this.m_metrics.addMetric(new ExplorationViewMetric("Programming elements (external)", this.m_externalProgrammingElements, 44));
            int outgoingDependencies = 0;
            int outgoingDependenciesViolating = 0;
            int outgoingDependenciesViolatingIgnored = 0;
            int outgoingDependenciesDeprecated = 0;
            int outgoingDependenciesDeprecatedIgnored = 0;
            for (ArchitecturalViewNode.ArchitecturalViewDependency next : this.m_outgoingDependencies) {
                this.m_workerContext.working(WORKING, false);
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                outgoingDependencies += next.getNumberOfParserDependencies();
                outgoingDependenciesViolating += next.getNumberOfParserDependenciesViolating();
                outgoingDependenciesViolatingIgnored += next.getNumberOfParserDependenciesViolatingIgnored();
                outgoingDependenciesDeprecated += next.getNumberOfParserDependenciesDeprecated();
                outgoingDependenciesDeprecatedIgnored += next.getNumberOfParserDependenciesDeprecatedIgnored();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Outgoing parser dependencies", outgoingDependencies, 70));
            this.m_metrics.addMetric(new ExplorationViewMetric("Outgoing parser dependencies (violating)", outgoingDependenciesViolating, 71));
            this.m_metrics.addMetric(new ExplorationViewMetric("Outgoing parser dependencies (violating ignored)", outgoingDependenciesViolatingIgnored, 72));
            this.m_metrics.addMetric(new ExplorationViewMetric("Outgoing parser dependencies (deprecated)", outgoingDependenciesDeprecated, 73));
            this.m_metrics.addMetric(new ExplorationViewMetric("Outgoing parser dependencies (deprecated ignored)", outgoingDependenciesDeprecatedIgnored, 74));
            int incomingDependencies = 0;
            int incomingDependenciesViolating = 0;
            int incomingDependenciesViolatingIgnored = 0;
            int incomingDependenciesDeprecated = 0;
            int incomingDependenciesDeprecatedIgnored = 0;
            for (ArchitecturalViewNode.ArchitecturalViewDependency next : this.m_incomingDependencies) {
                this.m_workerContext.working(WORKING, false);
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                incomingDependencies += next.getNumberOfParserDependencies();
                incomingDependenciesViolating += next.getNumberOfParserDependenciesViolating();
                incomingDependenciesViolatingIgnored += next.getNumberOfParserDependenciesViolatingIgnored();
                incomingDependenciesDeprecated += next.getNumberOfParserDependenciesDeprecated();
                incomingDependenciesDeprecatedIgnored += next.getNumberOfParserDependenciesDeprecatedIgnored();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Incoming parser dependencies", incomingDependencies, 80));
            this.m_metrics.addMetric(new ExplorationViewMetric("Incoming parser dependencies (violating)", incomingDependenciesViolating, 81));
            this.m_metrics.addMetric(new ExplorationViewMetric("Incoming parser dependencies (violating ignored)", incomingDependenciesViolatingIgnored, 82));
            this.m_metrics.addMetric(new ExplorationViewMetric("Incoming parser dependencies (deprecated)", incomingDependenciesDeprecated, 83));
            this.m_metrics.addMetric(new ExplorationViewMetric("Incoming parser dependencies (deprecated ignored)", incomingDependenciesDeprecatedIgnored, 84));
            int innerDependencies = 0;
            int innerDependenciesViolating = 0;
            int innerDependenciesViolatingIgnored = 0;
            int innerDependenciesDeprecated = 0;
            int innerDependenciesDeprecatedIgnored = 0;
            if (this.m_metrics.completeRepresentation() && this.m_focus == null) {
                ParserDependencyNumbers numbers = this.m_metrics.getRepresentation().getParserDependencyNumbers();
                innerDependencies = numbers.getAll();
                innerDependenciesViolating = numbers.getViolations();
                innerDependenciesViolatingIgnored = numbers.getViolationsIgnored();
                innerDependenciesDeprecated = numbers.getDeprecations();
                innerDependenciesDeprecatedIgnored = numbers.getDeprecationsIgnored();
            } else {
                THashSet relevantProgrammingElements = new THashSet();
                for (ArchitecturalViewNode next : this.m_relevantNodes) {
                    this.m_workerContext.working(WORKING, false);
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    relevantProgrammingElements.addAll(next.getRelevantProgrammingElements());
                }
                ExplorationViewRepresentation representation = this.m_metrics.getRepresentation();
                ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
                int processing = 0;
                for (ProgrammingElement nextProgrammingElement : relevantProgrammingElements) {
                    if (++processing % 1000 == 0) {
                        this.m_workerContext.working(WORKING, false);
                    }
                    if (this.m_workerContext.hasBeenCanceled()) {
                        return;
                    }
                    Iterator<Element> depIter = nextProgrammingElement.getDependencyIterator();
                    while (depIter.hasNext()) {
                        DeprecationInfo nextDeprecationInfo;
                        if (this.m_workerContext.hasBeenCanceled()) {
                            return;
                        }
                        ParserDependency nextParserDependency = depIter.next();
                        ParserDependencyState includeOutgoing = representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, true, endPoints);
                        if (!includeOutgoing.isIncluded() || !relevantProgrammingElements.contains(endPoints.getTo())) continue;
                        ++innerDependencies;
                        ViolationInfo nextViolationInfo = representation.isViolation(nextParserDependency);
                        if (nextViolationInfo != null) {
                            if (nextViolationInfo.isIgnored()) {
                                ++innerDependenciesViolatingIgnored;
                            } else {
                                ++innerDependenciesViolating;
                            }
                        }
                        if ((nextDeprecationInfo = representation.isDeprecation(nextParserDependency)) == null) continue;
                        if (nextDeprecationInfo.isIgnored()) {
                            ++innerDependenciesDeprecatedIgnored;
                            continue;
                        }
                        ++innerDependenciesDeprecated;
                    }
                }
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Inner parser dependencies", innerDependencies, 90));
            this.m_metrics.addMetric(new ExplorationViewMetric("Inner parser dependencies (violating)", innerDependenciesViolating, 91));
            this.m_metrics.addMetric(new ExplorationViewMetric("Inner parser dependencies (violating ignored)", innerDependenciesViolatingIgnored, 92));
            this.m_metrics.addMetric(new ExplorationViewMetric("Inner parser dependencies (deprecated)", innerDependenciesDeprecated, 93));
            this.m_metrics.addMetric(new ExplorationViewMetric("Inner parser dependencies (deprecated ignored)", innerDependenciesDeprecatedIgnored, 94));
            int downwardDependencies = 0;
            int downwardDependenciesViolating = 0;
            int downwardDependenciesViolatingIgnored = 0;
            int downwardDependenciesDeprecated = 0;
            int downwardDependenciesDeprecatedIgnored = 0;
            for (ArchitecturalViewNode.ArchitecturalViewDependency next : this.m_downwardDependencies) {
                this.m_workerContext.working(WORKING, false);
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                downwardDependencies += next.getNumberOfParserDependencies();
                downwardDependenciesViolating += next.getNumberOfParserDependenciesViolating();
                downwardDependenciesViolatingIgnored += next.getNumberOfParserDependenciesViolatingIgnored();
                downwardDependenciesDeprecated += next.getNumberOfParserDependenciesDeprecated();
                downwardDependenciesDeprecatedIgnored += next.getNumberOfParserDependenciesDeprecatedIgnored();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Downward parser dependencies", downwardDependencies, 100));
            this.m_metrics.addMetric(new ExplorationViewMetric("Downward parser dependencies (violating)", downwardDependenciesViolating, 101));
            this.m_metrics.addMetric(new ExplorationViewMetric("Downward parser dependencies (violating ignored)", downwardDependenciesViolatingIgnored, 102));
            this.m_metrics.addMetric(new ExplorationViewMetric("Downward parser dependencies (deprecated)", downwardDependenciesDeprecated, 103));
            this.m_metrics.addMetric(new ExplorationViewMetric("Downward parser dependencies (deprecated ignored)", downwardDependenciesDeprecatedIgnored, 104));
            int upwardDependencies = 0;
            int upwardDependenciesViolating = 0;
            int upwardDependenciesViolatingIgnored = 0;
            int upwardDependenciesDeprecated = 0;
            int upwardDependenciesDeprecatedIgnored = 0;
            for (ArchitecturalViewNode.ArchitecturalViewDependency next : this.m_upwardDependencies) {
                this.m_workerContext.working(WORKING, false);
                if (this.m_workerContext.hasBeenCanceled()) {
                    return;
                }
                upwardDependencies += next.getNumberOfParserDependencies();
                upwardDependenciesViolating += next.getNumberOfParserDependenciesViolating();
                upwardDependenciesViolatingIgnored += next.getNumberOfParserDependenciesViolatingIgnored();
                upwardDependenciesDeprecated += next.getNumberOfParserDependenciesDeprecated();
                upwardDependenciesDeprecatedIgnored += next.getNumberOfParserDependenciesDeprecatedIgnored();
            }
            this.m_metrics.addMetric(new ExplorationViewMetric("Upward parser dependencies", upwardDependencies, 110));
            this.m_metrics.addMetric(new ExplorationViewMetric("Upward parser dependencies (violating)", upwardDependenciesViolating, 111));
            this.m_metrics.addMetric(new ExplorationViewMetric("Upward parser dependencies (violating ignored)", upwardDependenciesViolatingIgnored, 112));
            this.m_metrics.addMetric(new ExplorationViewMetric("Upward parser dependencies (deprecated)", upwardDependenciesDeprecated, 113));
            this.m_metrics.addMetric(new ExplorationViewMetric("Upward parser dependencies (deprecated ignored)", upwardDependenciesDeprecatedIgnored, 114));
        }
    }

    static final class PhysicalMetricsCalculator
    extends MetricsCalculator
    implements ComponentNode.IVisitor {
        private int m_components;
        private int m_cyclicComponents;
        private int m_externalComponents;
        private int m_sourceFiles;
        private int m_totalLines;
        private int m_linesOfCode;
        private int m_linesOfCodeFullyAnalyzed;
        private int m_linesOfCodeIssueIgnoring;
        private int m_commentLines;
        private int m_codeCommentLines;

        PhysicalMetricsCalculator(IWorkerContext workerContext, ExplorationViewMetrics metrics, Set<ArchitecturalViewNode> relevantNodes) {
            super(workerContext, metrics, relevantNodes);
        }

        private void process(SourceFile sourceFile) {
            assert (sourceFile != null) : "Parameter 'sourceFile' of method 'process' must not be null";
            if (this.done()) {
                return;
            }
            ++this.m_sourceFiles;
            int metric = sourceFile.getTotalLines();
            if (metric != -1) {
                this.m_totalLines += metric;
            }
            if ((metric = sourceFile.getLinesOfCode()) != -1) {
                this.m_linesOfCode += metric;
                if (sourceFile.ignoreIssues()) {
                    this.m_linesOfCodeIssueIgnoring += metric;
                } else {
                    this.m_linesOfCodeFullyAnalyzed += metric;
                }
            }
            if ((metric = sourceFile.getCommentLines()) != -1) {
                this.m_commentLines += metric;
            }
            if ((metric = sourceFile.getCodeCommentLines()) != -1) {
                this.m_codeCommentLines += metric;
            }
        }

        @Override
        public void visitComponentNode(ComponentNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitComponentNode' must not be null";
            if (this.done()) {
                return;
            }
            ++this.m_visited;
            if (this.include(element)) {
                boolean isExternal = element.isExternal();
                if (!isExternal) {
                    ++this.m_components;
                    for (NamedElement next : element.getUnderlyingElements()) {
                        if (this.getWorkerContext().hasBeenCanceled()) {
                            return;
                        }
                        if (next.isExcluded()) continue;
                        if (next instanceof SourceFile) {
                            this.process((SourceFile)next);
                            continue;
                        }
                        for (SourceFile nextSourceFile : next.getChildrenRecursively(SourceFile.class, ProgrammingElement.class, NamespaceFragment.class)) {
                            if (this.getWorkerContext().hasBeenCanceled()) {
                                return;
                            }
                            this.process(nextSourceFile);
                        }
                    }
                    if (element.getCycleIndex() != -1) {
                        ++this.m_cyclicComponents;
                    }
                } else {
                    ++this.m_externalComponents;
                }
                this.processArchitecturalViewNode(element);
                if (!element.hasChildren()) {
                    this.processProgrammingElements(element.getRelevantProgrammingElements(), isExternal);
                }
                this.visitChildrenOf(element);
            }
        }

        @Override
        protected void finish() {
            super.finish();
            this.getMetrics().addMetric(new ExplorationViewMetric("Components", this.m_components, 10));
            this.getMetrics().addMetric(new ExplorationViewMetric("Components (cyclic)", this.m_cyclicComponents, 11));
            this.getMetrics().addMetric(new ExplorationViewMetric("Components (external)", this.m_externalComponents, 30));
            this.getMetrics().addMetric(new ExplorationViewMetric("Source files", this.m_sourceFiles, 50));
            this.getMetrics().addMetric(new ExplorationViewMetric("Total lines", this.m_totalLines, 51));
            this.getMetrics().addMetric(new ExplorationViewMetric("Lines of code", this.m_linesOfCode, 52));
            this.getMetrics().addMetric(new ExplorationViewMetric("Lines of code (fully analyzed)", this.m_linesOfCodeFullyAnalyzed, 53));
            this.getMetrics().addMetric(new ExplorationViewMetric("Lines of code (issue ignoring)", this.m_linesOfCodeIssueIgnoring, 54));
            this.getMetrics().addMetric(new ExplorationViewMetric("Comment lines", this.m_commentLines, 55));
            this.getMetrics().addMetric(new ExplorationViewMetric("Code comment lines", this.m_codeCommentLines, 56));
        }

        @Override
        protected void processArchitecturalViewNode(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'processArchitecturalViewNode' must not be null";
            if (this.done()) {
                return;
            }
            NamedElement underlying = node.getFirstUnderlyingElement();
            if (underlying instanceof Module) {
                this.processModule(node);
            } else if (underlying instanceof NamespaceFragment) {
                assert (node != null && node instanceof RecursiveNode) : "Unexpected class in method 'processArchitecturalViewNode': " + String.valueOf(node);
                if (!((RecursiveNode)node).isPart()) {
                    this.processNamespace(node);
                }
            }
            super.processArchitecturalViewNode(node);
        }
    }
}

