/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewContextDependency;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewContext;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckIssue;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.List;
import java.util.stream.Collectors;

public final class ExplorationViewBasedOnArchitectureFileContext
extends ExplorationViewContext {
    public ExplorationViewBasedOnArchitectureFileContext(IContext defaultContext, ExplorationViewRepresentation representation) {
        super(defaultContext, representation);
        assert (this.getRepresentation().getBasedOnArchitectureFile() != null) : "Not architecture file based";
    }

    public String getStandardName() {
        return this.getRepresentation().getBasedOnArchitectureFile();
    }

    public String getPresentationName() {
        return this.getRepresentation().getBasedOnArchitectureFile();
    }

    @Override
    public ContextParserDependency create(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'create' must not be null";
        return new ArchitecturalViewContextDependency(dependency, this.getRepresentation());
    }

    @Override
    public boolean isViolation(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'isViolation' must not be null";
        ViolationInfo info = this.getRepresentation().isViolation(dependency);
        return info != null && !info.isIgnored();
    }

    @Override
    public String getViolationInfo(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getViolationInfo' must not be null";
        ViolationInfo info = this.getRepresentation().isViolation(dependency);
        if (info != null && !info.isIgnored()) {
            return this.getViolationCausesInfo(info.getCauses());
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Provides access to violations created from '" + this.getRepresentation().getBasedOnArchitectureFile() + "'";
    }

    @Override
    public List<Issue> collectIssues(ElementWithIssues element, boolean recursively) {
        String basedOnArchitectureFile = this.getRepresentation().getBasedOnArchitectureFile();
        return this.getDefaultContext().collectIssues(element, recursively).stream().filter(issue -> {
            if (issue.getId().getCategory() == IssueCategory.ARCHITECTURE_VIOLATION || issue.getId().getCategory() == IssueCategory.ARCHITECTURE_DEPRECATION) {
                assert (issue != null && issue instanceof ArchitectureCheckIssue) : "Unexpected class in method 'collectIssues': " + String.valueOf(issue);
                IProviderId nextProviderId = issue.getProvider();
                return nextProviderId.getStandardName().equals(basedOnArchitectureFile);
            }
            return true;
        }).collect(Collectors.toList());
    }
}

