/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.CollapseInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.DependencyHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureIntegrityChecker;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpandCollapseHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpandCollapseHandler.class);

    private ExpandCollapseHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ArchitecturalViewNode> expand(ArchitecturalViewNode node, boolean autoExpand, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'expand' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'expand' must not be null";
        assert (node.isExpandable()) : "Not expandable: " + node.getElementInfo();
        assert (!node.isExpanded()) : "Already expanded: " + node.getElementInfo();
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            long start = System.currentTimeMillis();
            LOGGER.debug("Expand node");
            DependencyHandler.removeDependencies(node, true, representation);
            ArchitecturalViewNode currentParent = node;
            ArrayList<ArchitecturalViewNode> allChildren = new ArrayList<ArchitecturalViewNode>();
            List<ArchitecturalViewNode> currentChildren = null;
            if (autoExpand && node.supportsAutoExpand()) {
                boolean expand;
                do {
                    ArchitecturalViewNode onlyChild;
                    expand = false;
                    representation.getCreator().aboutToAccessChildrenOf(node, representation);
                    currentParent.setExpanded(true);
                    currentChildren = currentParent.getNodeChildren(ArchitecturalViewElement.NOT_REMOVED, false);
                    if (currentChildren.size() != 1 || !(onlyChild = currentChildren.get(0)).isExpandable() || !onlyChild.supportsAutoExpand()) continue;
                    expand = true;
                    currentParent = onlyChild;
                    allChildren.add(onlyChild);
                } while (expand);
            } else {
                representation.getCreator().aboutToAccessChildrenOf(node, representation);
                currentParent.setExpanded(true);
                currentChildren = currentParent.getNodeChildren(ArchitecturalViewElement.NOT_REMOVED, false);
            }
            for (ArchitecturalViewNode nextChild : currentChildren) {
                assert (!nextChild.isExpanded()) : "Already expanded: " + String.valueOf(nextChild);
            }
            DependencyHandler.createDependenciesInExpandOrCollapse(currentChildren, representation);
            StructureIntegrityChecker.check(representation, false);
            allChildren.addAll(currentParent.getSortedVisibleNodeChildren());
            LOGGER.debug("Expand node - done [" + (System.currentTimeMillis() - start) + " ms]");
            return allChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int collapse(ArchitecturalViewNode node, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'collapse' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'collapse' must not be null";
        assert (node.isExpanded()) : "Not expanded: " + node.getElementInfo();
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            long start = System.currentTimeMillis();
            LOGGER.debug("Collapse node");
            CollapseInfo info = new CollapseInfo();
            DependencyHandler.removeDependencies(node, false, representation);
            RepresentationHandler.collapse(node.getNodeChildren(ArchitecturalViewElement.NOT_REMOVED, false), info, representation);
            node.setExpanded(false);
            node.setSelected(node.isSelected() || info.getNumberOfSelectedChildren() > 0);
            DependencyHandler.createDependenciesInExpandOrCollapse(Collections.singletonList(node), representation);
            StructureIntegrityChecker.check(representation, false);
            LOGGER.debug("Collapse node - done [" + (System.currentTimeMillis() - start) + " ms]");
            return info.getNumberOfVisibleChildren();
        }
    }
}

