/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class ArtifactNodeQualifiedNameSupport {
    private static final String QUALIFIED_NAME_SEPARATOR = ".";

    private ArtifactNodeQualifiedNameSupport() {
    }

    static String getQualifiedName(List<ArtifactNode> sourceParents, List<ArtifactNode> targetParents, ArtifactNode target, Collection<ArtifactNode> exposedCollector) {
        assert (sourceParents != null) : "Parameter 'sourceParents' of method 'getQualifiedName' must not be null";
        assert (targetParents != null) : "Parameter 'targetParents' of method 'getQualifiedName' must not be null";
        assert (target != null) : "Parameter 'target' of method 'getQualifiedName' must not be null";
        if (targetParents.isEmpty()) {
            return target.getShortName();
        }
        if (sourceParents.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            targetParents.forEach(t -> {
                StringBuilder stringBuilder2 = builder.append(t.getShortName()).append(QUALIFIED_NAME_SEPARATOR);
            });
            builder.append(target.getShortName());
            if (exposedCollector != null) {
                targetParents.subList(1, targetParents.size()).forEach(t -> {
                    boolean bl = exposedCollector.add((ArtifactNode)t);
                });
                exposedCollector.add(target);
            }
            return builder.toString();
        }
        if (sourceParents.get(sourceParents.size() - 1) == targetParents.get(targetParents.size() - 1)) {
            return target.getShortName();
        }
        ArtifactNode currentSourceParent = null;
        ArtifactNode currentTargetParent = null;
        int i = -1;
        while ((currentSourceParent = sourceParents.get(++i)) == (currentTargetParent = targetParents.get(i)) && i < sourceParents.size() && i < targetParents.size()) {
        }
        StringBuilder builder = new StringBuilder();
        int j = i;
        while (j < targetParents.size()) {
            builder.append(targetParents.get(j).getShortName()).append(QUALIFIED_NAME_SEPARATOR);
            ++j;
        }
        if (exposedCollector != null) {
            targetParents.subList(i + 1, targetParents.size()).forEach(t -> {
                boolean bl = exposedCollector.add((ArtifactNode)t);
            });
            exposedCollector.add(target);
        }
        builder.append(target.getShortName());
        return builder.toString();
    }

    private static ArtifactNode findByQualifiedName(ArchitecturalViewElement element, String qualifiedName) {
        assert (element != null) : "Parameter 'element' of method 'findByQualifiedName' must not be null";
        assert (qualifiedName != null && qualifiedName.length() > 0) : "Parameter 'qualifiedName' of method 'findByQualifiedName' must not be empty";
        ArchitecturalViewElement current = element;
        ArtifactNode found = null;
        String[] stringArray = qualifiedName.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            for (ArtifactNode nextArtifactChild : current.getChildren(ArtifactNode.class)) {
                if (!nextArtifactChild.getShortName().equals(next)) continue;
                found = nextArtifactChild;
                break;
            }
            if (found == null) break;
            current = found;
            ++n2;
        }
        return found;
    }

    static boolean isArtifactReachableWithQualifiedName(ArtifactNode from, ArtifactNode to) {
        assert (from != null) : "Parameter 'from' of method 'isArtifactReachableWithQualifiedName' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isArtifactReachableWithQualifiedName' must not be null";
        if (from == to || from.hasAsParent(to, false) || to.hasAsParent(from, false)) {
            return false;
        }
        List<ArtifactNode> fromParents = from.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
        Collections.reverse(fromParents);
        List<ArtifactNode> toParents = to.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
        Collections.reverse(toParents);
        String qualifiedName = ArtifactNodeQualifiedNameSupport.getQualifiedName(fromParents, toParents, to, null);
        ArchitecturalViewElement current = from.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
        while (current != null) {
            ArtifactNode found = ArtifactNodeQualifiedNameSupport.findByQualifiedName(current, qualifiedName);
            if (found != null) {
                if (found != to) {
                    return false;
                }
                current = current.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
                continue;
            }
            current = null;
        }
        return true;
    }
}

