/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.base.SourceLineMatcher;
import com.hello2morrow.sonargraph.core.controller.system.diff.IResolutionChangeProvider;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueMatcher;
import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.IssueWithDescription;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.GenericNamedElementIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.LineBasedIssueDiff;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.integration.access.model.ILineBasedIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class LineBasedIssueMatcher
extends SimpleIssueMatcher<INamedElementIssue, NamedElementIssue> {
    private HashMap<NamedElementIssue, String> m_currentPatternMap = new HashMap();
    private Map<NamedElementIssue, SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>> m_currentToBestMatch = new HashMap<NamedElementIssue, SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>>();

    public LineBasedIssueMatcher(IResolutionChangeProvider<INamedElementIssue, NamedElementIssue> resolutionChangeProvider) {
        super(resolutionChangeProvider);
    }

    @Override
    protected IssueDiff<INamedElementIssue, NamedElementIssue> createDiff(NamedElement parent, INamedElementIssue baselineIssue, NamedElementIssue currentIssue, IDiffElement.Change change, String changeDescription) {
        if (changeDescription == null) {
            if ((baselineIssue == null || baselineIssue instanceof ILineBasedIssue) && (currentIssue == null || currentIssue instanceof IIssueWithLineContext)) {
                return new LineBasedIssueDiff(parent, (ILineBasedIssue)baselineIssue, (IssueWithDescription)currentIssue, change);
            }
            return new GenericNamedElementIssueDiff(parent, baselineIssue, currentIssue, change);
        }
        if ((baselineIssue == null || baselineIssue instanceof ILineBasedIssue) && (currentIssue == null || currentIssue instanceof IIssueWithLineContext)) {
            return new LineBasedIssueDiff(parent, (ILineBasedIssue)baselineIssue, (IssueWithDescription)currentIssue, change, changeDescription);
        }
        return new GenericNamedElementIssueDiff(parent, baselineIssue, currentIssue, change, changeDescription);
    }

    @Override
    protected SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> findMatchingIssue(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'findMatchingIssue' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'findMatchingIssue' must not be null";
        if (baselineIssue instanceof ILineBasedIssue) {
            return this.similarityMatch(baselineIssue, currentIssues);
        }
        return this.exactMatch(baselineIssue, currentIssues);
    }

    private SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> exactMatch(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'exactMatch' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'exactMatch' must not be null";
        for (NamedElementIssue nextCurrent : currentIssues) {
            if (!(!(baselineIssue instanceof ILineBasedIssue) ? baselineIssue.getIssueProvider().getName().equals(nextCurrent.getProvider().getStandardName()) && baselineIssue.getDescription().equals(nextCurrent.getDescription()) : baselineIssue.getLine() == nextCurrent.getLineNumber() && baselineIssue.getIssueProvider().getName().equals(nextCurrent.getProvider().getStandardName()) && baselineIssue.getDescription().equals(nextCurrent.getDescription()))) continue;
            return new SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, 1.0, IDiffElement.Change.UNMODIFIED, "");
        }
        return null;
    }

    private SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> similarityMatch(INamedElementIssue baselineIssue, Set<NamedElementIssue> currentIssues) {
        ILineBasedIssue baseline = (ILineBasedIssue)baselineIssue;
        INamedElement namedElement = (INamedElement)baseline.getAffectedNamedElements().get(0);
        String baselineFqName = namedElement.getOriginalFqName().orElse(namedElement.getFqName());
        String baselinePattern = LineBasedContextSimilarityMatchPattern.createPattern(baselineFqName, baseline.getLine(), baseline.getLineText(), new IntBasedHash(baseline.getPrefixHashs()), new IntBasedHash(baseline.getPostfixHashs()));
        SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> bestMatch = null;
        for (NamedElementIssue nextCurrent : currentIssues) {
            StrictPair<IDiffElement.Change, String> changeAndDescription;
            double previousSimilarity;
            SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> previous;
            assert (nextCurrent != null && nextCurrent instanceof IIssueWithLineContext) : "Unexpected class in method 'findMatchingIssue': " + String.valueOf(nextCurrent);
            IIssueWithLineContext lineContextIssue = (IIssueWithLineContext)((Object)nextCurrent);
            String currentPattern = this.m_currentPatternMap.get(nextCurrent);
            if (currentPattern == null) {
                currentPattern = LineBasedContextSimilarityMatchPattern.createPattern(lineContextIssue);
                this.m_currentPatternMap.put(nextCurrent, currentPattern);
            }
            if (baselinePattern.equals(currentPattern)) {
                return new SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, 1.0, IDiffElement.Change.UNMODIFIED, "");
            }
            StrictPair<Double, Set<SourceLineMatcher.TextModification>> similarityResult = SourceLineMatcher.getSimilarity(lineContextIssue, baselineFqName, baseline.getLineText(), baseline.getLine(), new IntBasedHash(baseline.getPrefixHashs()), new IntBasedHash(baseline.getPostfixHashs()));
            double similarity = (Double)similarityResult.getFirst();
            if (Double.compare(similarity, 0.6) < 0) continue;
            if (bestMatch != null) {
                if (Double.compare(similarity, bestMatch.getSimilarity()) <= 0) continue;
                previous = this.m_currentToBestMatch.get(nextCurrent);
                double d = previousSimilarity = previous != null ? previous.getSimilarity() : -1.0;
                if (Double.compare(similarity, previousSimilarity) <= 0) continue;
                changeAndDescription = this.convertToChange(similarity, (Set)similarityResult.getSecond());
                bestMatch = new SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, similarity, (IDiffElement.Change)((Object)changeAndDescription.getFirst()), (String)changeAndDescription.getSecond());
                continue;
            }
            previous = this.m_currentToBestMatch.get(nextCurrent);
            double d = previousSimilarity = previous != null ? previous.getSimilarity() : -1.0;
            if (Double.compare(similarity, previousSimilarity) <= 0) continue;
            changeAndDescription = this.convertToChange(similarity, (Set)similarityResult.getSecond());
            bestMatch = new SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>(baselineIssue, nextCurrent, similarity, (IDiffElement.Change)((Object)changeAndDescription.getFirst()), (String)changeAndDescription.getSecond());
        }
        return bestMatch;
    }

    private StrictPair<IDiffElement.Change, String> convertToChange(double similarity, Set<SourceLineMatcher.TextModification> modifications) {
        assert (modifications != null) : "Parameter 'modifications' of method 'convertToChange' must not be null";
        if (modifications.contains((Object)SourceLineMatcher.TextModification.UNMODIFIED)) {
            return new StrictPair((Object)IDiffElement.Change.UNMODIFIED, (Object)"");
        }
        String description = modifications.stream().map(m -> m.getPresentationName()).collect(Collectors.joining(", ", "Modifications: ", "; Similarity: " + NumberUtility.format((Number)similarity)));
        return new StrictPair((Object)IDiffElement.Change.MODIFIED, (Object)description);
    }

    @Override
    protected void processIssues(NamedElement parent, List<INamedElementIssue> baselineIssues, Set<INamedElementIssue> baselineNamedElementIssues, Set<NamedElementIssue> currentNamedElementIssues) {
        this.m_currentPatternMap = new HashMap();
        this.m_currentToBestMatch = new HashMap<NamedElementIssue, SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue>>();
        this.matchIssues(baselineIssues, currentNamedElementIssues);
        for (SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> nextMatch : this.m_currentToBestMatch.values()) {
            this.handleMatch(parent, baselineNamedElementIssues, currentNamedElementIssues, nextMatch);
        }
    }

    private void matchIssues(List<INamedElementIssue> baselineIssues, Set<NamedElementIssue> currentNamedElementIssues) {
        ArrayList<INamedElementIssue> leftOverBaselineIssues = new ArrayList<INamedElementIssue>();
        for (INamedElementIssue nextBaseline : baselineIssues) {
            SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> previousBestMatch;
            SimpleIssueMatcher.MatchResult<INamedElementIssue, NamedElementIssue> match = this.findMatchingIssue(nextBaseline, currentNamedElementIssues);
            if (match == null) continue;
            NamedElementIssue current = match.getCurrentIssue();
            double similarity = match.getSimilarity();
            if (Double.compare(similarity, 1.0) == 0) {
                currentNamedElementIssues.remove(current);
            }
            if ((previousBestMatch = this.m_currentToBestMatch.get(current)) != null) {
                double previousSimilarity = previousBestMatch.getSimilarity();
                assert (Double.compare(similarity, previousSimilarity) > 0) : "Previous match must only exist if current similarity is higher.";
                leftOverBaselineIssues.add(previousBestMatch.getBaselineIssue());
            }
            this.m_currentToBestMatch.put(current, match);
        }
        if (leftOverBaselineIssues.size() > 0) {
            this.matchIssues(leftOverBaselineIssues, currentNamedElementIssues);
        }
    }
}

