/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.IResolutionChangeProvider;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueMatcher;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DependencyIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import java.util.Set;

final class DependencyIssueMatcher
extends SimpleIssueMatcher<IDependencyIssue, DependencyIssue> {
    private final SimpleIssueDiffProcessor<IDependencyIssue, DependencyIssue> m_diffProcessor;

    DependencyIssueMatcher(SimpleIssueDiffProcessor<IDependencyIssue, DependencyIssue> diffProcessor, IResolutionChangeProvider<IDependencyIssue, DependencyIssue> resolutionChangeProvider) {
        super(resolutionChangeProvider);
        assert (diffProcessor != null) : "Parameter 'diffProcessor' of method 'DependencyIssueMatcher' must not be null";
        this.m_diffProcessor = diffProcessor;
    }

    @Override
    protected IssueDiff<IDependencyIssue, DependencyIssue> createDiff(NamedElement parent, IDependencyIssue baselineIssue, DependencyIssue currentIssue, IDiffElement.Change change, String changeDescription) {
        if (changeDescription == null) {
            return new DependencyIssueDiff(parent, baselineIssue, currentIssue, change);
        }
        return new DependencyIssueDiff(parent, baselineIssue, currentIssue, change, changeDescription);
    }

    @Override
    protected SimpleIssueMatcher.MatchResult<IDependencyIssue, DependencyIssue> findMatchingIssue(IDependencyIssue baselineIssue, Set<DependencyIssue> currentIssues) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'findExactMatchingIssue' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'findExactMatchingIssue' must not be null";
        if (currentIssues.isEmpty()) {
            return null;
        }
        for (DependencyIssue nextCurrent : currentIssues) {
            NamedElement currentToElement;
            String baselineToFqName;
            ISnapshotDependency.IDependencyEndpoint currentTo;
            if (!baselineIssue.getIssueProvider().getName().equals(nextCurrent.getProvider().getStandardName()) || !baselineIssue.getDescription().equals(nextCurrent.getDescription()) || !((currentTo = nextCurrent.getAffectedElement().getTo()) instanceof NamedElement) || !(baselineToFqName = this.m_diffProcessor.getBaselineOriginalFqName(baselineIssue.getTo())).equals(this.m_diffProcessor.getOrCreateFqNameFromCachedElement(currentToElement = (NamedElement)((Object)currentTo)))) continue;
            return new SimpleIssueMatcher.MatchResult<IDependencyIssue, DependencyIssue>(baselineIssue, nextCurrent, 1.0, IDiffElement.Change.UNMODIFIED, "");
        }
        return null;
    }
}

