/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractTaskResolutionDiffProcessor;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IRefactoring;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.StringJoiner;

public abstract class AbstractRefactoringDiffProcessor<B extends IRefactoring, C extends RefactoringDefinition>
extends AbstractTaskResolutionDiffProcessor<B, C> {
    public AbstractRefactoringDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem, ResolutionType resolutionType, Class<B> baselineResolutionClass, Class<C> currentResolutionClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem, resolutionType, baselineResolutionClass, currentResolutionClass);
    }

    @Override
    protected void addToChangeDescription(B baseline, C current, StringJoiner changeDescriptionParts) {
        super.addToChangeDescription(baseline, current, changeDescriptionParts);
        StatusInfo.Status baselineStatus = SystemDiffUtility.convertBaselineRefactoringStatus(baseline.getStatus());
        if (baselineStatus != ((RefactoringDefinition)current).getStatus()) {
            changeDescriptionParts.add("Status: " + baselineStatus.getPresentationName() + " -> " + ((RefactoringDefinition)current).getStatus().getPresentationName());
        }
        if (baseline.getNumberOfPotentiallyDoneElements() != ((RefactoringDefinition)current).getNumberOfPotentiallyDoneElements()) {
            changeDescriptionParts.add("Potentially done elements: " + baseline.getNumberOfPotentiallyDoneElements() + " -> " + ((RefactoringDefinition)current).getNumberOfPotentiallyDoneElements());
        }
        if (!baseline.getInformation().equals(((Resolution)current).getInformation())) {
            changeDescriptionParts.add("Information: " + baseline.getInformation() + " -> " + ((Resolution)current).getInformation());
        }
    }
}

