/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.lexer.Keyword;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureLexer;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

final class AutoCompletion {
    private static char[] SEPARATORS = new char[]{' ', '\n', '\r', '\t', '.', ',', ';', '/', ':', '+', '*', '{', '}', '(', ')', '\"'};
    private static final String SEPARATORS_AS_STRING = String.valueOf(SEPARATORS);
    private static final Set<String> KEYWORDS = new TreeSet<String>();
    private static final Set<String> KEYWORDS_WITH_FOLLOWING_DOT;

    static {
        Keyword[] keywordArray = ArchitectureLexer.kw_IDENT;
        int n = ArchitectureLexer.kw_IDENT.length;
        int n2 = 0;
        while (n2 < n) {
            Keyword next = keywordArray[n2];
            KEYWORDS.add(next.getKeyword());
            ++n2;
        }
        KEYWORDS.add("model");
        KEYWORDS.add("connect to");
        KEYWORDS.add("target.any");
        KEYWORDS_WITH_FOLLOWING_DOT = new THashSet();
        KEYWORDS_WITH_FOLLOWING_DOT.add("target");
        KEYWORDS_WITH_FOLLOWING_DOT.add("target.any");
    }

    private AutoCompletion() {
    }

    static Character isSeparator(char c) {
        char[] cArray = SEPARATORS;
        int n = SEPARATORS.length;
        int n2 = 0;
        while (n2 < n) {
            char next = cArray[n2];
            if (next == c) {
                return Character.valueOf(c);
            }
            ++n2;
        }
        return null;
    }

    static boolean isSeparator(String string) {
        assert (string != null) : "Parameter 'string' of method 'isSeparator' must not be null";
        return string.length() == 1 && AutoCompletion.isSeparator(string.charAt(0)) != null;
    }

    static String getSeparatorsAsString() {
        return SEPARATORS_AS_STRING;
    }

    static Set<String> getKeywords() {
        return Collections.unmodifiableSet(KEYWORDS);
    }

    static Set<String> getKeywordsWithFollowingDot() {
        return Collections.unmodifiableSet(KEYWORDS_WITH_FOLLOWING_DOT);
    }
}

