/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.BreakupMetricsAnalyzer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CycleMetricsComputer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.InternalTopLevelLogicalElementCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalProgrammingElementDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ComponentCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssueSourceFilesParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.LogicalToplevelElementCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.LogicalToplevelElementCyclesAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ResolutionNameComparator;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogicalToplevelElementCyclesAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.LOGICAL_TOPLEVEL_ELEMENT_CYCLES;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicalToplevelElementCyclesAnalyzerAdapter.class);
    private final IMetricDescriptor m_cyclicsModule;
    private final IMetricDescriptor m_ignoredCyclicsModule;
    private final IMetricDescriptor m_cyclesModule;
    private final IMetricDescriptor m_criticalCyclesModule;
    private final IMetricDescriptor m_biggestCycleModule;
    private final IMetricDescriptor m_cyclicityModule;
    private final IMetricDescriptor m_relativeCyclicityModule;
    private final IMetricDescriptor m_referencesToCutModule;
    private final IMetricDescriptor m_dependenciesToCutModule;
    private final IMetricDescriptor m_sdiModule;
    private final IMetricDescriptor m_cyclicsSystem;
    private final IMetricDescriptor m_ignoredCyclicsSystem;
    private final IMetricDescriptor m_cyclesSystem;
    private final IMetricDescriptor m_criticalCyclesSystem;
    private final IMetricDescriptor m_biggestCycleSystem;
    private final IMetricDescriptor m_cyclicitySystem;
    private final IMetricDescriptor m_relativeCyclicitySystem;
    private final IMetricDescriptor m_referencesToCutSystem;
    private final IMetricDescriptor m_dependenciesToCutSystem;
    private final IMetricDescriptor m_sdiSystem;

    public LogicalToplevelElementCyclesAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_cyclicsModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLIC_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.MODULE, null);
        this.m_ignoredCyclicsModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_CYCLIC_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.MODULE, null);
        this.m_cyclesModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUPS, CoreMetricLevel.MODULE, null);
        this.m_criticalCyclesModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUPS, CoreMetricLevel.MODULE, null);
        this.m_biggestCycleModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_BIGGEST_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP, CoreMetricLevel.MODULE, null);
        this.m_cyclicityModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.MODULE, null);
        this.m_relativeCyclicityModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.MODULE, null);
        this.m_referencesToCutModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PARSER_DEPENDENCIES_TO_REMOVE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.MODULE, null);
        this.m_dependenciesToCutModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENT_DEPENDENCIES_TO_REMOVE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.MODULE, null);
        this.m_sdiModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STRUCTURAL_DEBT_INDEX_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.MODULE, null);
        this.m_cyclicsSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLIC_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.SYSTEM, null);
        this.m_ignoredCyclicsSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_CYCLIC_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.SYSTEM, null);
        this.m_cyclesSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUPS, CoreMetricLevel.SYSTEM, null);
        this.m_criticalCyclesSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUPS, CoreMetricLevel.SYSTEM, null);
        this.m_biggestCycleSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_BIGGEST_LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP, CoreMetricLevel.SYSTEM, null);
        this.m_cyclicitySystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.SYSTEM, null);
        this.m_relativeCyclicitySystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIVE_CYCLICITY_LOGICAL_TOPLEVEL_ELEMENT, CoreMetricLevel.SYSTEM, null);
        this.m_referencesToCutSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PARSER_DEPENDENCIES_TO_REMOVE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.SYSTEM, null);
        this.m_dependenciesToCutSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENT_DEPENDENCIES_TO_REMOVE_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.SYSTEM, null);
        this.m_sdiSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STRUCTURAL_DEBT_INDEX_LOGICAL_TOPLEVEL_ELEMENTS, CoreMetricLevel.SYSTEM, null);
    }

    @Override
    protected boolean canRun() {
        LogicalToplevelElementCyclesAnalyzerConfiguration configuration = this.getAnalyzer().getConfiguration(LogicalToplevelElementCyclesAnalyzerConfiguration.class);
        assert (configuration != null) : "'configuration' of method 'runJobs' must not be null";
        if (configuration.isActive()) {
            boolean hasLogicalModel = false;
            for (Language nextLanguage : this.getSoftwareSystem().getUsedLanguages()) {
                if (!nextLanguage.hasLogicalModel()) continue;
                hasLogicalModel = true;
                break;
            }
            return hasLogicalModel;
        }
        return false;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        LogicalToplevelElementCyclesAnalyzerConfiguration configuration = this.getAnalyzer().getConfiguration(LogicalToplevelElementCyclesAnalyzerConfiguration.class);
        assert (configuration != null) : "'configuration' of method 'runJobs' must not be null";
        if (configuration.isActive()) {
            int criticalSizeModule = configuration.getCriticalSizeModule();
            int criticalSizeSystem = configuration.getCriticalCycleSizeSystem();
            AnalyzerResult requiredResultModule = this.getController().getResultFor(CoreAnalyzerId.COMPONENT_CYCLES_MODULE);
            assert (requiredResultModule != null) : "'requiredResultModule' of method 'runJobs' must not be null";
            AnalyzerResult requiredResultSystem = this.getController().getResultFor(CoreAnalyzerId.COMPONENT_CYCLES_SYSTEM);
            assert (requiredResultSystem != null) : "'requiredResultSystem' of method 'runJobs' must not be null";
            IMetricAccessor accessor = this.getController().getInstallation().getExtension(IMetricAccessor.class);
            LogicalToplevelElementCyclesJob job = new LogicalToplevelElementCyclesJob(this.getGroup(), result, this.getController(), Arrays.asList(requiredResultModule, requiredResultSystem), this, accessor, criticalSizeModule, criticalSizeSystem);
            job.start();
        }
    }

    final class LogicalToplevelElementCyclesJob
    extends AnalyzerJob {
        private final Map<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> m_systemCycleToNodeAdapters;
        private final Map<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> m_moduleCycleToNodeAdapters;
        private final Set<Set<ParserDependency>> m_moduleCyclesParserDependencies;
        private final IAnalyzerAdapter m_metricStore;
        private final IMetricAccessor m_metricAccessor;
        private final int m_criticialSizeModule;
        private final int m_criticialSizeSystem;

        LogicalToplevelElementCyclesJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults, IAnalyzerAdapter metricStore, IMetricAccessor metricAccessor, int criticialSizeModule, int criticialSizeSystem) {
            super(group, result, controller, requiredResults);
            this.m_systemCycleToNodeAdapters = new LinkedHashMap<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>>();
            this.m_moduleCycleToNodeAdapters = new LinkedHashMap<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>>();
            this.m_moduleCyclesParserDependencies = new THashSet();
            assert (requiredResults != null && requiredResults.size() == 2) : "Parameter 'requiredResults' of method 'LogicalToplevelElementCyclesJob' must contain 2 entries";
            assert (metricStore != null) : "Parameter 'metricStore' of method 'LogicalToplevelElementCyclesJob' must not be null";
            assert (metricAccessor != null) : "Parameter 'metricAccessor' of method 'LogicalToplevelElementCyclesJob' must not be null";
            assert (criticialSizeModule >= 0) : "'criticialSizeModule' must not be negative";
            assert (criticialSizeSystem >= 0) : "'criticialSizeSystem' must not be negative";
            this.m_metricStore = metricStore;
            this.m_metricAccessor = metricAccessor;
            this.m_criticialSizeModule = criticialSizeModule;
            this.m_criticialSizeSystem = criticialSizeSystem;
        }

        private void logNoSourceFileParent(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'logNoSourceFileParent' must not be null";
            LOGGER.error("No source file parent found for: " + String.valueOf(element));
            NamedElement current = element.getParent();
            while (current != null) {
                LOGGER.error("Parent: " + String.valueOf(current));
                current = current.getParent();
            }
        }

        private void computeSourceFileInfo(Map<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> cycleToNodeAdapter, AnalyzerResult result, IWorkerContext workerContext) {
            CycleGroupIssueSourceFilesParticipationInfo cycleToInvolvedSourceFiles;
            assert (cycleToNodeAdapter != null) : "Parameter 'cycleToNodeAdapter' of method 'computeSourceFileInfo' must not be null";
            assert (result != null) : "Parameter 'result' of method 'addSourceFileInfo' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'computeSourceFileInfo' must not be null";
            SourceFileIssueParticipationInfo<CycleGroupIssue> sourceFileParticipationInfo = result.getUniqueChild(SourceFileIssueParticipationInfo.class);
            if (sourceFileParticipationInfo == null) {
                sourceFileParticipationInfo = new SourceFileIssueParticipationInfo<CycleGroupIssue>(result);
                result.addChild(sourceFileParticipationInfo);
            }
            if ((cycleToInvolvedSourceFiles = result.getUniqueChild(CycleGroupIssueSourceFilesParticipationInfo.class)) == null) {
                cycleToInvolvedSourceFiles = new CycleGroupIssueSourceFilesParticipationInfo(result, CoreIssueId.LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP);
                result.addChild(cycleToInvolvedSourceFiles);
            }
            for (Map.Entry<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> nextEntry : cycleToNodeAdapter.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                AnalyzerCycleGroup nextCycleGroup = nextEntry.getKey();
                if (nextCycleGroup.isDuplicate()) continue;
                assert (nextCycleGroup != null && nextCycleGroup.getAssociatedIssue() instanceof CycleGroupIssue) : "Unexpected class in method 'computeSourceFileInfo': " + String.valueOf(nextCycleGroup.getAssociatedIssue());
                CycleGroupIssue issue = (CycleGroupIssue)nextCycleGroup.getAssociatedIssue();
                assert (issue.getId().equals(CoreIssueId.LOGICAL_TOPLEVEL_ELEMENT_CYCLE_GROUP)) : "Cycle issue id does not match";
                Set<NamedElement> nextCyclicNamedElements = nextCycleGroup.getCyclicNamedElements();
                THashSet sourceFiles = new THashSet();
                for (ParserDependencyNodeAdapter nextNodeAdapter : nextEntry.getValue()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextOut : nextNodeAdapter.getOutgoingEdges()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        for (ParserDependency nextOutParserDependency : nextOut.getDependencies()) {
                            if (workerContext.hasBeenCanceled()) {
                                return;
                            }
                            if (!nextCyclicNamedElements.contains(((ParserDependencyNodeAdapter)nextOut.getTo()).getUnderlyingObject())) continue;
                            ProgrammingElement nextFrom = nextOutParserDependency.getFrom();
                            SourceFile nextSourceFile = nextFrom.getParent(SourceFile.class, new Class[0]);
                            if (nextSourceFile != null) {
                                sourceFiles.add(nextSourceFile);
                                continue;
                            }
                            this.logNoSourceFileParent(nextFrom);
                        }
                    }
                }
                sourceFileParticipationInfo.add(issue, (Set<SourceFile>)sourceFiles);
                cycleToInvolvedSourceFiles.add(issue, (Set<SourceFile>)sourceFiles);
                nextCycleGroup.setInvolvedSourceFileInfo(sourceFiles.size(), sourceFiles.parallelStream().mapToInt(s -> s.getLinesOfCode()).filter(lines -> lines > 0).sum());
            }
            cycleToInvolvedSourceFiles.finishModification();
            sourceFileParticipationInfo.finishModification();
        }

        private Set<ParserDependency> getDependencies(Collection<ParserDependencyNodeAdapter> nodeAdapters) {
            assert (nodeAdapters != null && !nodeAdapters.isEmpty()) : "Parameter 'nodeAdapters' of method 'getDependencies' must not be empty";
            THashSet cycleParserDependencies = new THashSet();
            for (ParserDependencyNodeAdapter nextFromNodeAdapter : nodeAdapters) {
                for (ParserDependencyNodeAdapter nextToNodeAdapter : nodeAdapters) {
                    ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> nextOut;
                    if (nextFromNodeAdapter == nextToNodeAdapter || (nextOut = nextFromNodeAdapter.getOutgoingEdge(nextToNodeAdapter)) == null) continue;
                    cycleParserDependencies.addAll(nextOut.getDependencies());
                }
            }
            return cycleParserDependencies;
        }

        private AnalyzerCycleGroup isDuplicateOf(Set<ParserDependency> dependencies, Map<AnalyzerCycleGroup, Set<ParserDependency>> physicalDependencies) {
            assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'isDuplicateOf' must not be empty";
            if (physicalDependencies != null) {
                for (Map.Entry<AnalyzerCycleGroup, Set<ParserDependency>> nextEntry : physicalDependencies.entrySet()) {
                    Set<ParserDependency> nextCyclicParserDependencies = nextEntry.getValue();
                    if (!nextCyclicParserDependencies.equals(dependencies)) continue;
                    return nextEntry.getKey();
                }
            }
            return null;
        }

        private Map<Integer, Set<ParserDependencyNodeAdapter>> computeCycles(List<LogicalProgrammingElement> elements, LogicalProgrammingElementDependencyEndpointCollector endpointCollector, IWorkerContext workerContext) {
            assert (elements != null) : "Parameter 'elements' of method 'computeCycles' must not be null";
            assert (endpointCollector != null) : "Parameter 'endpointCollector' of method 'computeCycles' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'computeCycles' must not be null";
            ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(new SubWorkerContext(workerContext), elements, endpointCollector, CyclesAnalyzerAdapter.PE, CyclesAnalyzerAdapter.PD);
            CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
            CycleAnalyzer.compute(cycleAnalyzerAdapter, new SubWorkerContext(workerContext));
            LinkedHashMap<Integer, Set<ParserDependencyNodeAdapter>> indexToNodeAdapters = new LinkedHashMap<Integer, Set<ParserDependencyNodeAdapter>>();
            for (NodeAdapter nodeAdapter : cycleAnalyzerAdapter.getCyclicNodes()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyMap();
                }
                assert (nodeAdapter != null && nodeAdapter instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'processCycles': " + String.valueOf(nodeAdapter);
                Integer nextGroupIndex = cycleAnalyzerAdapter.getGroup(nodeAdapter);
                Set nextNodeAdapters = (Set)indexToNodeAdapters.get(nextGroupIndex);
                if (nextNodeAdapters == null) {
                    nextNodeAdapters = new THashSet();
                    indexToNodeAdapters.put(nextGroupIndex, nextNodeAdapters);
                }
                nextNodeAdapters.add((ParserDependencyNodeAdapter)nodeAdapter);
            }
            return indexToNodeAdapters;
        }

        private void calculateModuleCycles(SoftwareSystem softwareSystem, AnalyzerResult componentModuleCyclesResult, Map<ModuleBasedLogicalNamespaceRoot, List<AnalyzerCycleGroup>> moduleToCycles, AnalyzerResult result, IWorkerContext workerContext) {
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateModuleCycles' must not be null";
            assert (componentModuleCyclesResult != null) : "Parameter 'componentModuleCyclesResult' of method 'calculateModuleCycles' must not be null";
            assert (moduleToCycles != null) : "Parameter 'moduleToCycles' of method 'calculateModuleCycles' must not be null";
            assert (result != null) : "Parameter 'result' of method 'calculateModuleCycles' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateModuleCycles' must not be null";
            List<ModuleBasedLogicalNamespaceRoot> logicalModules = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(ModuleBasedLogicalNamespaceRoot.class);
            if (!logicalModules.isEmpty()) {
                THashMap componentCyclesModule = new THashMap();
                for (ComponentCycleGroup nextComponentCycleGroup : componentModuleCyclesResult.getChildren(ComponentCycleGroup.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    NamedElement nextScope = nextComponentCycleGroup.getScope();
                    assert (nextScope != null && nextScope instanceof Module) : "Unexpected class in method 'calculateModuleCycles': " + String.valueOf(nextScope);
                    ParserDependencyNodeAdapterSet nextNodeAdapterSet = new ParserDependencyNodeAdapterSet(new SubWorkerContext(workerContext), nextComponentCycleGroup.getCyclicNamedElements(), new DependencyEndpointCollector(), CyclesAnalyzerAdapter.PE, CyclesAnalyzerAdapter.PD);
                    Set<ParserDependency> cycleParserDependencies = this.getDependencies(nextNodeAdapterSet.getNodes());
                    Map nextCycleInfos = (Map)componentCyclesModule.get(nextScope);
                    if (nextCycleInfos == null) {
                        nextCycleInfos = new THashMap();
                        componentCyclesModule.put((Module)nextScope, nextCycleInfos);
                    }
                    nextCycleInfos.put(nextComponentCycleGroup, cycleParserDependencies);
                }
                LinkedHashMap<ModuleBasedLogicalNamespaceRoot, ArrayList<LogicalToplevelElementCycleGroup>> logicalModuleToCycles = new LinkedHashMap<ModuleBasedLogicalNamespaceRoot, ArrayList<LogicalToplevelElementCycleGroup>>();
                LogicalProgrammingElementDependencyEndpointCollector endpointCollector = new LogicalProgrammingElementDependencyEndpointCollector();
                for (ModuleBasedLogicalNamespaceRoot nextLogicalModule : logicalModules) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    moduleToCycles.put(nextLogicalModule, new ArrayList());
                    ArrayList<LogicalProgrammingElement> nextLogicalProgrammingElements = new ArrayList<LogicalProgrammingElement>();
                    InternalTopLevelLogicalElementCollector nextInternalCollector = new InternalTopLevelLogicalElementCollector(nextLogicalProgrammingElements, workerContext);
                    nextLogicalModule.accept(nextInternalCollector);
                    endpointCollector.addLogicalProgrammingElements(nextLogicalProgrammingElements);
                    Map<Integer, Set<ParserDependencyNodeAdapter>> indexToNodeAdapters = this.computeCycles(nextLogicalProgrammingElements, endpointCollector, workerContext);
                    for (Map.Entry<Integer, Set<ParserDependencyNodeAdapter>> nextEntry : indexToNodeAdapters.entrySet()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        Set<ParserDependencyNodeAdapter> nextCycleGroupNodeAdapters = nextEntry.getValue();
                        LogicalToplevelElementCycleGroup nextCreatedCycle = new LogicalToplevelElementCycleGroup(null, nextLogicalModule, this.m_criticialSizeModule <= nextCycleGroupNodeAdapters.size());
                        nextCycleGroupNodeAdapters.forEach(na -> nextCreatedCycle.addCyclicElement(na.getUnderlyingObject()));
                        Set<ParserDependency> nextCyclicParserDependencies = this.getDependencies(nextCycleGroupNodeAdapters);
                        AnalyzerCycleGroup nextDuplicateCycle = this.isDuplicateOf(nextCyclicParserDependencies, (Map)componentCyclesModule.get(nextLogicalModule.getPhysicalElement()));
                        if (nextDuplicateCycle != null) {
                            nextCreatedCycle.setDuplicateOf(nextDuplicateCycle);
                        }
                        this.m_moduleCycleToNodeAdapters.put(nextCreatedCycle, nextCycleGroupNodeAdapters);
                        this.m_moduleCyclesParserDependencies.add(nextCyclicParserDependencies);
                        ArrayList<LogicalToplevelElementCycleGroup> nextCycles = (ArrayList<LogicalToplevelElementCycleGroup>)logicalModuleToCycles.get(nextLogicalModule);
                        if (nextCycles == null) {
                            nextCycles = new ArrayList<LogicalToplevelElementCycleGroup>();
                            logicalModuleToCycles.put(nextLogicalModule, nextCycles);
                        }
                        nextCycles.add(nextCreatedCycle);
                    }
                    endpointCollector.reset();
                }
                int baseIndex = 1;
                for (Map.Entry nextEntry : logicalModuleToCycles.entrySet()) {
                    Collections.sort((List)nextEntry.getValue(), ResolutionNameComparator.INSTANCE);
                    int index = 1;
                    for (AnalyzerCycleGroup nextCycle : (List)nextEntry.getValue()) {
                        nextCycle.finish(Integer.toString(baseIndex) + "." + Integer.toString(index));
                        nextCycle.setParent(result);
                        result.addChild(nextCycle);
                        ++index;
                    }
                    ++baseIndex;
                }
            }
        }

        private void calculateSystemCycles(SoftwareSystem softwareSystem, AnalyzerResult componentSystemCyclesResult, AnalyzerResult result, IWorkerContext workerContext) {
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'calculateSystemCycles' must not be null";
            assert (componentSystemCyclesResult != null) : "Parameter 'componentSystemCyclesResult' of method 'calculateSystemCycles' must not be null";
            assert (result != null) : "Parameter 'result' of method 'calculateSystemCycles' must not be null";
            assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateSystemCycles' must not be null";
            THashMap componentCyclesSystem = new THashMap();
            List<ComponentCycleGroup> systemtComponentCycleGroups = componentSystemCyclesResult.getChildren(ComponentCycleGroup.class);
            for (ComponentCycleGroup nextComponentCycleGroup : systemtComponentCycleGroups) {
                NamedElement nextScope = nextComponentCycleGroup.getScope();
                assert (nextScope != null && nextScope instanceof SoftwareSystem) : "Unexpected class in method 'calculateSystemCycles': " + String.valueOf(nextScope);
                ParserDependencyNodeAdapterSet nextNodeAdapterSet = new ParserDependencyNodeAdapterSet(new SubWorkerContext(workerContext), nextComponentCycleGroup.getCyclicNamedElements(), new DependencyEndpointCollector(), CyclesAnalyzerAdapter.PE, CyclesAnalyzerAdapter.PD);
                componentCyclesSystem.put(nextComponentCycleGroup, this.getDependencies(nextNodeAdapterSet.getNodes()));
            }
            LogicalProgrammingElementDependencyEndpointCollector endpointCollector = new LogicalProgrammingElementDependencyEndpointCollector();
            ArrayList<LogicalProgrammingElement> logicalProgrammingElements = new ArrayList<LogicalProgrammingElement>();
            InternalTopLevelLogicalElementCollector systemCollector = new InternalTopLevelLogicalElementCollector(logicalProgrammingElements, workerContext);
            softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).accept(systemCollector);
            endpointCollector.addLogicalProgrammingElements(logicalProgrammingElements);
            ArrayList<LogicalToplevelElementCycleGroup> systemCycles = new ArrayList<LogicalToplevelElementCycleGroup>();
            for (Map.Entry<Integer, Set<ParserDependencyNodeAdapter>> nextEntry : this.computeCycles(logicalProgrammingElements, endpointCollector, workerContext).entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Set<ParserDependencyNodeAdapter> nextNodeAdapters = nextEntry.getValue();
                Set<ParserDependency> nextParserDependencies = this.getDependencies(nextNodeAdapters);
                if (this.m_moduleCyclesParserDependencies.contains(nextParserDependencies)) continue;
                LogicalToplevelElementCycleGroup nextCreatedCycle = new LogicalToplevelElementCycleGroup(null, softwareSystem, this.m_criticialSizeSystem <= nextNodeAdapters.size());
                nextNodeAdapters.forEach(na -> nextCreatedCycle.addCyclicElement(na.getUnderlyingObject()));
                AnalyzerCycleGroup nextDuplicateCycle = this.isDuplicateOf(nextParserDependencies, (Map<AnalyzerCycleGroup, Set<ParserDependency>>)componentCyclesSystem);
                if (nextDuplicateCycle != null) {
                    nextCreatedCycle.setDuplicateOf(nextDuplicateCycle);
                }
                this.m_systemCycleToNodeAdapters.put(nextCreatedCycle, nextNodeAdapters);
                systemCycles.add(nextCreatedCycle);
            }
            Collections.sort(systemCycles, ResolutionNameComparator.INSTANCE);
            int index = 1;
            for (AnalyzerCycleGroup analyzerCycleGroup : systemCycles) {
                analyzerCycleGroup.finish(Integer.toString(index));
                analyzerCycleGroup.setParent(result);
                result.addChild(analyzerCycleGroup);
                ++index;
            }
        }

        @Override
        protected void internalRun() {
            Set<ParserDependencyNodeAdapter> nextNodeAadpters;
            AnalyzerCycleGroup nextIsDuplicateOfCycle;
            AnalyzerCycleGroup nextCycle;
            LOGGER.debug("Analyze logical toplevel element cycles");
            final SoftwareSystem softwareSystem = this.getSoftwareSystem();
            final AnalyzerResult result = this.getResult();
            IWorkerContext workerContext = this.getWorkerContext();
            CycleMetricsComputer computer = new CycleMetricsComputer(softwareSystem.getCurrentModel(), workerContext);
            THashMap cycleToNodeAadpter = new THashMap();
            THashMap moduleScopeToCycles = new THashMap();
            final ArrayList<AnalyzerCycleGroup> allCycleGroups = new ArrayList<AnalyzerCycleGroup>();
            workerContext.setNumberOfSteps(5, new int[]{15, 15, 30, 30, 10});
            workerContext.beginSubTask("Detect module cycles");
            this.calculateModuleCycles(softwareSystem, this.getRequiredResults().get(0), (Map<ModuleBasedLogicalNamespaceRoot, List<AnalyzerCycleGroup>>)moduleScopeToCycles, result, workerContext);
            workerContext.endSubTask();
            workerContext.beginSubTask("Detect system cycles");
            this.calculateSystemCycles(softwareSystem, this.getRequiredResults().get(1), result, workerContext);
            workerContext.endSubTask();
            workerContext.beginSubTask("Process module cycles");
            for (Map.Entry<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> entry : this.m_moduleCycleToNodeAdapters.entrySet()) {
                nextCycle = entry.getKey();
                nextIsDuplicateOfCycle = nextCycle.getDuplicateOf();
                nextNodeAadpters = entry.getValue();
                cycleToNodeAadpter.put(nextCycle, nextNodeAadpters);
                NamedElement nextScope = nextCycle.getScope();
                assert (nextScope != null && nextScope instanceof ModuleBasedLogicalNamespaceRoot) : "Unexpected class in method 'internalRun': " + String.valueOf(nextScope);
                List nextCycles = (List)moduleScopeToCycles.get(nextScope);
                assert (nextCycles != null) : "Parameter 'nextCycles' of method 'internalRun' must not be null";
                nextCycles.add(nextCycle);
                allCycleGroups.add(nextCycle);
                if (nextIsDuplicateOfCycle == null) {
                    BreakupMetricsAnalyzer.analyze(nextCycle, nextNodeAadpters, workerContext);
                    CycleGroupIssue nextIssue = new CycleGroupIssue(nextCycle, nextCycle.createIssueDescription(), ID, nextCycle.getCycleGroupIssueId(), nextCycle.isCritical() ? Severity.ERROR : Severity.WARNING);
                    nextCycle.addIssue(nextIssue);
                    continue;
                }
                nextCycle.setDependenciesInfo(nextIsDuplicateOfCycle.getParserDependencies(), nextIsDuplicateOfCycle.getParserDependenciesToRemove(), nextIsDuplicateOfCycle.getComponentDependenciesToRemove(), nextIsDuplicateOfCycle.getStructuralDebtIndex());
                nextCycle.setInvolvedSourceFileInfo(nextIsDuplicateOfCycle.getNumberOfInvolvedSourceFiles(), nextIsDuplicateOfCycle.getLinesOfCodeOfInvolvedSourceFiles());
            }
            workerContext.endSubTask();
            workerContext.beginSubTask("Process system cycles");
            for (Map.Entry<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> entry : this.m_systemCycleToNodeAdapters.entrySet()) {
                nextCycle = entry.getKey();
                nextIsDuplicateOfCycle = nextCycle.getDuplicateOf();
                if (nextIsDuplicateOfCycle == null) {
                    nextNodeAadpters = entry.getValue();
                    BreakupMetricsAnalyzer.analyze(nextCycle, nextNodeAadpters, workerContext);
                    CycleGroupIssue nextIssue = new CycleGroupIssue(nextCycle, nextCycle.createIssueDescription(), ID, nextCycle.getCycleGroupIssueId(), nextCycle.isCritical() ? Severity.ERROR : Severity.WARNING);
                    nextCycle.addIssue(nextIssue);
                    cycleToNodeAadpter.put(nextCycle, nextNodeAadpters);
                } else {
                    nextCycle.setDependenciesInfo(nextIsDuplicateOfCycle.getParserDependencies(), nextIsDuplicateOfCycle.getParserDependenciesToRemove(), nextIsDuplicateOfCycle.getComponentDependenciesToRemove(), nextIsDuplicateOfCycle.getStructuralDebtIndex());
                    nextCycle.setInvolvedSourceFileInfo(nextIsDuplicateOfCycle.getNumberOfInvolvedSourceFiles(), nextIsDuplicateOfCycle.getLinesOfCodeOfInvolvedSourceFiles());
                }
                allCycleGroups.add(nextCycle);
            }
            workerContext.endSubTask();
            workerContext.beginSubTask("Process additional cycle metrics");
            for (final Map.Entry<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>> entry : moduleScopeToCycles.entrySet()) {
                final Module nextModule = ((ModuleBasedLogicalNamespaceRoot)((Object)entry.getKey())).getPhysicalElement();
                computer.compute(new CycleMetricsComputer.IAdapter(){

                    @Override
                    public List<AnalyzerCycleGroup> getCycleGroups() {
                        return (List)entry.getValue();
                    }

                    @Override
                    public int getNumberOfElements() {
                        Number noElements = LogicalToplevelElementCyclesJob.this.m_metricAccessor.getMetricValue(softwareSystem, nextModule, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENTS);
                        return noElements != null ? noElements.intValue() : 0;
                    }

                    @Override
                    public void storeMetricValue(Number value, IMetricDescriptor descriptor) {
                        LogicalToplevelElementCyclesJob.this.m_metricStore.storeMetricValue(result, nextModule, value, descriptor);
                    }

                    @Override
                    public IMetricDescriptor getNumberOfCyclicElementsMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclicsModule;
                    }

                    @Override
                    public IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_ignoredCyclicsModule;
                    }

                    @Override
                    public IMetricDescriptor getNumberOfCycleGroupsMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclesModule;
                    }

                    @Override
                    public IMetricDescriptor getNumberOfCriticalCycleGroupsMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_criticalCyclesModule;
                    }

                    @Override
                    public IMetricDescriptor getBiggestCycleGroupMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_biggestCycleModule;
                    }

                    @Override
                    public IMetricDescriptor getReferencesToCutMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_referencesToCutModule;
                    }

                    @Override
                    public IMetricDescriptor getComponentDependenciesToCutMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_dependenciesToCutModule;
                    }

                    @Override
                    public IMetricDescriptor getStructuralDebtIndexMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_sdiModule;
                    }

                    @Override
                    public IMetricDescriptor getCyclicityMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclicityModule;
                    }

                    @Override
                    public IMetricDescriptor getRelativeCyclicityMetric() {
                        return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_relativeCyclicityModule;
                    }
                });
            }
            computer.compute(new CycleMetricsComputer.IAdapter(){

                @Override
                public List<AnalyzerCycleGroup> getCycleGroups() {
                    return allCycleGroups;
                }

                @Override
                public int getNumberOfElements() {
                    Number noElements = LogicalToplevelElementCyclesJob.this.m_metricAccessor.getMetricValue(softwareSystem, softwareSystem, CoreMetricId.CORE_LOGICAL_TOPLEVEL_ELEMENTS);
                    return noElements != null ? noElements.intValue() : 0;
                }

                @Override
                public void storeMetricValue(Number value, IMetricDescriptor descriptor) {
                    LogicalToplevelElementCyclesJob.this.m_metricStore.storeMetricValue(result, softwareSystem, value, descriptor);
                }

                @Override
                public IMetricDescriptor getNumberOfCyclicElementsMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclicsSystem;
                }

                @Override
                public IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_ignoredCyclicsSystem;
                }

                @Override
                public IMetricDescriptor getNumberOfCycleGroupsMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclesSystem;
                }

                @Override
                public IMetricDescriptor getNumberOfCriticalCycleGroupsMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_criticalCyclesSystem;
                }

                @Override
                public IMetricDescriptor getBiggestCycleGroupMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_biggestCycleSystem;
                }

                @Override
                public IMetricDescriptor getReferencesToCutMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_referencesToCutSystem;
                }

                @Override
                public IMetricDescriptor getComponentDependenciesToCutMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_dependenciesToCutSystem;
                }

                @Override
                public IMetricDescriptor getStructuralDebtIndexMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_sdiSystem;
                }

                @Override
                public IMetricDescriptor getCyclicityMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_cyclicitySystem;
                }

                @Override
                public IMetricDescriptor getRelativeCyclicityMetric() {
                    return ((LogicalToplevelElementCyclesJob)LogicalToplevelElementCyclesJob.this).LogicalToplevelElementCyclesAnalyzerAdapter.this.m_relativeCyclicitySystem;
                }
            });
            this.computeSourceFileInfo((Map<AnalyzerCycleGroup, Set<ParserDependencyNodeAdapter>>)cycleToNodeAadpter, result, workerContext);
            workerContext.endSubTask();
            LOGGER.debug("Analyze logical toplevel element cycles - done");
        }
    }

    static final class SubWorkerContext
    implements IWorkerContext {
        private final IWorkerContext m_workerContext;

        SubWorkerContext(IWorkerContext workerContext) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'SubWorkerContext' must not be null";
            this.m_workerContext = workerContext;
        }

        public boolean hasBeenCanceled() {
            return this.m_workerContext.hasBeenCanceled();
        }
    }
}

