/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WriteExecutor;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.excel.ExcelExportMessageCause;
import com.hello2morrow.sonargraph.foundation.excel.ExcelExporter;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

final class WriteExcelExportExecutor
extends WriteExecutor {
    private OperationResultWithOutcome<TFile> m_result;
    private IListener m_listener;

    WriteExcelExportExecutor() {
    }

    final void run(final TFile file, final List<ExportData> exportData, IListener listener) {
        assert (exportData != null) : "Parameter 'exportData' of method 'run' must not be null";
        assert (file != null) : "Parameter 'file' of method 'run' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'run' must not be null";
        this.m_result = new OperationResultWithOutcome("Write Excel file");
        this.m_listener = listener;
        this.execute(new CancellableWorkerContext(), "Excel Export", new Runnable(){

            @Override
            public void run() {
                ExcelExporter.getInstance().exportToFile(file, exportData, WriteExcelExportExecutor.this.m_result);
                if (WriteExcelExportExecutor.this.m_result.isSuccess()) {
                    WriteExcelExportExecutor.this.m_result.addInfo((OperationResult.IMessageCause)ExcelExportMessageCause.DATA_EXPORTED_TO_EXCEL_FILE, "File: " + FileUtility.getIdentifyingPath((TFile)file));
                    WriteExcelExportExecutor.this.m_result.setOutcome((Object)file);
                }
            }
        });
    }

    @Override
    protected void executionFinished() {
        assert (this.m_result != null) : "Parameter 'm_result' of method 'executionFinished' must not be null";
        assert (this.m_listener != null) : "Parameter 'm_listener' of method 'executionFinished' must not be null";
        this.m_listener.executorFinished(this.m_result);
        this.m_result = null;
        this.m_listener = null;
    }

    @Override
    protected void handleException(String context, Throwable throwable) {
        assert (this.m_result != null) : "Parameter 'm_result' of method 'handleException' must not be null";
        this.m_result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, throwable);
    }

    public static interface IListener {
        public void executorFinished(OperationResultWithOutcome<TFile> var1);
    }
}

