/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IScmExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.scm.BranchCommits;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmExtension
extends Extension
implements IScmExtension,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmExtension.class);
    private static final String ZIP = ".zip";
    private final Map<String, Properties> m_configurationProperties = new THashMap();
    private final LanguageProviderAccessor m_accessor;
    private final SoftwareSystem m_softwareSystem;
    private File m_scmDataDir;
    private BranchCommits m_commitData;
    private Map<String, Object> m_properties;

    public ScmExtension(LanguageProviderAccessor accessor, SoftwareSystem softwareSystem, IFinishModelProcessor fmp) {
        assert (accessor != null) : "Parameter 'accessor' of method 'ScmExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ScmExtension' must not be null";
        assert (fmp != null) : "Parameter 'fmp' of method 'ScmExtension' must not be null";
        this.m_accessor = accessor;
        this.m_softwareSystem = softwareSystem;
        this.init();
        fmp.addListener(this);
        this.deleteFilesOlderThan(System.currentTimeMillis() - 7776000000L);
    }

    private void init() {
        this.m_properties = new THashMap();
        this.m_scmDataDir = new File((File)this.m_softwareSystem.getHiddenDataDirectory(), "scmdata");
        this.m_scmDataDir.mkdirs();
        this.m_commitData = null;
    }

    private void deleteFilesOlderThan(long t) {
        File[] files = this.m_scmDataDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.deleteFilesOlderThan(f, t);
                }
                ++n2;
            }
        }
    }

    private void deleteFilesOlderThan(File dir, long t) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.deleteFilesOlderThan(f, t);
                } else if (f.isFile() && f.lastModified() < t) {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    @Override
    public void savedAs(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, EnumSet<Modification> modifications, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        if (baseDirectoryChanged) {
            this.init();
            this.deleteFilesOlderThan(System.currentTimeMillis());
        }
    }

    public Properties getConfigurationProperties(String scmName) {
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'getConfigurationProperties' must not be empty";
        Properties props = this.m_configurationProperties.get(scmName);
        if (props == null) {
            props = new Properties();
            this.m_configurationProperties.put(scmName, props);
            File file = new File(this.getConfigurationDirectory(), scmName + ".properties");
            if (file.isFile() && file.canRead()) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedReader input = new BufferedReader(new FileReader(file));){
                        props.load(input);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected error while reading from: " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return props;
    }

    public void storeProperty(String key, Object value) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'storeProperty' must not be empty";
        if (value == null) {
            this.m_properties.remove(key);
        } else {
            this.m_properties.put(key, value);
        }
    }

    public <T> T retrieveProperty(String key, Class<T> cls) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'retrieveProperty' must not be empty";
        assert (cls != null) : "Parameter 'cls' of method 'retrieveProperty' must not be null";
        Object value = this.m_properties.get(key);
        return (T)value;
    }

    public BranchCommits readData(String scmName, String branch) {
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'readData' must not be empty";
        assert (branch != null && branch.length() > 0) : "Parameter 'branch' of method 'readData' must not be empty";
        if (this.m_commitData != null && this.m_commitData.getScmName().equals(scmName) && this.m_commitData.getBranchName().equals(branch)) {
            return this.m_commitData;
        }
        File scmSpecificDir = new File(this.m_scmDataDir, scmName);
        scmSpecificDir.mkdirs();
        TFile dataFile = new TFile(scmSpecificDir, branch.replace('/', '_') + ZIP);
        BranchCommits result = null;
        if (dataFile.canRead()) {
            ObjectReader reader = new ObjectReader(this.getClass().getClassLoader());
            try {
                this.m_commitData = result = (BranchCommits)reader.retrieve(dataFile, BranchCommits.class);
            }
            catch (IOException e) {
                LOGGER.error("Problem while reading: " + dataFile.getAbsolutePath(), (Throwable)e);
            }
            catch (RestoreException e) {
                try {
                    LOGGER.warn("Unable to restore: " + dataFile.getAbsolutePath(), (Throwable)e);
                    dataFile.rm_r();
                    LOGGER.info("Removed: " + dataFile.getAbsolutePath());
                }
                catch (IOException ioException) {
                    LOGGER.error("Unable to remove: " + dataFile.getAbsolutePath(), (Throwable)ioException);
                }
            }
        }
        if (result == null) {
            result = new BranchCommits(scmName, branch);
            if (this.m_commitData != null) {
                BranchCommits commits = result;
                this.m_commitData.getCommits().forEach(c -> commits.addCommit(c));
            }
        }
        return result;
    }

    public void storeData(BranchCommits bc) {
        assert (bc != null) : "Parameter 'bc' of method 'storeData' must not be null";
        this.m_commitData = bc;
        File scmSpecificDir = new File(this.m_scmDataDir, bc.getScmName());
        scmSpecificDir.mkdirs();
        TFile dataFile = new TFile(scmSpecificDir, bc.getBranchName().replace('/', '_') + ZIP);
        ObjectWriter writer = new ObjectWriter();
        try {
            writer.store(dataFile, (IPersistable)bc);
        }
        catch (IOException e) {
            LOGGER.error("Problem while writing: " + dataFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public TFile getBaseDirectory() {
        return this.m_softwareSystem.getDirectoryFile();
    }

    private File getConfigurationDirectory() {
        File result = new File((File)this.m_softwareSystem.getSystemDirectoryFile(), "Settings");
        result.mkdir();
        return result;
    }

    public String[] getFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Language lang : this.m_softwareSystem.getUsedLanguages()) {
            LanguageProvider lp = this.m_accessor.getLanguageProvider(lang);
            extensions.addAll(lp.getSourceExtensions());
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    public List<TFile> getSourceRootDirectories() {
        ArrayList<TFile> result = new ArrayList<TFile>();
        RootVisitor visitor = new RootVisitor(result);
        this.m_softwareSystem.getUniqueExistingChild(Workspace.class).accept(visitor);
        return result;
    }

    private static class RootVisitor
    extends NamedElementVisitor
    implements External.IVisitor,
    RootDirectoryPath.IVisitor {
        private final List<TFile> m_result;

        private RootVisitor(List<TFile> result) {
            this.m_result = result;
        }

        @Override
        public void visitRootDirectoryPath(RootDirectoryPath element) {
            if (element.mayContainSourceFiles()) {
                this.m_result.add(element.getDirectoryFile());
            }
        }

        @Override
        public void visitExternal(External element) {
        }
    }
}

