/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IPluginConfigurationFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginUpdateInfo;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IPluginConfigurationExtension;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.SoftwareSystemDefinitionFileReadError;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.plugin.PluginNotInstalledIssue;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.PluginMessageCause;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.settings.PluginConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginConfigurationExtension
extends Extension
implements IModifiableFileProvider,
IModifiableFileDeltaKey,
IQualityModelProvider,
IPluginConfigurationExtension,
IPluginConfigurationFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginConfigurationExtension.class);
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;
    private final IConfigurationChangeHandler m_configurationChangeHandler;
    private final PluginConfigurationPersistence m_persistence;

    PluginConfigurationExtension(Version version, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, IConfigurationChangeHandler handler) {
        assert (version != null) : "Parameter 'version' of method 'PluginConfigurationExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'PluginConfigurationExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'PluginConfigurationExtension' must not be null";
        assert (handler != null) : "Parameter 'handler' of method 'PluginConfigurationExtension' must not be null";
        this.m_persistence = new PluginConfigurationPersistence(version);
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_configurationChangeHandler = handler;
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        PluginConfigurations pluginConfigurations = this.getPluginConfigurationDirectory();
        Files files = this.m_softwareSystem.getUniqueExistingChild(Files.class);
        for (SonargraphPlugin nextPlugin : this.m_configurationChangeHandler.getPlugins()) {
            String nextPluginId = nextPlugin.getId();
            PluginConfigurationFile pluginConfiguration = new PluginConfigurationFile(pluginConfigurations, new TFile((File)pluginConfigurations.getFile(), PluginConfigurationFile.getFileName(nextPluginId)), files, nextPluginId, nextPlugin.getConfiguration());
            pluginConfigurations.addChild(pluginConfiguration);
        }
    }

    @Override
    public PluginConfigurationFile getPluginConfigurationFile(String pluginId) {
        assert (pluginId != null) : "Parameter 'pluginId' of method 'getPluginConfigurationFile' must not be null";
        PluginConfigurations pluginConfigurationDirectory = this.getPluginConfigurationDirectory();
        PluginConfigurationFile pluginConfiguration = pluginConfigurationDirectory.getUniqueChild(new PluginIdFilter(pluginId), PluginConfigurationFile.class);
        return pluginConfiguration;
    }

    @Override
    public OperationResult configurePlugin(IWorkerContext workerContext, SonargraphPlugin plugin, Map<SonargraphPluginAttribute, Object> values) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurePlugin' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'configurePlugin' must not be null";
        assert (values != null) : "Parameter 'values' of method 'configurePlugin' must not be null";
        String pluginId = plugin.getId();
        OperationResult result = new OperationResult("Configure plugin '" + pluginId + "'");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        PluginConfigurationFile pluginConfigurationFile = this.getPluginConfigurationFile(pluginId);
        assert (pluginConfigurationFile != null) : "'pluginConfigurationFile' of method 'configurePlugin' must not be null";
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "plugin configuration must not be null";
        LOGGER.debug("Configure plugin '" + pluginId + "'");
        ConfigurationChangedInfo info = new ConfigurationChangedInfo(true);
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        this.updateConfiguration(pluginId, pluginConfigurationFile.getPluginConfiguration(), values, modifications, info);
        if (result.isSuccess()) {
            pluginConfigurationFile.setNeedsSave(true);
        }
        this.m_configurationChangeHandler.configurationChangeFinished(workerContext, this.m_softwareSystem, modifications, info, result);
        LOGGER.debug("Configure plugin '" + pluginId + "' - done");
        return result;
    }

    private PluginUpdateInfo updateConfiguration(String pluginId, SonargraphPluginConfiguration configuration, Map<SonargraphPluginAttribute, Object> values) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'updateConfiguration' must not be empty";
        assert (values != null) : "Parameter 'values' of method 'updateConfiguration' must not be null";
        LOGGER.debug("Update configuration for plugin '" + pluginId + "'");
        boolean isEnabled = SonargraphPluginConfiguration.isEnabled((SonargraphPluginConfiguration)configuration, values);
        PluginConfigurationFile pluginConfigurationFile = this.getPluginConfigurationFile(pluginId);
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'updateConfiguration' must not be null";
        boolean wasEnabled = pluginConfigurationFile.getPluginConfiguration().isEnabled();
        if (!values.equals(pluginConfigurationFile.getPluginConfiguration().getValues())) {
            PluginUpdateInfo updateInfo = new PluginUpdateInfo(wasEnabled ^ isEnabled, isEnabled);
            SonargraphPlugin plugin = this.m_configurationChangeHandler.getPluginById(pluginId);
            if (plugin != null) {
                plugin.getConfiguration().updateValues(values);
            }
            return updateInfo;
        }
        return null;
    }

    private void updateConfiguration(String pluginId, SonargraphPluginConfiguration configuration, Map<SonargraphPluginAttribute, Object> values, EnumSet<Modification> modifications, ConfigurationChangedInfo info) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'updateConfiguration' must not be empty";
        assert (values != null) : "Parameter 'values' of method 'updateConfiguration' must not be null";
        assert (info != null) : "Parameter 'info' of method 'updateConfiguration' must not be null";
        LOGGER.debug("Update configuration for plugin '" + pluginId + "'");
        PluginUpdateInfo updateInfo = this.updateConfiguration(pluginId, configuration, values);
        if (updateInfo != null && modifications != null) {
            this.m_configurationChangeHandler.configurationChanged(this.m_softwareSystem, pluginId, modifications, info, updateInfo.hasEnabledStateChanged(), updateInfo.isEnabled());
        }
        LOGGER.debug("Update configuration for plugin '" + pluginId + "' - done");
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        this.getPluginConfigurationDirectory().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return PluginConfigurationExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!($assertionsDisabled || modifiableFile != null && modifiableFile instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'exists': " + String.valueOf(modifiableFile)));
                }
                return !onSystemOpen ? modifiableFile.existsOnDisk() : false;
            }

            @Override
            public boolean accept(TFile file) {
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                return PluginConfigurationExtension.this.m_finishModelProcessor.getLicenseProvider().isFeatureAvailable(SonargraphFeature.PLUGINS);
            }

            @Override
            public boolean recursive() {
                return false;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return PluginConfigurationExtension.this.getPluginConfigurationDirectory();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.PLUGIN_CONFIGURATION);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return PluginConfigurationFile.class.getSimpleName();
            }
        });
        if (!onSystemOpen) {
            deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return PluginConfigurationExtension.this;
                }
            }, false);
        }
    }

    @Override
    public void refreshFiles(final IWorkerContext workerContext, ModifiableFileDelta delta, final EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        final ConfigurationChangedInfo info = new ConfigurationChangedInfo(false);
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return PluginConfigurationExtension.this;
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                LOGGER.debug("Added file: {}", (Object)added.getIdentifyingPath());
                PluginConfigurationExtension.this.configurationFileAdded(workerContext, added, modifications, info, result);
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                LOGGER.debug("Modified file: {}", (Object)modified.getIdentifyingPath());
                PluginConfigurationExtension.this.configurationFileModified(workerContext, (PluginConfigurationFile)modified, modifications, info, result);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof PluginConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                LOGGER.debug("Deleted plugin configuration file '" + deleted.getIdentifyingPath() + "'");
                PluginConfigurationFile pluginConfigurationFile = (PluginConfigurationFile)deleted;
                pluginConfigurationFile.removeIssues();
                SonargraphPlugin plugin = PluginConfigurationExtension.this.m_configurationChangeHandler.getPluginById(pluginConfigurationFile.getPluginId());
                if (plugin != null) {
                    PluginConfigurationExtension.this.m_configurationChangeHandler.pluginConfigurationDeleted(workerContext, PluginConfigurationExtension.this.m_softwareSystem, plugin, modifications, info);
                    pluginConfigurationFile.setExistsOnDisk(false);
                }
                LOGGER.debug("Deleted plugin configuration file '" + deleted.getIdentifyingPath() + "' - done");
            }
        }, true);
        if (modifications != null) {
            this.m_configurationChangeHandler.configurationChangeFinished(workerContext, this.m_softwareSystem, modifications, info, result);
        }
    }

    private PluginConfigurations getPluginConfigurationDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getPluginConfigurationDirectory();
    }

    public OperationResult save(PluginConfigurationFile pluginConfigurationFile) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfiguration' of method 'save' must not be null";
        assert (pluginConfigurationFile.needsSave()) : "Does not need save: " + pluginConfigurationFile.getName();
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "'plugin configuration' of method 'save' must not be null";
        OperationResult saveResult = this.m_persistence.save(pluginConfigurationFile.getFile(), pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration().getAttributes());
        if (saveResult.isSuccess()) {
            pluginConfigurationFile.setNeedsSave(false);
            pluginConfigurationFile.reSync();
        }
        return saveResult;
    }

    void setupPlugin(SonargraphPlugin plugin, OperationResult result) {
        assert (plugin != null) : "Parameter 'plugin' of method 'setupPlugin' must not be null";
        assert (result != null) : "Parameter 'result' of method 'setupPlugin' must not be null";
        String pluginId = plugin.getId();
        LOGGER.debug("Setup plugin '" + pluginId + "'");
        PluginConfigurationFile pluginConfiguration = this.getPluginConfigurationFile(pluginId);
        if (pluginConfiguration == null) {
            PluginConfigurations directory = this.getPluginConfigurationDirectory();
            Files files = this.m_softwareSystem.getUniqueExistingChild(Files.class);
            pluginConfiguration = new PluginConfigurationFile(directory, new TFile((File)directory.getFile(), PluginConfigurationFile.getFileName(pluginId)), files, pluginId, plugin.getConfiguration());
            directory.addChild(pluginConfiguration);
        }
        pluginConfiguration.reSync();
        if (pluginConfiguration.existsOnDisk()) {
            pluginConfiguration.removeIssues(CoreIssueId.PLUGIN_NOT_INSTALLED);
            this.updateConfiguration(pluginId, pluginConfiguration.getPluginConfiguration(), pluginConfiguration.getPluginConfiguration().getValues());
        }
        LOGGER.debug("Setup plugin '" + plugin.getId() + "' - done");
    }

    public List<IModifiableFile> getAvailableFiles() {
        return this.getPluginConfigurationDirectory().getChildren(PluginConfigurationFile.class).stream().filter(ModifiableFile::existsOnDisk).collect(Collectors.toList());
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.PLUGIN_CONFIGURATION.equals(modifiableFile.getFileType());
    }

    @Override
    public String getExportBaseDirectory() {
        return "Plugins";
    }

    private void copy(TFile file, TFile targetDirectory, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'copy' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'copy' must not be null";
        assert (result != null) : "Parameter 'result' of method 'copy' must not be null";
        try {
            file.cp_p((File)new TFile((File)targetDirectory, file.getName()));
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void exportFile(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof PluginConfigurationFile) : "Unexpected class in method 'exportFile': " + String.valueOf(modifiableFile);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        this.copy(modifiableFile.getFile(), targetFile.getParentFile(), result);
    }

    @Override
    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        PluginConfigurations pluginConfigurationDirectory = this.getPluginConfigurationDirectory();
        pluginConfigurationDirectory.enforceExistence(result);
        if (result.isSuccess() && this.getPluginConfigurationDirectory().isOutOfSync(new String[][]{CoreFileType.PLUGIN_CONFIGURATION.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importFiles' must not be null";
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        ConfigurationChangedInfo info = new ConfigurationChangedInfo(false);
        PluginConfigurations pluginConfigurationDirectory = this.getPluginConfigurationDirectory();
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.PLUGIN_CONFIGURATION);
        for (ImportQualityModel.ImportQualityModelCandidate candidate : candidates) {
            if (!candidate.isIncluded()) continue;
            TFile candidateFile = candidate.getModifiableFile().getFile();
            this.copy(candidateFile, pluginConfigurationDirectory.getFile(), result);
            if (candidate.isAlreadyInModel()) {
                String pluginId = FileUtility.getFileNameWithoutExtension((TFile)candidateFile);
                PluginConfigurationFile existing = this.getPluginConfigurationFile(pluginId);
                assert (existing != null) : "'existing' of method 'importFiles' must not be null";
                this.configurationFileModified(workerContext, existing, modifications, info, result);
                continue;
            }
            this.configurationFileAdded(workerContext, candidate.getModifiableFile(), modifications, info, result);
        }
        if (modifications != null) {
            this.m_configurationChangeHandler.configurationChangeFinished(workerContext, this.m_softwareSystem, modifications, info, result);
        }
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        PluginConfigurations pluginConfigurations = this.getPluginConfigurationDirectory();
        for (PluginConfigurationFile next : pluginConfigurations.getChildren(PluginConfigurationFile.class)) {
            TFile nextFile = next.getFile();
            if (!nextFile.exists()) continue;
            try {
                nextFile.rm();
                next.setExistsOnDisk(false);
                next.setNeedsSave(false);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
            }
        }
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        PluginConfigurations pluginConfigurations = this.getPluginConfigurationDirectory();
        pluginConfigurations.setPath(new TFile((File)qualityModel, "./Plugins"));
    }

    public boolean isEnabledOnDisk(String pluginId) {
        assert (pluginId != null && !pluginId.isEmpty()) : "Parameter 'pluginId' of method 'isEnabledOnDisk' must not be empty";
        PluginConfigurationFile pluginConfigurationFile = this.getPluginConfigurationFile(pluginId);
        assert (pluginConfigurationFile != null) : "'pluginConfigurationFile' of method 'isEnabledOnDisk' must not be null";
        if (pluginConfigurationFile.existsOnDisk()) {
            OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.m_persistence.load(pluginConfigurationFile.getFile(), pluginConfigurationFile.getIdentifyingPath(), pluginConfigurationFile.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfigurationFile.getPluginConfiguration().getAttributes());
            if (loadResult.isSuccess()) {
                Object enabledAttribute = ((Map)loadResult.getOutcome()).get(pluginConfigurationFile.getPluginConfiguration().getEnabledAttribute());
                assert (enabledAttribute != null && enabledAttribute instanceof Boolean) : "Unexpected class in method 'isEnabledOnDisk': " + String.valueOf(enabledAttribute);
                return (Boolean)enabledAttribute;
            }
        } else {
            LOGGER.debug("Plugin configuration file not on disk of plugin: " + pluginId);
        }
        return false;
    }

    private void configurationFileAdded(IWorkerContext workerContext, IModifiableFile added, EnumSet<Modification> modfications, ConfigurationChangedInfo info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationFileAdded' must not be null";
        assert (added != null) : "Parameter 'added' of method 'configurationFileAdded' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationFileAdded' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationFileAdded' must not be null";
        TFile file = added.getFile();
        String fileName = file.getName();
        String pluginId = FileUtility.getFileNameWithoutExtension((TFile)file);
        SonargraphPlugin plugin = this.m_configurationChangeHandler.getPluginById(pluginId);
        PluginConfigurationFile pluginConfiguration = this.getPluginConfigurationFile(pluginId);
        if (pluginConfiguration == null) {
            PluginConfigurations parent = this.getPluginConfigurationDirectory();
            pluginConfiguration = new PluginConfigurationFile(parent, new TFile((File)parent.getFile(), fileName), this.m_softwareSystem.getUniqueExistingChild(Files.class), pluginId, plugin != null ? plugin.getConfiguration() : null);
            parent.addChild(pluginConfiguration);
        }
        if (plugin == null) {
            result.addWarning((OperationResult.IMessageCause)PluginMessageCause.PLUGIN_NOT_INSTALLED, "Plugin '" + pluginId + "' is not installed.", new Object[0]);
            pluginConfiguration.addIssue(new PluginNotInstalledIssue(pluginConfiguration, "Plugin '" + pluginId + "' is not installed."));
        } else {
            OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.m_persistence.load(file, pluginConfiguration.getIdentifyingPath(), pluginConfiguration.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfiguration.getPluginConfiguration().getAttributes());
            result.addMessagesFrom(loadResult);
            if (loadResult.isFailure()) {
                pluginConfiguration.addIssue(new SoftwareSystemDefinitionFileReadError(pluginConfiguration, loadResult.toString()));
            } else {
                this.updateConfiguration(pluginId, pluginConfiguration.getPluginConfiguration(), (Map)loadResult.getOutcome(), modfications, info);
                pluginConfiguration.reSync();
            }
        }
    }

    private void configurationFileModified(IWorkerContext workerContext, PluginConfigurationFile pluginConfigurationFile, EnumSet<Modification> modfications, ConfigurationChangedInfo info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationFileModified' must not be null";
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'configurationFileModified' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationFileModified' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationFileModified' must not be null";
        SonargraphPluginConfiguration pluginConfiguration = pluginConfigurationFile.getPluginConfiguration();
        if (pluginConfiguration != null) {
            pluginConfigurationFile.removeIssues();
            OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.m_persistence.load(pluginConfigurationFile.getFile(), pluginConfigurationFile.getIdentifyingPath(), pluginConfigurationFile.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfiguration.getAttributes());
            result.addMessagesFrom(loadResult);
            if (loadResult.isFailure()) {
                pluginConfigurationFile.addIssue(new SoftwareSystemDefinitionFileReadError(pluginConfigurationFile, loadResult.toString()));
            } else {
                pluginConfigurationFile.reloaded(pluginConfigurationFile.getFile().lastModified(), false);
                this.updateConfiguration(pluginConfigurationFile.getPluginId(), pluginConfiguration, (Map)loadResult.getOutcome(), modfications, info);
                pluginConfigurationFile.reSync();
            }
        }
    }

    @Override
    public PluginConfigurationFile findByIdentifyingPath(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'findByIdentifyingPath' must not be empty";
        for (PluginConfigurationFile next : this.getPluginConfigurationDirectory().getChildrenRecursively(PluginConfigurationFile.class, new Class[0])) {
            if (!next.getIdentifyingPath().equals(identifyingPath)) continue;
            return next;
        }
        return null;
    }

    @Override
    public void save(PluginConfigurationFile pluginConfigurationFile, OutputStream outputStream, OperationResult result) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        SonargraphPluginConfiguration pluginConfiguration = pluginConfigurationFile.getPluginConfiguration();
        if (pluginConfiguration != null) {
            this.m_persistence.save(pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration().getAttributes(), outputStream, result);
        }
    }

    @Override
    public void restoreFile(PluginConfigurationFile pluginConfigurationFile, InputStream inputStream, EnumSet<Modification> determinedModifications, OperationResultWithOutcome<PluginConfigurationFile> result) {
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfiguration' of method 'restoreFile' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreFile' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'restoreFile' must not be null";
        assert (pluginConfigurationFile.getPluginConfiguration() != null) : "'plugin configuration' of method 'restoreFile' must not be null";
        OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> loadResult = this.m_persistence.load(inputStream, pluginConfigurationFile.getIdentifyingPath(), pluginConfigurationFile.getPluginId(), (Map<String, SonargraphPluginAttribute>)pluginConfigurationFile.getPluginConfiguration().getAttributes());
        result.addMessagesFrom(loadResult);
        if (!result.isFailure()) {
            ConfigurationChangedInfo info = new ConfigurationChangedInfo(false);
            this.updateConfiguration(pluginConfigurationFile.getPluginId(), pluginConfigurationFile.getPluginConfiguration(), (Map)loadResult.getOutcome(), determinedModifications, info);
            this.m_configurationChangeHandler.configurationChangeFinished((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_softwareSystem, determinedModifications, info, (OperationResult)result);
            result.setOutcome((Object)pluginConfigurationFile);
        }
    }

    static final class AnalyzerRestartInfo {
        private final Set<IAnalyzerId> m_restart;

        AnalyzerRestartInfo() {
            this.m_restart = null;
        }

        AnalyzerRestartInfo(Set<IAnalyzerId> restart) {
            assert (restart != null) : "Parameter 'restart' of method 'AnalyzerRestartInfo' must not be null";
            this.m_restart = new THashSet(restart);
        }

        void removeAnalyzerId(IAnalyzerId remove) {
            assert (remove != null) : "Parameter 'remove' of method 'removeAnalyzerId' must not be null";
            assert (this.m_restart != null) : "Parameter 'm_restart' of method 'removeAnalyzerId' must not be null";
            this.m_restart.remove(remove);
        }

        boolean all() {
            return this.m_restart == null;
        }

        Set<IAnalyzerId> getAnalyzersToRestart() {
            assert (this.m_restart != null) : "'m_restart' of method 'getAnalyzersToRestart' must not be null";
            return Collections.unmodifiableSet(this.m_restart);
        }

        public String toString() {
            return this.m_restart == null ? "All" : Arrays.toString(this.m_restart.toArray());
        }
    }

    static final class ConfigurationChangedInfo {
        private final Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> m_affectedModelContributorPlugins = new THashSet();
        private final boolean m_requiresAnalyzersRestart;
        private AnalyzerRestartInfo m_restartInfo;
        private boolean m_requiresSaveSnapshot;

        ConfigurationChangedInfo(boolean requiresAnalyzersRestart) {
            this.m_requiresAnalyzersRestart = requiresAnalyzersRestart;
        }

        void setAnalyzerRestartInfo(AnalyzerRestartInfo restartInfo) {
            this.m_restartInfo = restartInfo;
        }

        boolean requiresAnalyzersRestart() {
            return this.m_requiresAnalyzersRestart;
        }

        void setRequiresSaveSnapshot(boolean requires) {
            this.m_requiresSaveSnapshot = requires;
        }

        boolean requiresSaveSnapshot() {
            return this.m_requiresSaveSnapshot;
        }

        AnalyzerRestartInfo getAnalyzerRestartInfo() {
            return this.m_restartInfo;
        }

        void addAffectedModelContributorPlugin(StrictPair<SonargraphPlugin, IPluginModelContributor> affected) {
            assert (affected != null) : "Parameter 'affected' of method 'addAffectedModelContributorPlugin' must not be null";
            this.m_affectedModelContributorPlugins.add(affected);
        }

        Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> getAffectedModelContributorPlugins() {
            return Collections.unmodifiableSet(this.m_affectedModelContributorPlugins);
        }
    }

    public static interface IConfigurationChangeHandler {
        public void configurationChanged(SoftwareSystem var1, String var2, EnumSet<Modification> var3, ConfigurationChangedInfo var4, boolean var5, boolean var6);

        public void configurationChangeFinished(IWorkerContext var1, SoftwareSystem var2, EnumSet<Modification> var3, ConfigurationChangedInfo var4, OperationResult var5);

        public void pluginConfigurationDeleted(IWorkerContext var1, SoftwareSystem var2, SonargraphPlugin var3, EnumSet<Modification> var4, ConfigurationChangedInfo var5);

        public SonargraphPlugin getPluginById(String var1);

        public List<SonargraphPlugin> getPlugins();
    }

    private static final class PluginIdFilter
    implements NamedElement.IFilter {
        private final String m_pluginId;

        public PluginIdFilter(String pluginId) {
            assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'PluginIdFilter' must not be empty";
            this.m_pluginId = pluginId;
        }

        @Override
        public boolean accept(NamedElement namedElement) {
            if (namedElement instanceof PluginConfigurationFile) {
                PluginConfigurationFile pluginConfiguration = (PluginConfigurationFile)namedElement;
                return this.m_pluginId.equals(pluginConfiguration.getPluginId());
            }
            return false;
        }
    }
}

