/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.BackgroundTaskException;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelValidator.class);

    private ModelValidator() {
    }

    static void validate(SoftwareSystem system, boolean parserModelChanged) {
        assert (system != null) : "Parameter 'system' of method 'validate' must not be null";
        if (LOGGER.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            LOGGER.debug("Validate system '" + system.getName() + "' [" + system.getAbsolutePath() + "]");
            int numberOfErrors = 0;
            LOGGER.debug("Validate virtual models");
            List<ParserModel> parserModels = system.getUniqueExistingChild(Files.class).getVirtualModels().getChildrenRecursively(ParserModel.class, new Class[0]);
            VirtualModel activeProductionModel = null;
            if (parserModels.size() != 1) {
                LOGGER.error("Exactly 1 parser model expected");
                ++numberOfErrors;
            } else {
                activeProductionModel = parserModels.get(0).getActiveProductionModel();
            }
            List<ModifiableModel> modifiableModels = system.getUniqueExistingChild(Files.class).getVirtualModels().getChildrenRecursively(ModifiableModel.class, new Class[0]);
            boolean activeProductionModelFound = false;
            for (ModifiableModel nextModifiableModel : modifiableModels) {
                if (activeProductionModel == nextModifiableModel) {
                    activeProductionModelFound = true;
                }
                if (!nextModifiableModel.needsApplication()) continue;
                LOGGER.error("Modifiable model '" + nextModifiableModel.getIdentifyingPath() + "' still needs application");
                ++numberOfErrors;
            }
            if (activeProductionModel != null && !activeProductionModelFound) {
                LOGGER.error("Active production model not set in parser model");
                ++numberOfErrors;
            }
            LOGGER.debug("Validate virtual models - done: " + numberOfErrors + " validation error(s)");
            TreeMap<String, Integer> categoryCollector = null;
            if (parserModelChanged) {
                categoryCollector = new TreeMap<String, Integer>();
                LOGGER.debug("Validate parser model");
                ParserModelCheck parserModelCheck = new ParserModelCheck(categoryCollector, system.getExtension(ISoftwareSystemProvider.class).getElementResolver());
                for (NamedElement namedElement : system.getUniqueExistingChild(Workspace.class).getChildren(ComponentContainer.class)) {
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(parserModelCheck);
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done");
                }
                LOGGER.debug("Validate parser model - done " + (numberOfErrors += parserModelCheck.getNumberOfErrors()) + " validation error(s)");
                int n = 0;
                LOGGER.debug("Validate logical model");
                LogicalModelCheck logicalModelCheck = new LogicalModelCheck(categoryCollector);
                for (NamedElement namedElement : system.getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(LogicalRoot.class)) {
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(logicalModelCheck);
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done: " + logicalModelCheck.getNumberOfErrors() + " validation error(s)");
                }
                numberOfErrors += logicalModelCheck.getNumberOfErrors();
                int n2 = n + logicalModelCheck.getNumberOfErrors();
                logicalModelCheck.reset();
                for (NamedElement namedElement : system.getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(LogicalRoot.class)) {
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]'");
                    namedElement.accept(logicalModelCheck);
                    LOGGER.trace("Validate '" + namedElement.getName() + " [" + namedElement.getClass().getSimpleName() + "]' - done: " + logicalModelCheck.getNumberOfErrors() + " validation error(s)");
                }
                int n3 = n2 + logicalModelCheck.getNumberOfErrors();
                numberOfErrors += logicalModelCheck.getNumberOfErrors();
                LOGGER.debug("Validate logical model - done: " + n3 + " validation error(s)");
            }
            LOGGER.debug("Validate system '" + system.getName() + "' [" + system.getAbsolutePath() + "] - done in " + (System.currentTimeMillis() - start) + " ms (" + numberOfErrors + " error(s))");
            if (categoryCollector != null) {
                for (Map.Entry nextEntry : categoryCollector.entrySet()) {
                    LOGGER.debug((String)nextEntry.getKey() + ": " + String.valueOf(nextEntry.getValue()));
                }
            }
            if (numberOfErrors > 0 && LOGGER.isTraceEnabled()) {
                EventManager.getInstance().dispatch((Object)system, (Event)new ExceptionEvent(system.getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException("There are " + numberOfErrors + " validation error(s)")));
            }
        }
    }

    private static final class LogicalModelCheck
    extends ModelCheck {
        private final Map<ProgrammingElement, LogicalProgrammingElement> m_peToLogicalPe = new THashMap();

        LogicalModelCheck(Map<String, Integer> categoryCollector) {
            super(categoryCollector);
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
            for (NamedElement namedElement : element.getAllChildren()) {
                namedElement.accept(this);
                if (this.done()) break;
            }
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            block7: {
                block5: {
                    List<ProgrammingElement> programmingElements;
                    block6: {
                        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
                        if (!(element instanceof LogicalNamespace)) break block5;
                        programmingElements = ((LogicalNamespace)element).getAllProgrammingElements();
                        if (!((LogicalNamespace)element).isPart()) break block6;
                        if (!programmingElements.isEmpty()) {
                            LOGGER.error("Logical part namespace contains " + programmingElements.size() + " programming elements: " + element.getFullyQualifiedName() + " [" + element.getClass().getName() + "]");
                            this.addError("Logical part namespace contains programming elements");
                        }
                        break block7;
                    }
                    if (!programmingElements.isEmpty()) break block7;
                    LOGGER.error("Logical non-part namespace contains no programming elements: " + element.getFullyQualifiedName() + " [" + element.getClass().getName() + "]");
                    this.addError("Logical non-part namespace contains no programming elements");
                    break block7;
                }
                if (element instanceof LogicalProgrammingElement) {
                    ProgrammingElement primary;
                    List<? extends ProgrammingElement> logicalGroup = ((LogicalProgrammingElement)element).getProgrammingElements();
                    if (!logicalGroup.contains(primary = ((LogicalProgrammingElement)element).getPrimaryProgrammingElement())) {
                        LOGGER.error("Primary programming element [" + primary.getClass().getName() + "] not contained in logical group");
                        this.addError("Primary programming element not contained in logical group");
                    }
                    for (ProgrammingElement programmingElement : logicalGroup) {
                        LogicalProgrammingElement previous = this.m_peToLogicalPe.put(programmingElement, (LogicalProgrammingElement)element);
                        if (previous == null || previous == element) continue;
                        LOGGER.error("Duplicate logical assignment [" + programmingElement.getClass().getName() + "]\n PE: " + programmingElement.getFullyQualifiedName() + "\n MAPPED TO: " + String.valueOf(previous) + "\n MAPPED TO: " + String.valueOf(element));
                        this.addError("Duplicate logical assignment");
                    }
                }
            }
            this.visitChildrenOf(element);
        }

        @Override
        void reset() {
            super.reset();
            this.m_peToLogicalPe.clear();
        }
    }

    private static abstract class ModelCheck
    extends NamedElementVisitor {
        private final Map<String, Integer> m_categoryCollector;
        private int m_numberOfErrors;

        ModelCheck(Map<String, Integer> categoryCollector) {
            assert (categoryCollector != null) : "Parameter 'categoryCollector' of method 'ModelCheck' must not be null";
            this.m_categoryCollector = categoryCollector;
        }

        protected final void addError(String category) {
            assert (category != null && category.length() > 0) : "Parameter 'category' of method 'addError' must not be empty";
            Integer number = this.m_categoryCollector.get(category);
            if (number == null) {
                this.m_categoryCollector.put(category, 1);
            } else {
                this.m_categoryCollector.put(category, number + 1);
            }
            ++this.m_numberOfErrors;
        }

        final int getNumberOfErrors() {
            return this.m_numberOfErrors;
        }

        void reset() {
            this.m_numberOfErrors = 0;
        }
    }

    private static final class ParserModelCheck
    extends ModelCheck {
        private final Set<ProgrammingElement> m_pes = new THashSet();
        private final Set<String> m_outDepsDescriptors = new THashSet();
        private final Set<String> m_childFqNameParts = new THashSet();
        private final IElementResolver m_resolver;

        ParserModelCheck(Map<String, Integer> categoryCollector, IElementResolver resolver) {
            super(categoryCollector);
            assert (resolver != null) : "Parameter 'resolver' of method 'ParserModelCheck' must not be null";
            this.m_resolver = resolver;
        }

        private void checkDependencies(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'checkDependencies' must not be null";
            List<ParserDependency> outgoingDependencies = element.getOutgoingDependencies(new IParserDependencyType[0]);
            if (element.isGhost() && !outgoingDependencies.isEmpty()) {
                LOGGER.error("Ghost programming element " + String.valueOf(element) + " has " + outgoingDependencies.size() + " outgoing dependencies");
                for (ParserDependency next : outgoingDependencies) {
                    LOGGER.error(next.toString());
                    this.addError("Ghost programming element has outgoing dependencies");
                }
            }
            for (ParserDependency nextOut : outgoingDependencies) {
                ProgrammingElement nextTo = nextOut.getTo();
                if (nextTo == null) {
                    LOGGER.error("'to' of outgoing dependency is 'null' for: " + String.valueOf(nextOut));
                    this.addError("'to' of outgoing dependency is 'null'");
                } else if (nextTo.getParent() == null) {
                    LOGGER.error("'to' of outgoing dependency has no parent for :" + String.valueOf(nextOut));
                    this.addError("'to' of outgoing dependency has no parent");
                } else if (nextTo.isGhost()) {
                    LOGGER.error("'to' is ghost programming element - outgoing dependency: " + String.valueOf(nextOut));
                    this.addError("'to' is ghost programming element - outgoing dependency");
                }
                String nextDescriptor = this.m_resolver.getDescriptor(nextOut);
                if (this.m_outDepsDescriptors.add(nextDescriptor)) continue;
                LOGGER.error("Outgoing dependency descriptor '" + nextDescriptor + "' not unique for: " + String.valueOf(nextOut));
                this.addError("Outgoing dependency descriptor not unique");
            }
            List<ParserDependency> incomingDependencies = element.getIncomingDependencies(new IStandardEnumeration[0]);
            if (element.isGhost() && !incomingDependencies.isEmpty()) {
                LOGGER.error("Ghost programming element " + String.valueOf(element) + " has " + incomingDependencies.size() + " incoming dependencies");
                for (ParserDependency next : incomingDependencies) {
                    LOGGER.error(next.toString());
                    this.addError("Ghost programming element has incoming dependencies");
                }
            }
            for (ParserDependency nextIn : incomingDependencies) {
                ProgrammingElement nextFrom = nextIn.getFrom();
                if (nextFrom == null) {
                    LOGGER.error("'from' of incoming dependency is 'null' for: " + String.valueOf(nextIn));
                    this.addError("'from' of incoming dependency is 'null'");
                    continue;
                }
                if (nextFrom.getParent() == null) {
                    LOGGER.error("'from' of incoming dependency has no parent for :" + String.valueOf(nextIn));
                    this.addError("'from' of incoming dependency has no parent");
                    continue;
                }
                if (!nextFrom.isGhost()) continue;
                LOGGER.error("'from' is ghost programming element - incoming dependency: " + String.valueOf(nextIn));
                this.addError("'from' is ghost programming element - incoming dependency");
            }
            this.m_outDepsDescriptors.clear();
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!element.isValid()) {
                LOGGER.error("Named element is not valid: " + String.valueOf(element));
                this.addError("Named element is not valid");
            } else {
                String descriptor;
                String fqNamePart;
                if (element instanceof ProgrammingElement) {
                    ProgrammingElement programmingElement = (ProgrammingElement)element;
                    if (!this.m_pes.add(programmingElement)) {
                        LOGGER.error("Programming element has duplicate FQName: " + String.valueOf(programmingElement));
                        this.addError(null);
                    }
                    if (programmingElement.getParent() == null) {
                        LOGGER.error("Programming element has no parent: " + String.valueOf(programmingElement));
                        this.addError("Programming element has no parent");
                    }
                    this.checkDependencies(programmingElement);
                    Language language = programmingElement.getLanguage();
                    if (language == null) {
                        LOGGER.error("Programming element has no language: " + String.valueOf(programmingElement));
                        this.addError("Programming element has no language");
                    }
                    if (language.hasLogicalModel() && !programmingElement.isGhost() && LogicalProgrammingElement.includeInLogicalModel(programmingElement)) {
                        NamespaceUtility.LogicalProgrammingElementInfo moduleInfo;
                        NamespaceUtility.LogicalProgrammingElementInfo logicalProgrammingElementInfo = NamespaceUtility.getLogicalProgrammingElementInfo(programmingElement, true);
                        if (logicalProgrammingElementInfo == null) {
                            LOGGER.error("Programming element has no logical system namespace counterpart: " + String.valueOf(programmingElement));
                            this.addError("Programming element has no logical system namespace counterpart");
                        }
                        if ((moduleInfo = NamespaceUtility.getLogicalProgrammingElementInfo(programmingElement, false)) == null) {
                            LOGGER.error("Programming element has no logical module namespace counterpart: " + String.valueOf(programmingElement));
                            this.addError("Programming element has no logical module namespace counterpart");
                        }
                    }
                }
                if ((fqNamePart = element.getFullyQualifiedNamePart()) == null || fqNamePart.isEmpty()) {
                    LOGGER.error("Fully qualified name part is empty for: " + String.valueOf(element));
                    this.addError("Fully qualified name part is empty");
                }
                if ((descriptor = this.m_resolver.getDescriptor(element)) == null || descriptor.isEmpty()) {
                    LOGGER.error("Descriptor is empty for: " + String.valueOf(element));
                    this.addError("Descriptor is empty");
                } else {
                    Element element2 = this.m_resolver.resolve(descriptor);
                    if (element2 == null) {
                        LOGGER.error("Unable to resolve element with descriptor '" + descriptor + "' for : " + String.valueOf(element));
                        this.addError("Unable to resolve element");
                    } else if (element != element2) {
                        LOGGER.error("Different element resolved with descriptor '" + descriptor + "'\nElement:\n" + element.getDebugInfo() + "\nResolved:\n" + element2.getDebugInfo());
                        this.addError("Different element resolved");
                    }
                }
                for (NamedElement namedElement : element.getAllChildren()) {
                    String nextFqNamePart = namedElement.getFullyQualifiedNamePart();
                    if (this.m_childFqNameParts.add(nextFqNamePart)) continue;
                    LOGGER.error("Fully qualified name part '" + nextFqNamePart + "' not unique for: " + String.valueOf(namedElement));
                    this.addError("Fully qualified name part not unique");
                }
                this.m_childFqNameParts.clear();
                this.visitChildrenOf(element);
            }
        }
    }
}

