/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.BalancedDependencyRepresentationProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LogicalRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.representation.ArchitectureRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.representation.BalancedDependencyExpandCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.BalancedDependencyIncomingOutgoingCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.BalancedDependencyInternalCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.DependencyAdditionalsCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.LogicalProgrammingElementCollectorForBalancedDependencies;
import com.hello2morrow.sonargraph.core.controller.system.representation.NonPartChildrenCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.PhysicalRepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.representation.PotentialDependencyCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.ProgrammingElementCollectorForBalancedDependencies;
import com.hello2morrow.sonargraph.core.controller.system.representation.RepresentationDescriptorCalculator;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IBalancedDependencyRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.event.RepresentationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyWithEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.representation.ElementGroupForDependencies;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElementGroup;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistry;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BalancedDependencyRepresentationExtension
extends BalancedDependencyRepresentationProvider
implements IBalancedDependencyRepresentationExtension {
    private final Logger LOGGER = LoggerFactory.getLogger(BalancedDependencyRepresentationExtension.class);
    private final boolean m_architectureEnabled;

    BalancedDependencyRepresentationExtension(LanguageProviderAccessor languageProviderAccessor, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, INamedElementResolver namedElementResolver, StructureItemRegistry structureItemRegistry) {
        super(languageProviderAccessor, softwareSystem, namedElementResolver, structureItemRegistry);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'BalancedDependencyRepresentationExtension' must not be null";
        this.m_architectureEnabled = finishModelProcessor.getLicenseProvider().isFeatureAvailable(SonargraphFeature.ARCHITECTURE);
        finishModelProcessor.addListener(this);
    }

    @Override
    protected RepresentationDescriptorCalculator<BalancedDependencyRepresentation> createRepresentationDescriptorCalculator(BalancedDependencyRepresentation representationToUpdate) {
        assert (representationToUpdate != null) : "Parameter 'representationToUpdate' of method 'createRepresentationDescriptorCalculator' must not be null";
        IDomainRoot.Domain domain = representationToUpdate.getDomain();
        return switch (domain) {
            case IDomainRoot.Domain.PHYSICAL -> new PhysicalRepresentationDescriptorCalculator<BalancedDependencyRepresentation>(representationToUpdate);
            case IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE, IDomainRoot.Domain.LOGICAL_MODULE_SCOPE -> new LogicalRepresentationDescriptorCalculator<BalancedDependencyRepresentation>(representationToUpdate);
            case IDomainRoot.Domain.ARCHITECTURE_PHYSICAL, IDomainRoot.Domain.ARCHITECTURE_LOGICAL -> new ArchitectureRepresentationDescriptorCalculator<BalancedDependencyRepresentation>(representationToUpdate);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected domain: " + String.valueOf((Object)domain)));
                }
                yield null;
            }
        };
    }

    @Override
    public final void updateRepresentation(IWorkerContext workerContext, BalancedDependencyRepresentation representationToUpdate, INavigationState navigationState, List<SoftwareSystemEvent> eventsToBeDispatched) {
        Set<Pair<NamedElement, NamedElement>> outgoingExpandedDependenciesAsEndpoints;
        Set<Pair<NamedElement, NamedElement>> internalExpandedDependenciesAsEndpoints;
        Set<Pair<NamedElement, NamedElement>> incomingExpandedDependenciesAsEndpoints;
        Object input;
        assert (representationToUpdate != null) : "Parameter 'representation' of method 'updateRepresentation' must not be null";
        assert (eventsToBeDispatched != null) : "Parameter 'eventsToBeDispatched' of method 'updateRepresentation' must not be null";
        boolean fromUndoRedo = false;
        if (navigationState != null) {
            input = new THashSet(navigationState.getElements(RepresentationElementGroup.ORIGINAL_INPUT, NamedElement.class, this.getNamedElementResolver()));
            incomingExpandedDependenciesAsEndpoints = navigationState.getDependenciesEndpoints(ElementGroupForDependencies.INCOMING_EXPANSION, this.getNamedElementResolver());
            internalExpandedDependenciesAsEndpoints = navigationState.getDependenciesEndpoints(ElementGroupForDependencies.INTERNAL_EXPANSION, this.getNamedElementResolver());
            outgoingExpandedDependenciesAsEndpoints = navigationState.getDependenciesEndpoints(ElementGroupForDependencies.OUTGOING_EXPANSION, this.getNamedElementResolver());
            fromUndoRedo = true;
        } else {
            RepresentationDescriptorCalculator<Object> representationDescriptorCalculator = this.getRepresentationDescriptorCalculator(representationToUpdate.getName());
            if (representationDescriptorCalculator == null) {
                representationDescriptorCalculator = this.createRepresentationDescriptorCalculator(representationToUpdate);
            }
            input = this.getElementsForUpdate(this.getSoftwareSystem(), representationToUpdate, representationDescriptorCalculator, NodeType.ORIGINAL);
            incomingExpandedDependenciesAsEndpoints = representationToUpdate.getExpandedDependenciesAsEndpoints(DependencyType.INCOMING);
            internalExpandedDependenciesAsEndpoints = representationToUpdate.getExpandedDependenciesAsEndpoints(DependencyType.INTERNAL);
            outgoingExpandedDependenciesAsEndpoints = representationToUpdate.getExpandedDependenciesAsEndpoints(DependencyType.OUTGOING);
        }
        if (input.isEmpty()) {
            this.removeRepresentation(representationToUpdate, true, false, eventsToBeDispatched);
        } else {
            assert (input.size() == 1) : "Only one element expected for BalancedDependencyRepresentation in 'componentModelModified'";
            NamedElement elementForRepresentation = (NamedElement)input.iterator().next();
            BalancedDependencyRepresentation updatedRepresentation = this.createDependencyRepresentationForNavigationOrModelUpdate((IWorkerContext)DefaultWorkerContext.INSTANCE, representationToUpdate, elementForRepresentation, incomingExpandedDependenciesAsEndpoints, internalExpandedDependenciesAsEndpoints, outgoingExpandedDependenciesAsEndpoints);
            eventsToBeDispatched.add(new RepresentationModifiedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), updatedRepresentation, true, fromUndoRedo));
        }
    }

    @Override
    public void removeRepresentation(Representation representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations) {
        this.removeRepresentation((BalancedDependencyRepresentation)representation, fireRepresentationRemovedEvent, removeSlaveRepresentations, (List<SoftwareSystemEvent>)null);
    }

    @Override
    protected final void removeRepresentation(BalancedDependencyRepresentation representation, boolean fireRepresentationRemovedEvent, boolean removeSlaveRepresentations, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (representation != null) : "Parameter 'representation' of method 'removeRepresentation' must not be null";
        representation.remove();
        if (fireRepresentationRemovedEvent) {
            RepresentationRemovedEvent representationRemovedEvent = new RepresentationRemovedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), representation);
            if (eventsToDispatch != null) {
                eventsToDispatch.add(representationRemovedEvent);
            } else {
                EventManager.getInstance().dispatch((Object)this, (Event)representationRemovedEvent);
            }
        }
    }

    @Override
    public BalancedDependencyRepresentation createDependencyRepresentation(IWorkerContext workerContext, NamedElement element, int nameSuffix) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createDependencyRepresentation' must not be null";
        assert (element != null) : "Parameter 'element' of method 'createDependencyRepresentation' must not be null";
        workerContext.working("Processing", true);
        THashSet incomingOutgoingReferenceElements = new THashSet();
        THashSet incomingDependencies = new THashSet();
        THashSet internalDependencies = new THashSet();
        THashSet outgoingDependencies = new THashSet();
        IDomainRoot.Domain domain = RepresentationUtility.defineDomain(Arrays.asList(element));
        BalancedDependencyRepresentation representation = new BalancedDependencyRepresentation(this.getSoftwareSystem(), element, domain, nameSuffix);
        StructureItem itemForIncomingOutgoing = element.getStructureItem();
        THashMap incomingOutgoingElementToAdditionals = new THashMap();
        THashSet inputForIncomingOutgoingNodeAdapterSet = new THashSet();
        if (element instanceof ProgrammingElement) {
            this.createDependenciesForProgrammingElement(representation, element, (Set<BalancedDependency>)incomingDependencies, (Set<BalancedDependency>)internalDependencies, (Set<BalancedDependency>)outgoingDependencies);
        } else if (element instanceof LogicalProgrammingElement) {
            this.createDependenciesForLogicalProgrammingElement(representation, element, (Set<BalancedDependency>)incomingDependencies, (Set<BalancedDependency>)internalDependencies, (Set<BalancedDependency>)outgoingDependencies, domain);
        } else {
            if (element instanceof Artifact) {
                incomingOutgoingReferenceElements.add(element);
                element.getChildrenRecursively(Artifact.class, new Class[0]).stream().filter(a -> a.getNumberOfAssignedElements() > 0).forEach(arg_0 -> BalancedDependencyRepresentationExtension.lambda$1((Set)incomingOutgoingReferenceElements, arg_0));
            } else if (itemForIncomingOutgoing.allowsFlat()) {
                incomingOutgoingReferenceElements.addAll(BalancedDependencyRepresentationExtension.getNonPartRecursiveChildren(itemForIncomingOutgoing, element, true));
            } else {
                incomingOutgoingReferenceElements.add(element);
            }
            for (NamedElement nextElement : incomingOutgoingReferenceElements) {
                StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(nextElement);
                Map<NamedElement, PotentialDependencyCollector.MatchingType> nodeMatchingMap = this.prepareIncomingOutgoingDependenciesInput(this.getSoftwareSystem(), structureInfo, representation, nextElement, domain);
                nodeMatchingMap.forEach((arg_0, arg_1) -> BalancedDependencyRepresentationExtension.lambda$2((Set)inputForIncomingOutgoingNodeAdapterSet, arg_0, arg_1));
                Collection additionalKeys = nodeMatchingMap.keySet().stream().filter(arg_0 -> BalancedDependencyRepresentationExtension.lambda$3((Set)incomingOutgoingReferenceElements, arg_0)).collect(Collectors.toList());
                THashMap additionalsForElement = new THashMap();
                for (NamedElement key : additionalKeys) {
                    additionalsForElement.put(key, nodeMatchingMap.get(key));
                }
                incomingOutgoingElementToAdditionals.put(nextElement, additionalsForElement);
            }
            BalancedDependencyIncomingOutgoingCollector incomingCollector = new BalancedDependencyIncomingOutgoingCollector(this.getSoftwareSystem(), (Set<NamedElement>)inputForIncomingOutgoingNodeAdapterSet, (Map<NamedElement, Map<NamedElement, PotentialDependencyCollector.MatchingType>>)incomingOutgoingElementToAdditionals, representation.getPeToLpeCache(), domain, DependencyType.INCOMING);
            BalancedDependencyIncomingOutgoingCollector outgoingCollector = new BalancedDependencyIncomingOutgoingCollector(this.getSoftwareSystem(), (Set<NamedElement>)inputForIncomingOutgoingNodeAdapterSet, (Map<NamedElement, Map<NamedElement, PotentialDependencyCollector.MatchingType>>)incomingOutgoingElementToAdditionals, representation.getPeToLpeCache(), domain, DependencyType.OUTGOING);
            ParserDependencyNodeAdapterSet incomingNodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)inputForIncomingOutgoingNodeAdapterSet, incomingCollector, RepresentationUtility.PE, RepresentationUtility.PD);
            ParserDependencyNodeAdapterSet outgoingNodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)inputForIncomingOutgoingNodeAdapterSet, outgoingCollector, RepresentationUtility.PE, RepresentationUtility.PD);
            for (NamedElement nextElement : incomingOutgoingReferenceElements) {
                StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(nextElement);
                incomingDependencies.addAll(this.getDependenciesFromNodeAdapterSet(structureInfo, incomingNodeAdapterSet, null, (Map)incomingOutgoingElementToAdditionals.get(nextElement), element, nextElement, DependencyType.INCOMING));
                outgoingDependencies.addAll(this.getDependenciesFromNodeAdapterSet(structureInfo, outgoingNodeAdapterSet, null, (Map)incomingOutgoingElementToAdditionals.get(nextElement), element, nextElement, DependencyType.OUTGOING));
            }
            StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(element);
            if (!structureInfo.isLastElementInStructure(itemForIncomingOutgoing) || !itemForIncomingOutgoing.includedInArchitecture()) {
                internalDependencies.addAll(this.calculateInternalOrDependenciesForExpand(representation, null, element, element, domain, DependencyType.INTERNAL, false));
            }
        }
        representation.setIncomingDependencies((Set<BalancedDependency>)incomingDependencies);
        representation.setInternalDependencies((Set<BalancedDependency>)internalDependencies);
        representation.setOutgoingDependencies((Set<BalancedDependency>)outgoingDependencies);
        BalancedDependencyRepresentation currentRepresentation = this.getSoftwareSystem().getUniqueExistingChild(Representations.class).getUniqueChild(new NameFilter(representation.getName()), BalancedDependencyRepresentation.class);
        if (currentRepresentation != null) {
            currentRepresentation.remove();
        }
        this.getSoftwareSystem().getUniqueExistingChild(Representations.class).addChild(representation);
        this.updateUnderlyingDependencies(representation);
        return representation;
    }

    private void createDependenciesForLogicalProgrammingElement(BalancedDependencyRepresentation representation, NamedElement selectedElement, Set<BalancedDependency> incomingCollector, Set<BalancedDependency> internalCollector, Set<BalancedDependency> outgoingCollector, IDomainRoot.Domain domain) {
        BalancedDependency balancedDependency;
        assert (representation != null) : "Parameter 'representation' of method 'createDependenciesForLogicalProgrammingElement' must not be null";
        assert (selectedElement != null) : "Parameter 'selectedElement' of method 'createDependenciesForLogicalProgrammingElement' must not be null";
        assert (internalCollector != null) : "Parameter 'collector' of method 'createDependenciesForLogicalProgrammingElement' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'createDependenciesForLogicalProgrammingElement' must not be null";
        ArrayList<LogicalProgrammingElement> logicalProgrammingElementsToCalculateDependencies = new ArrayList<LogicalProgrammingElement>();
        ArrayList<ProgrammingElement> involvedUnderlyingProgrammingElements = new ArrayList<ProgrammingElement>();
        Map<NamedElement, NamedElement> peToLpeCache = representation.getPeToLpeCache();
        if (selectedElement instanceof LogicalProgrammingElement) {
            LogicalProgrammingElement selectedLogicalProgrammingElement = (LogicalProgrammingElement)selectedElement;
            logicalProgrammingElementsToCalculateDependencies.add(selectedLogicalProgrammingElement);
            involvedUnderlyingProgrammingElements.addAll(selectedLogicalProgrammingElement.getProgrammingElements());
        }
        NamedElement.IFilter filter = new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                return namedElement instanceof LogicalProgrammingElement;
            }
        };
        for (NamedElement namedElement : selectedElement.getAllChildren(filter)) {
            assert (namedElement != null && namedElement instanceof LogicalProgrammingElement) : "Unexpected class in method 'createDependenciesForLogicalProgrammingElement': " + String.valueOf(namedElement);
            LogicalProgrammingElementCollectorForBalancedDependencies parserElementCollector = new LogicalProgrammingElementCollectorForBalancedDependencies(involvedUnderlyingProgrammingElements);
            namedElement.accept(parserElementCollector);
            logicalProgrammingElementsToCalculateDependencies.addAll(parserElementCollector.getCollectedElements());
        }
        if (incomingCollector != null) {
            for (ProgrammingElement programmingElement : involvedUnderlyingProgrammingElements) {
                for (ParserDependency nextParserDependency : programmingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                    if (!RepresentationUtility.PD.test(nextParserDependency)) continue;
                    ProgrammingElement fromProgrammingElement = nextParserDependency.getFrom();
                    LogicalProgrammingElement from = (LogicalProgrammingElement)peToLpeCache.get(fromProgrammingElement);
                    assert (from != null) : "'from' of method 'createDependenciesForLogicalProgrammingElement' must not be null for programming element: " + String.valueOf(fromProgrammingElement) + " of class " + String.valueOf(fromProgrammingElement.getClass());
                    if (from.hasAsParent(selectedElement, false) || from.equals(selectedElement)) continue;
                    LogicalProgrammingElement to = (LogicalProgrammingElement)peToLpeCache.get(programmingElement);
                    balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(from), null, from, to, DependencyType.INCOMING, this.m_architectureEnabled);
                    balancedDependency.addDependency(nextParserDependency);
                    incomingCollector.add(balancedDependency);
                }
            }
        }
        for (ProgrammingElement programmingElement : involvedUnderlyingProgrammingElements) {
            for (ParserDependency nextParserDependency : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (!RepresentationUtility.PD.test(nextParserDependency)) continue;
                ProgrammingElement toProgrammingElement = nextParserDependency.getTo();
                LogicalProgrammingElement to = (LogicalProgrammingElement)peToLpeCache.get(toProgrammingElement);
                if (to != null) {
                    LogicalProgrammingElement from = (LogicalProgrammingElement)peToLpeCache.get(programmingElement);
                    if (from != null) {
                        if (to.hasAsParent(selectedElement, false) || to.equals(selectedElement)) {
                            balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(from), null, from, to, DependencyType.INTERNAL, this.m_architectureEnabled);
                            balancedDependency.addDependency(nextParserDependency);
                            internalCollector.add(balancedDependency);
                            continue;
                        }
                        if (outgoingCollector == null) continue;
                        balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(from), null, from, to, DependencyType.OUTGOING, this.m_architectureEnabled);
                        balancedDependency.addDependency(nextParserDependency);
                        outgoingCollector.add(balancedDependency);
                        continue;
                    }
                    this.LOGGER.warn("'from' is null for programming element: " + String.valueOf(programmingElement) + " of class " + String.valueOf(programmingElement.getClass()));
                    continue;
                }
                this.LOGGER.warn("'to' is null for programming element: " + String.valueOf(toProgrammingElement) + " of class " + String.valueOf(toProgrammingElement.getClass()));
            }
        }
    }

    private void createDependenciesForProgrammingElement(BalancedDependencyRepresentation representation, NamedElement selectedElement, Set<BalancedDependency> incomingCollector, Set<BalancedDependency> internalCollector, Set<BalancedDependency> outgoingCollector) {
        BalancedDependency balancedDependency;
        assert (representation != null) : "Parameter 'representation' of method 'createDependenciesForProgrammingElement' must not be null";
        assert (selectedElement != null) : "Parameter 'selectedElement' of method 'calculateDependenciesBetweenProgrammingElements' must not be null";
        assert (internalCollector != null) : "Parameter 'internalCollector' of method 'createDependenciesForProgrammingElement' must not be null";
        ArrayList<ProgrammingElement> programmingElementsToCalculateDependencies = new ArrayList<ProgrammingElement>();
        if (selectedElement instanceof ProgrammingElement) {
            programmingElementsToCalculateDependencies.add((ProgrammingElement)selectedElement);
        }
        for (ProgrammingElement child : selectedElement.getChildren(ProgrammingElement.class)) {
            ProgrammingElementCollectorForBalancedDependencies parserElementCollector = new ProgrammingElementCollectorForBalancedDependencies();
            child.accept(parserElementCollector);
            programmingElementsToCalculateDependencies.addAll(parserElementCollector.getCollectedElements());
        }
        if (incomingCollector != null) {
            for (ProgrammingElement nextProgrammingElement : programmingElementsToCalculateDependencies) {
                for (ParserDependency nextParserDependency : nextProgrammingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                    ProgrammingElement from = nextParserDependency.getFrom();
                    if (from.hasAsParent(selectedElement, false) || from == selectedElement || !RepresentationUtility.PD.test(nextParserDependency)) continue;
                    balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(from), null, from, nextProgrammingElement, DependencyType.INCOMING, this.m_architectureEnabled);
                    balancedDependency.addDependency(nextParserDependency);
                    incomingCollector.add(balancedDependency);
                }
            }
        }
        for (ProgrammingElement nextProgrammingElement : programmingElementsToCalculateDependencies) {
            for (ParserDependency nextParserDependency : nextProgrammingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (!RepresentationUtility.PD.test(nextParserDependency)) continue;
                ProgrammingElement to = nextParserDependency.getTo();
                if (to.hasAsParent(selectedElement, false) || to == selectedElement) {
                    balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(nextProgrammingElement), null, nextProgrammingElement, to, DependencyType.INTERNAL, this.m_architectureEnabled);
                    balancedDependency.addDependency(nextParserDependency);
                    internalCollector.add(balancedDependency);
                    continue;
                }
                if (outgoingCollector == null) continue;
                balancedDependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(nextProgrammingElement), null, nextProgrammingElement, to, DependencyType.OUTGOING, this.m_architectureEnabled);
                balancedDependency.addDependency(nextParserDependency);
                outgoingCollector.add(balancedDependency);
            }
        }
    }

    private void createProgrammingElementDependenciesForExpand(BalancedDependency parent, Set<BalancedDependency> childrenCollector) {
        assert (parent != null) : "Parameter 'parent' of method 'createProgrammingElementDependenciesForExpand' must not be null";
        assert (childrenCollector != null) : "Parameter 'childrenCollector' of method 'createProgrammingElementDependenciesForExpand' must not be null";
        for (ParserDependency parserDependency : parent.getDependencies()) {
            assert (RepresentationUtility.PD.test(parserDependency)) : "'parserDependency' must have been skipped " + String.valueOf(parserDependency);
            BalancedDependency balancedDependency = new BalancedDependency(parent.getStructureInfo(), parent, parserDependency.getFrom(), parserDependency.getTo(), parent.getDependencyType(), this.m_architectureEnabled);
            balancedDependency.addDependency(parserDependency);
            childrenCollector.add(balancedDependency);
        }
    }

    private void createLogicalProgrammingElementDependenciesForExpand(BalancedDependencyRepresentation representation, BalancedDependency parent, Set<BalancedDependency> childrenCollector) {
        assert (representation != null) : "Parameter 'representation' of method 'createLogicalProgrammingElementDependenciesForExpand' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createLogicalProgrammingElementDependenciesForExpand' must not be null";
        assert (childrenCollector != null) : "Parameter 'childrenCollector' of method 'createLogicalProgrammingElementDependenciesForExpand' must not be null";
        Map<NamedElement, NamedElement> peToLpeCache = representation.getPeToLpeCache();
        for (ParserDependency parserDependency : parent.getDependencies()) {
            assert (RepresentationUtility.PD.test(parserDependency)) : "'parserDependency' must have been skipped " + String.valueOf(parserDependency);
            ProgrammingElement fromProgrammingElement = parserDependency.getFrom();
            LogicalProgrammingElement from = (LogicalProgrammingElement)peToLpeCache.get(fromProgrammingElement);
            assert (from != null) : "'from' of method 'createDependenciesForLogicalProgrammingElement' must not be null for programming element: " + String.valueOf(fromProgrammingElement) + " of class " + String.valueOf(fromProgrammingElement.getClass());
            ProgrammingElement toProgrammingElement = parserDependency.getTo();
            LogicalProgrammingElement to = (LogicalProgrammingElement)peToLpeCache.get(toProgrammingElement);
            assert (to != null) : "'to' of method 'createDependenciesForLogicalProgrammingElement' must not be null for programming element: " + String.valueOf(toProgrammingElement) + " of class " + String.valueOf(toProgrammingElement.getClass());
            BalancedDependency balancedDependency = new BalancedDependency(parent.getStructureInfo(), parent, from, to, parent.getDependencyType(), this.m_architectureEnabled);
            balancedDependency.addDependency(parserDependency);
            childrenCollector.add(balancedDependency);
        }
    }

    private void addParserDependencyToBalancedDependencies(Map<BalancedDependency, List<ParserDependency>> dependencyToParserDependency, BalancedDependency dependency, List<ParserDependency> dependenciesToAdd) {
        assert (dependencyToParserDependency != null) : "Parameter 'dependencyToParserDependency' of method 'addParserDependencyToBalancedDependencies' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'addParserDependencyToBalancedDependencies' must not be null";
        assert (dependenciesToAdd != null) : "Parameter 'dependenciesToAdd' of method 'addParserDependencyToBalancedDependencies' must not be null";
        List<ParserDependency> currentDependencies = dependencyToParserDependency.get(dependency);
        if (currentDependencies == null) {
            currentDependencies = new ArrayList<ParserDependency>();
            dependencyToParserDependency.put(dependency, currentDependencies);
        }
        currentDependencies.addAll(dependenciesToAdd);
    }

    private void calculateInternalOrExpandDependenciesForNonProgrammingElements(BalancedDependencyRepresentation representation, BalancedDependency parentDependency, NamedElement from, NamedElement to, Set<BalancedDependency> dependencies, DependencyType dependencyType) {
        Set<Object> toChildren;
        assert (representation != null) : "Parameter 'representation' of method 'calculateInternalOrExpandDependencies' must not be null";
        assert (from != null) : "Parameter 'from' of method 'calculateInternalOrExpandDependencies' must not be null";
        assert (to != null) : "Parameter 'to' of method 'calculateInternalOrExpandDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'calculateInternalOrExpandDependenciesForNonProgrammingElements' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'calculateInternalOrExpandDependencies' must not be null";
        IDomainRoot.Domain domain = representation.getDomain();
        boolean internalDependencies = parentDependency == null;
        THashSet inputForNodeAdapterSet = new THashSet();
        Set<NamedElement> fromChildren = this.getChildrenFromPresentationMode(from, domain, PresentationMode.FLAT, internalDependencies);
        StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(from);
        if (!internalDependencies) assert (structureInfo.isInStructure(to.getStructureItem())) : String.valueOf((Object)to.getStructureItem()) + " not in " + String.valueOf(structureInfo);
        if (internalDependencies && from.getStructureItem().allowsFlat()) {
            fromChildren.add(from);
        }
        boolean specialBalancing = false;
        if (parentDependency != null && (domain == IDomainRoot.Domain.ARCHITECTURE_PHYSICAL || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) && (!parentDependency.isLeaf() && parentDependency.getBalanceMode() == BalancedDependency.BalanceMode.UNBALANCED_IN_TO && from.isOfStructureItem(StructureItem.COMPONENT) && !structureInfo.isLastElementInStructure(to.getStructureItem()) || parentDependency.isSpecialBalance())) {
            specialBalancing = true;
            fromChildren.add(from);
        }
        Predicate<NamedElement> isProgrammingElement = namedElement -> namedElement instanceof ProgrammingElement || namedElement instanceof LogicalProgrammingElement;
        fromChildren.removeIf(isProgrammingElement);
        if (!internalDependencies) {
            toChildren = this.getChildrenFromPresentationMode(to, domain, PresentationMode.FLAT, false);
            toChildren.removeIf(isProgrammingElement);
        } else {
            toChildren = Collections.emptySet();
        }
        inputForNodeAdapterSet.addAll(fromChildren);
        inputForNodeAdapterSet.addAll(toChildren);
        BalancedDependencyInternalCollector collector = parentDependency == null ? new BalancedDependencyInternalCollector(this.getSoftwareSystem(), (Set<NamedElement>)inputForNodeAdapterSet, from, to, fromChildren, fromChildren, representation.getPeToLpeCache(), domain, dependencyType, true) : new BalancedDependencyExpandCollector(this.getSoftwareSystem(), (Set<NamedElement>)inputForNodeAdapterSet, from, to, fromChildren, toChildren, representation.getPeToLpeCache(), parentDependency.getDependencies(), domain, dependencyType, true);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, (Collection<? extends NamedElement>)inputForNodeAdapterSet, collector, RepresentationUtility.PE, RepresentationUtility.PD);
        THashMap dependencyToParserDependencies = new THashMap();
        Iterator iterator = nodeAdapterSet.iterator();
        while (iterator.hasNext()) {
            ParserDependencyNodeAdapter nodeAdapter = (ParserDependencyNodeAdapter)iterator.next();
            for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge : nodeAdapter.getOutgoingEdges()) {
                BalancedDependency dependency;
                NamedElement parent;
                NamedElement toEndpoint;
                if (!nodeAdapter.hasDependencies()) continue;
                NamedElement fromEndpoint = ((ParserDependencyNodeAdapter)edge.getFrom()).getUnderlyingObject();
                if (fromEndpoint.isOfStructureItem((toEndpoint = ((ParserDependencyNodeAdapter)edge.getTo()).getUnderlyingObject()).getStructureItem())) {
                    BalancedDependency dependency2 = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(fromEndpoint), parentDependency, fromEndpoint, toEndpoint, dependencyType, this.m_architectureEnabled);
                    this.addParserDependencyToBalancedDependencies((Map<BalancedDependency, List<ParserDependency>>)dependencyToParserDependencies, dependency2, edge.getDependencies());
                    dependencies.add(dependency2);
                    continue;
                }
                if (specialBalancing) {
                    assert (parentDependency != null) : "Parameter 'parentDependency' of method 'calculateInternalOrExpandDependenciesForNonProgrammingElements' must not be null";
                    BalancedDependency dependency3 = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(fromEndpoint), parentDependency, fromEndpoint, toEndpoint, dependencyType, this.m_architectureEnabled);
                    dependency3.setSpecialBalance(true);
                    this.addParserDependencyToBalancedDependencies((Map<BalancedDependency, List<ParserDependency>>)dependencyToParserDependencies, dependency3, edge.getDependencies());
                    dependency3.setBalanceMode(BalancedDependency.BalanceMode.UNBALANCED_IN_FROM);
                    dependencies.add(dependency3);
                    continue;
                }
                int fromPositionInStructure = structureInfo.getPositionInStructure(fromEndpoint.getStructureItem());
                int toPositionInStructure = structureInfo.getPositionInStructure(toEndpoint.getStructureItem());
                if (structureInfo.compare(fromEndpoint.getStructureItem(), toEndpoint.getStructureItem()) > 0) {
                    parent = fromEndpoint.getParent();
                    while (structureInfo.getPositionInStructure(parent.getStructureItem()) > toPositionInStructure) {
                        parent = parent.getParent();
                    }
                    dependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(parent), parentDependency, parent, toEndpoint, dependencyType, this.m_architectureEnabled);
                    dependency.setBalanceMode(BalancedDependency.BalanceMode.UNBALANCED_IN_FROM);
                    this.addParserDependencyToBalancedDependencies((Map<BalancedDependency, List<ParserDependency>>)dependencyToParserDependencies, dependency, edge.getDependencies());
                    dependencies.add(dependency);
                    continue;
                }
                assert (structureInfo.compare(fromEndpoint.getStructureItem(), toEndpoint.getStructureItem()) < 0) : "Expected " + String.valueOf(toEndpoint) + " to be upper in the structure";
                parent = toEndpoint.getParent();
                while (structureInfo.getPositionInStructure(parent.getStructureItem()) > fromPositionInStructure) {
                    parent = parent.getParent();
                }
                dependency = new BalancedDependency(this.getStructureItemRegistry().getStructureForElement(fromEndpoint), parentDependency, fromEndpoint, parent, dependencyType, this.m_architectureEnabled);
                dependency.setBalanceMode(BalancedDependency.BalanceMode.UNBALANCED_IN_TO);
                this.addParserDependencyToBalancedDependencies((Map<BalancedDependency, List<ParserDependency>>)dependencyToParserDependencies, dependency, edge.getDependencies());
                dependencies.add(dependency);
            }
        }
        for (Map.Entry entry : dependencyToParserDependencies.entrySet()) {
            ((BalancedDependency)entry.getKey()).addDependencies((Collection)entry.getValue());
        }
    }

    private Collection<BalancedDependency> calculateInternalOrDependenciesForExpand(BalancedDependencyRepresentation representation, BalancedDependency parentDependency, NamedElement fromEndpoint, NamedElement toEndpoint, IDomainRoot.Domain domain, DependencyType dependencyType, boolean isExpand) {
        assert (representation != null) : "Parameter 'representation' of method 'calculateInternalOrDependenciesForExpand' must not be null";
        assert (fromEndpoint != null) : "Parameter 'fromEndpoint' of method 'calculateInternalDependencies' must not be null";
        assert (toEndpoint != null) : "Parameter 'toEndpoint' of method 'calculateInternalDependencies' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'calculateInternalDependencies' must not be null";
        Collection<BalancedDependency> internalDependencies = this.calculateInternalDependenciesForAllElements(representation, parentDependency, domain, dependencyType, fromEndpoint, toEndpoint, isExpand);
        if (isExpand) assert (internalDependencies != null && !internalDependencies.isEmpty()) : "Parameter 'internalDependencies' of method 'calculateInternalDependencies' must not be empty";
        return internalDependencies;
    }

    private Collection<BalancedDependency> calculateInternalDependenciesForAllElements(BalancedDependencyRepresentation representation, BalancedDependency parentDependency, IDomainRoot.Domain domain, DependencyType dependencyType, NamedElement from, NamedElement to, boolean isExpand) {
        assert (representation != null) : "Parameter 'representation' of method 'calculateInternalDependenciesFromLanguageStructureItem' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'calculateInternalDependenciesFromLanguageStructureItem' must not be null";
        assert (from != null) : "Parameter 'from' of method 'calculateInternalDependenciesFromLanguageStructureItem' must not be null";
        assert (to != null) : "Parameter 'to' of method 'calculateInternalDependenciesFromLanguageStructureItem' must not be null";
        THashSet internalDependencies = new THashSet();
        StructureInfo structureInfo = this.getStructureItemRegistry().getStructureForElement(from);
        StructureItem nextStructureItem = structureInfo.getNext(from.getStructureItem());
        boolean calculateDependencies = true;
        while (calculateDependencies) {
            if (structureInfo.isLastElementInStructure(nextStructureItem) && domain != IDomainRoot.Domain.ARCHITECTURE_PHYSICAL && domain != IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
                if (domain == IDomainRoot.Domain.PHYSICAL) {
                    if (isExpand) {
                        this.createProgrammingElementDependenciesForExpand(parentDependency, (Set<BalancedDependency>)internalDependencies);
                    } else {
                        this.createDependenciesForProgrammingElement(representation, from, null, (Set<BalancedDependency>)internalDependencies, null);
                    }
                } else {
                    assert (domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE) : "Unexpeced domain: " + String.valueOf((Object)domain);
                    if (isExpand) {
                        this.createLogicalProgrammingElementDependenciesForExpand(representation, parentDependency, (Set<BalancedDependency>)internalDependencies);
                    } else {
                        this.createDependenciesForLogicalProgrammingElement(representation, from, null, (Set<BalancedDependency>)internalDependencies, null, domain);
                    }
                }
                if (from.getStructureItem().allowsFlat()) {
                    this.calculateInternalOrExpandDependenciesForNonProgrammingElements(representation, parentDependency, from, to, (Set<BalancedDependency>)internalDependencies, dependencyType);
                }
            } else {
                this.calculateInternalOrExpandDependenciesForNonProgrammingElements(representation, parentDependency, from, to, (Set<BalancedDependency>)internalDependencies, dependencyType);
            }
            if (nextStructureItem.isOptional() && !structureInfo.isLastElementInStructure(nextStructureItem) && internalDependencies.isEmpty()) {
                nextStructureItem = structureInfo.getNext(nextStructureItem);
                continue;
            }
            calculateDependencies = false;
        }
        return internalDependencies;
    }

    private Collection<BalancedDependency> getDependenciesFromNodeAdapterSet(StructureInfo structureInfo, NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, BalancedDependency parent, Map<NamedElement, PotentialDependencyCollector.MatchingType> inputForDependencies, NamedElement selected, NamedElement referenceElement, DependencyType dependencyType) {
        assert (structureInfo != null) : "Parameter 'structureInfo' of method 'getDependenciesFromNodeAdapterSet' must not be null";
        assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'getDependenciesForNodeAdapter' must not be null";
        assert (inputForDependencies != null) : "Parameter 'inputForDependencies' of method 'getDependenciesForNodeAdapter' must not be null";
        assert (referenceElement != null) : "Parameter 'selected' of method 'getDependenciesForNodeAdapter' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'getDependenciesForNodeAdapter' must not be null";
        THashSet dependencies = new THashSet();
        ParserDependencyNodeAdapter nodeAdapter = nodeAdapterSet.getNodeAdapterFor(referenceElement);
        if (nodeAdapter != null) {
            Collection<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> edgeAdapters = null;
            switch (dependencyType) {
                case INCOMING: {
                    edgeAdapters = nodeAdapter.getIncomingEdges();
                    break;
                }
                case OUTGOING: 
                case INTERNAL: {
                    edgeAdapters = nodeAdapter.getOutgoingEdges();
                    break;
                }
                default: {
                    assert (false) : "Unexpected Dependency type" + dependencyType.name();
                    return null;
                }
            }
            boolean shouldFlattenSelected = selected instanceof IRecursiveElement;
            for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge : edgeAdapters) {
                if ((dependencyType != DependencyType.INCOMING || shouldFlattenSelected && this.isInternalDependency(selected, edge)) && (dependencyType != DependencyType.OUTGOING || shouldFlattenSelected && this.isInternalDependency(selected, edge)) && dependencyType != DependencyType.INTERNAL) continue;
                BalancedDependencyWithEdgeAdapter dependency = new BalancedDependencyWithEdgeAdapter(this.getStructureItemRegistry().getStructureForElement(((ParserDependencyNodeAdapter)edge.getFrom()).getUnderlyingObject()), null, edge, dependencyType, this.m_architectureEnabled);
                dependency.addDependencies(edge.getDependencies());
                NamedElement endPoint = dependencyType == DependencyType.INCOMING ? ((ParserDependencyNodeAdapter)edge.getFrom()).getUnderlyingObject() : ((ParserDependencyNodeAdapter)edge.getTo()).getUnderlyingObject();
                PotentialDependencyCollector.MatchingType matchingType = inputForDependencies.get(endPoint);
                if (matchingType == null) {
                    assert (dependencyType == DependencyType.INTERNAL) : "Null matching type not allowed for '" + String.valueOf((Object)dependencyType) + "' ";
                    continue;
                }
                switch (matchingType) {
                    case UNMATCHED: {
                        BalancedDependency.BalanceMode balanceMode = dependencyType == DependencyType.INCOMING ? BalancedDependency.BalanceMode.UNBALANCED_IN_FROM : BalancedDependency.BalanceMode.UNBALANCED_IN_TO;
                        dependency.setBalanceMode(balanceMode);
                        break;
                    }
                }
                if (this.dependencyHasWrongParent(structureInfo, parent, dependency)) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    private boolean dependencyHasWrongParent(StructureInfo registry, BalancedDependency parent, BalancedDependency child) {
        assert (registry != null) : "Parameter 'registry' of method 'dependencyHasWrongParent' must not be null";
        assert (child != null) : "Parameter 'child' of method 'dedendencyHasWrongParent' must not be null";
        boolean hasWrongParent = false;
        if (parent != null) {
            NamedElement element;
            DependencyType type = parent.getDependencyType();
            NamedElement fromParent = parent.getFromEndPoint();
            NamedElement toParent = parent.getToEndPoint();
            NamedElement fromChild = child.getFromEndPoint();
            NamedElement toChild = child.getToEndPoint();
            NamedElement referenceParent = type == DependencyType.INCOMING ? fromParent : toParent;
            NamedElement referenceChild = type == DependencyType.INCOMING ? fromChild : toChild;
            NamedElement namedElement = element = type == DependencyType.INCOMING ? toParent : fromParent;
            if (element instanceof IRecursiveElement && !referenceChild.hasAsParent(referenceParent, true) && referenceChild != referenceParent) {
                hasWrongParent = true;
            }
        }
        return hasWrongParent;
    }

    private boolean isInternalDependency(NamedElement selectedElement, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> dependency) {
        assert (selectedElement != null) : "Parameter 'selectedElement' of method 'isInternalDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'isInternalDependency' must not be null";
        return !(!((ParserDependencyNodeAdapter)dependency.getFrom()).getUnderlyingObject().hasAsParent(selectedElement, false) && ((ParserDependencyNodeAdapter)dependency.getFrom()).getUnderlyingObject() != selectedElement || !((ParserDependencyNodeAdapter)dependency.getTo()).getUnderlyingObject().hasAsParent(selectedElement, false) && ((ParserDependencyNodeAdapter)dependency.getTo()).getUnderlyingObject() != selectedElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expandDependencyRepresentation(IWorkerContext workerContext, BalancedDependencyRepresentation representation, BalancedDependency dependencyToExpand) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'expandDependencyRepresentation' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'expandDependencyRepresentation' must not be null";
        assert (dependencyToExpand != null) : "Parameter 'parentDependency' of method 'expandDependencyRepresentation' must not be null";
        workerContext.working("Processing", true);
        BalancedDependencyRepresentation balancedDependencyRepresentation = representation;
        synchronized (balancedDependencyRepresentation) {
            Collection<BalancedDependency> allDependencies = this.calculateInternalOrDependenciesForExpand(representation, dependencyToExpand, dependencyToExpand.getFromEndPoint(), dependencyToExpand.getToEndPoint(), representation.getDomain(), dependencyToExpand.getDependencyType(), true);
            dependencyToExpand.addAllChildren(allDependencies);
            representation.addExpandedDependency(dependencyToExpand);
            this.updateUnderlyingDependencies(representation);
        }
    }

    private BalancedDependencyRepresentation createDependencyRepresentationForNavigationOrModelUpdate(IWorkerContext workerContext, BalancedDependencyRepresentation previousRepresentation, NamedElement element, Collection<Pair<NamedElement, NamedElement>> expandedIncoming, Collection<Pair<NamedElement, NamedElement>> expandedInternal, Collection<Pair<NamedElement, NamedElement>> expandedOutgoing) {
        BalancedDependencyRepresentation representation = this.createDependencyRepresentation(workerContext, element, previousRepresentation.getId());
        Map<Pair<NamedElement, NamedElement>, BalancedDependency> endpointsToSymmetricDependency = this.getEndpointsForAllDependencies(representation);
        this.applyExpand(workerContext, representation, endpointsToSymmetricDependency, expandedIncoming);
        this.applyExpand(workerContext, representation, endpointsToSymmetricDependency, expandedInternal);
        this.applyExpand(workerContext, representation, endpointsToSymmetricDependency, expandedOutgoing);
        return representation;
    }

    private void applyExpand(IWorkerContext workerContext, BalancedDependencyRepresentation representation, Map<Pair<NamedElement, NamedElement>, BalancedDependency> endpointsToSymmetricDependency, Collection<Pair<NamedElement, NamedElement>> dependenciesToExpand) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyExpand' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyExpand' must not be null";
        assert (endpointsToSymmetricDependency != null) : "Parameter 'endpointsToSymmetricDependency' of method 'applyExpand' must not be null";
        assert (dependenciesToExpand != null) : "Parameter 'dependenciesToExpand' of method 'applyExpand' must not be null";
        if (!dependenciesToExpand.isEmpty()) {
            ArrayList<Pair<NamedElement, NamedElement>> sorted = new ArrayList<Pair<NamedElement, NamedElement>>(dependenciesToExpand);
            Collections.sort(sorted, new Comparator<Pair<NamedElement, NamedElement>>(){

                @Override
                public int compare(Pair<NamedElement, NamedElement> p1, Pair<NamedElement, NamedElement> p2) {
                    NamedElement from1 = (NamedElement)p1.getFirst();
                    NamedElement from2 = (NamedElement)p2.getFirst();
                    int depth1 = NamedElementUtility.getDepth(from1);
                    int depth2 = NamedElementUtility.getDepth(from2);
                    return Integer.compare(depth1, depth2);
                }
            });
            for (Pair pair : sorted) {
                BalancedDependency dependency = endpointsToSymmetricDependency.get(pair);
                if (dependency == null) continue;
                this.expandDependencyRepresentation(workerContext, representation, dependency);
                for (BalancedDependency child : dependency.getChildren()) {
                    endpointsToSymmetricDependency.put((Pair<NamedElement, NamedElement>)new Pair((Object)child.getFromEndPoint(), (Object)child.getToEndPoint()), child);
                }
            }
        }
    }

    private Map<NamedElement, PotentialDependencyCollector.MatchingType> prepareIncomingOutgoingDependenciesInput(SoftwareSystem softwareSystem, StructureInfo structureInfo, BalancedDependencyRepresentation representation, NamedElement selected, IDomainRoot.Domain domain) {
        assert (structureInfo != null) : "Parameter 'structureInfo' of method 'prepareIncomingOutgoingDependenciesInput' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'prepareIncomingOutgoingDependenciesInput' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'prepareIncomingOutgoingDependenciesInput' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'prepareIncomingOutgoingDependenciesInput' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'prepareIncomingOutgoingDependenciesInput' must not be null";
        NamedElement rootElement = RepresentationUtility.getRootElementForRepresentation(this.getSoftwareSystem(), Collections.singletonList(selected), domain);
        DependencyAdditionalsCollector collector = new DependencyAdditionalsCollector(this, structureInfo, representation, selected, rootElement, domain);
        rootElement.accept(collector);
        Map<NamedElement, PotentialDependencyCollector.MatchingType> input = collector.getCalculatedAdditionals();
        return input;
    }

    public static Collection<NamedElement> getNonPartRecursiveChildren(StructureItem parentItem, NamedElement parent, boolean checkAndIncludeParent) {
        assert (parentItem != null) : "Parameter 'item' of method 'getNonPartRecursiveElements' must not be null";
        THashSet nonPartRecursiveElements = new THashSet();
        if (parentItem.allowsFlat()) {
            NonPartChildrenCollector collector = new NonPartChildrenCollector(parent, (Collection<NamedElement>)nonPartRecursiveElements, checkAndIncludeParent, false);
            parent.accept(collector);
        }
        return nonPartRecursiveElements;
    }

    @Override
    public final void updateUnderlyingDependencies(BalancedDependencyRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateUnderlyingDependencies' must not be null";
        IProviderId issueProviderId = null;
        NamedElement rootElement = representation.getRootElement();
        if (rootElement instanceof ArchitectureFile) {
            issueProviderId = ((ArchitectureFile)rootElement).getIssueProviderId();
        }
        for (BalancedDependency balancedDependency : representation.getAllDependencies()) {
            balancedDependency.update(issueProviderId);
        }
    }

    @Override
    protected Class<BalancedDependencyRepresentation> getClassForExtension() {
        return BalancedDependencyRepresentation.class;
    }

    private static /* synthetic */ void lambda$1(Set set, Artifact a) {
        boolean bl = set.add(a);
    }

    private static /* synthetic */ void lambda$2(Set set, NamedElement key, PotentialDependencyCollector.MatchingType value) {
        boolean bl = set.add(key);
    }

    private static /* synthetic */ boolean lambda$3(Set set, NamedElement k) {
        return !set.contains(k);
    }
}

