/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.TopLevelProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IArchitectureFileAccess;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureFileFormatter;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureSourceLineVisitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureViolationAggregator;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignedElementCollector;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionProposalsCollector;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedDeprecationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedViolationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementsInfo;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureSubDirectory;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssue;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.ElementAssignmentInfo;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureDefinitionElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.persistence.architecture.ArchitectureFilePersistence;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class ArchitectureProvider
extends Extension
implements IArchitectureProvider,
IArchitectureFileAccess,
ArchitectureViolationAggregator.IArtifactProvider {
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final Map<String, ArchitectureFile> m_architectureFiles = new TreeMap<String, ArchitectureFile>();
    private final Map<String, String> m_architectureFilesForCompilation = new LinkedHashMap<String, String>();
    private final ArchitectureSourceLineVisitor m_architectureSourceLineVisitor = new ArchitectureSourceLineVisitor();

    protected ArchitectureProvider(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'ArchitectureProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitectureProvider' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    @Override
    public IFormatter getFormatter(FormatterOptions options) {
        assert (options != null) : "Parameter 'options' of method 'getFormatter' must not be null";
        return new ArchitectureFileFormatter(options);
    }

    @Override
    public final String getArchitectureCheckConfigurationFileName() {
        return AnalyzerConfigurationFile.getFileName(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    protected final ArchitectureCheckConfiguration getArchitectureCheckConfiguration(boolean forEdit) {
        AnalyzerConfiguration configuration;
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        AnalyzerConfiguration analyzerConfiguration = configuration = forEdit ? analyzerExtension.getConfigurationForEdit(CoreAnalyzerId.ARCHITECTURE_CHECK) : analyzerExtension.getConfiguration(CoreAnalyzerId.ARCHITECTURE_CHECK);
        assert (configuration != null && configuration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'getArchitectureCheckConfiguration': " + String.valueOf(configuration);
        return (ArchitectureCheckConfiguration)configuration;
    }

    protected final ArchitectureFile addArchitectureFile(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'addArchitectureFile' must not be null";
        return this.m_architectureFiles.put(architectureFile.getIdentifyingPath(), architectureFile);
    }

    protected final ArchitectureFile removeArchitectureFile(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeArchitectureFile' must not be empty";
        return this.m_architectureFiles.remove(identifyingPath);
    }

    @Override
    public final ArchitectureFile getArchitectureFile(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getArchitectureFile' must not be empty";
        return !identifyingPath.startsWith("./") ? this.m_architectureFiles.get("./" + identifyingPath) : this.m_architectureFiles.get(identifyingPath);
    }

    protected final ArchitectureFilePersistence getPersistence() {
        return new ArchitectureFilePersistence(this.m_installation.getVersion());
    }

    protected final Architecture getArchitectureDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getArchitecture();
    }

    protected final Set<NamedElement> getNormalizedArchitectureFileToDelete(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getNormalizedArchitectureFileToDelete' must not be empty";
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>(elements.size());
        for (Element element : elements) {
            if (!(element instanceof NamedElement)) continue;
            namedElements.add((NamedElement)element);
        }
        return NamedElementUtility.normalize(namedElements, true, new Class[0]);
    }

    protected final void changeIdentifyingPathOfArchitectureFile(String oldIdentifyingPath, String newIdentifyingPath) {
        assert (oldIdentifyingPath != null && oldIdentifyingPath.length() > 0) : "Parameter 'oldIdentifyingPath' of method 'changeIdentifyingPathOfArchitectureFile' must not be empty";
        assert (newIdentifyingPath != null && newIdentifyingPath.length() > 0) : "Parameter 'newIdentifyingPath' of method 'changeIdentifyingPathOfArchitectureFile' must not be empty";
        ArchitectureFile found = this.m_architectureFiles.remove(oldIdentifyingPath);
        assert (found != null) : "'found' of method 'changeIdentifyingPathOfArchitectureFile' must not be null";
        ArchitectureFile replaced = this.m_architectureFiles.put(newIdentifyingPath, found);
        assert (replaced == null) : "'replaced' of method 'changeIdentifyingPathOfArchitectureFile' must be null";
    }

    protected final ArchitectureCheckConfiguration getArchitectureCheckConfiguration() {
        return (ArchitectureCheckConfiguration)this.m_softwareSystem.getExtension(IAnalyzerController.class).getConfiguration(CoreAnalyzerId.ARCHITECTURE_CHECK);
    }

    @Override
    public final boolean areDeletableArchitectureFileElements(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeletableArchitectureFileElements' must not be empty";
        for (Element element : elements) {
            if (element instanceof ArchitectureFile || element instanceof ArchitectureSubDirectory) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Collection<String> architectureFileElementsDeletionAffectsArchitectureCheck(List<? extends Element> elements) {
        assert (this.areDeletableArchitectureFileElements(elements)) : "Not deletable architecture file elements: " + String.valueOf(elements);
        ArchitectureCheckConfiguration configuration = this.getArchitectureCheckConfiguration();
        assert (configuration != null) : "'configuration' of method 'architectureFileElementsDeletionAffectsArchitectureCheck' must not be null";
        HashSet<String> affected = new HashSet<String>();
        for (Element element : this.getNormalizedArchitectureFileToDelete(elements)) {
            if (element instanceof ArchitectureFile) {
                ArchitectureFile file = (ArchitectureFile)element;
                if (!configuration.isChecked(file.getIdentifyingPath())) continue;
                affected.add(file.getIdentifyingPath());
                continue;
            }
            if (!(element instanceof DirectoryPath)) continue;
            DirectoryPath dir = (DirectoryPath)element;
            List<ArchitectureFile> children = dir.getChildrenRecursively(ArchitectureFile.class, ArchitectureFile.class);
            for (ArchitectureFile child : children) {
                if (!configuration.isChecked(child.getIdentifyingPath())) continue;
                affected.add(child.getIdentifyingPath());
            }
        }
        return affected;
    }

    @Override
    public final List<ArchitectureFile> getAvailableArchitectureFiles() {
        return new ArrayList<ArchitectureFile>(this.m_architectureFiles.values());
    }

    @Override
    public final List<ArchitectureFile> getCheckedArchitectureFiles() {
        return this.m_architectureFiles.values().stream().filter(a -> a.isChecked()).collect(Collectors.toList());
    }

    @Override
    public final boolean isArchitectureFileDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isArchitectureDirectory' must not be null";
        return directoryPath == this.m_softwareSystem.getUniqueExistingChild(Files.class).getArchitecture() || directoryPath instanceof ArchitectureSubDirectory;
    }

    @Override
    public ITextValidator getArchitectureDirectoryNameValidator(final DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'getArchitectureDirectoryNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                if ((newInput = newInput.trim()).isEmpty()) {
                    result.addError("Must not be empty");
                    return result;
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Architecture name is not valid");
                }
                if (result.isFailure()) {
                    return result;
                }
                if (result.inputModified()) {
                    for (Path next : directoryPath.getChildren(Path.class)) {
                        if (!next.getShortName().equalsIgnoreCase(newInput)) continue;
                        result.addError("Architecture directory name '" + newInput + "' is already taken");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public ITextValidator getArchitectureFileNameValidator(final DirectoryPath directoryPath, final IPhysicalArchitectureElement architectureElement) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'getArchitectureFileNameValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                if ((newInput = newInput.trim()).isEmpty()) {
                    result.addError("Must not be empty");
                    return result;
                }
                if (!FileUtility.isValidName((String)newInput)) {
                    result.addError("Architecture name is not valid");
                }
                if (newInput.endsWith(CoreFileType.ARCHITECTURE.getDefaultExtension())) {
                    result.addError("Architecture name needs to be specified without file extension");
                }
                if (result.isFailure()) {
                    return result;
                }
                if (result.inputModified()) {
                    String newInputWithExtension = newInput + CoreFileType.ARCHITECTURE.getDefaultExtension();
                    for (IPhysicalArchitectureElement next : directoryPath.getChildren(IPhysicalArchitectureElement.class)) {
                        if (next == architectureElement || !next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                        result.addError("Architecture element with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'accept' must not be null";
        assert (fileType.equals((Object)CoreFileType.ARCHITECTURE)) : "Unexpected 'fileType' " + fileType.getPresentationName();
        this.m_architectureSourceLineVisitor.process(visitor, content);
    }

    @Override
    public boolean mayBeAddedToArchitectureCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeAddedToArchitectureCheck' must not be empty";
        for (Element next : elements) {
            if (!(next instanceof ArchitectureFile)) {
                return false;
            }
            ArchitectureFile file = (ArchitectureFile)next;
            if (!file.isChecked() && file.canBeChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayBeRemovedFromArchitectureCheck(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'mayBeRemovedFromArchitectureCheck' must not be empty";
        for (Element next : elements) {
            if (next instanceof ArchitectureFile && ((ArchitectureFile)next).isChecked()) continue;
            return false;
        }
        return true;
    }

    protected final void removeAllCachedArchitectureFileRelatedInfo() {
        this.m_architectureFiles.clear();
        this.m_architectureFilesForCompilation.clear();
    }

    protected void addArchitectureFileContentForCompilation(String identifyingPath, String content) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'addArchitectureFileContentForCompilation' must not be empty";
        assert (content != null) : "Parameter 'content' of method 'addArchitectureFileContentForCompilation' must not be null";
        this.m_architectureFilesForCompilation.put(identifyingPath, content);
    }

    protected String removeArchitectureFileContentForCompilation(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeArchitectureFileContentForCompilation' must not be empty";
        String content = this.m_architectureFilesForCompilation.remove(identifyingPath);
        assert (content != null) : "No content found for '" + identifyingPath + "'";
        return content;
    }

    @Override
    public String getArchitectureFileContentForCompilation(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getArchitectureFileContentForCompilation' must not be empty";
        assert (this.m_architectureFilesForCompilation.containsKey(identifyingPath)) : "No content present for ArchitectureFile '" + identifyingPath + "'";
        return this.m_architectureFilesForCompilation.get(identifyingPath);
    }

    private Artifact findArtifact(List<Artifact> artifacts, List<String> artifactPath, int index) {
        assert (artifacts != null) : "Parameter 'artifacts' of method 'findArtifact' must not be null";
        assert (artifactPath != null) : "Parameter 'artifactPath' of method 'findArtifact' must not be null";
        String nextArtifactNameToMatch = artifactPath.get(index);
        for (Artifact nextArtifact : artifacts) {
            if (!nextArtifact.getShortName().equals(nextArtifactNameToMatch)) continue;
            if (index < artifactPath.size() - 1) {
                return this.findArtifact(nextArtifact.getChildren(Artifact.class), artifactPath, index + 1);
            }
            return nextArtifact;
        }
        return null;
    }

    @Override
    public Artifact find(String artifactPath) {
        assert (artifactPath != null && artifactPath.length() > 0) : "Parameter 'artifactPath' of method 'find' must not be empty";
        List<String> parts = Artifact.getArtifactPathParts(artifactPath);
        assert (!parts.isEmpty()) : "'parts' must not be empty";
        ArchitectureFile architectureFile = this.getArchitectureFile(parts.get(0));
        return architectureFile != null ? this.findArtifact(architectureFile.getChildren(Artifact.class), parts, 1) : null;
    }

    static boolean findArtifact(ElementAssignmentInfo info, Artifact currentArtifact) {
        assert (info != null) : "Parameter 'info' of method 'findArtifactPath' must not be null";
        assert (currentArtifact != null) : "Parameter 'currentArtifact' of method 'findArtifact' must not be null";
        IAssignableToArtifact assignable = info.getAssignable();
        if (currentArtifact.contains(assignable)) {
            info.add(currentArtifact);
            for (Connector connector : currentArtifact.getChildren(Connector.class)) {
                if (!connector.contains(assignable)) continue;
                info.add(connector);
            }
            for (Interface interface_ : currentArtifact.getChildren(Interface.class)) {
                if (!interface_.contains(assignable)) continue;
                info.add(interface_);
            }
            return true;
        }
        for (Artifact artifact : currentArtifact.getChildren(Artifact.class)) {
            if (!ArchitectureProvider.findArtifact(info, artifact)) continue;
            return true;
        }
        return false;
    }

    private void collectAssignmentInfo(ElementAssignmentInfo info) {
        assert (info != null) : "Parameter 'info' of method 'collectAssignmentInfo' must not be null";
        boolean atLeastOneArchitectureFileChecked = false;
        boolean assignmentFound = false;
        block0: for (ArchitectureFile next : this.m_architectureFiles.values()) {
            if (!next.isChecked() || !next.modelLoaded() || !next.getModel().equals((Object)info.getModel())) continue;
            atLeastOneArchitectureFileChecked = true;
            for (Artifact nextArtifact : next.getChildren(Artifact.class)) {
                if (!ArchitectureProvider.findArtifact(info, nextArtifact)) continue;
                assignmentFound = true;
                continue block0;
            }
        }
        if (atLeastOneArchitectureFileChecked && !assignmentFound) {
            if (info.getAssignable().isExternal()) {
                info.add(this.getUnassignedExternalNode(info.getModel()));
            } else {
                info.add(this.getUnassignedInternalNode(info.getModel()));
            }
        }
    }

    @Override
    public final ElementAssignmentInfo getAssignmentInfo(Element element) {
        LogicalModuleProgrammingElement lpe;
        assert (element != null) : "Parameter 'element' of method 'getAssignmentInfo' must not be null";
        if (element instanceof IComponent) {
            IComponent component = (IComponent)((Object)element);
            if (!component.isExcluded() && !component.getNamedElement().getRefactoringState().hasBeenDeleted()) {
                ElementAssignmentInfo info = new ElementAssignmentInfo(component, IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
                this.collectAssignmentInfo(info);
                return info.isEmpty() ? null : info;
            }
        } else if (element instanceof LogicalModuleProgrammingElement && !((lpe = (LogicalModuleProgrammingElement)element).getParent() instanceof LogicalModuleProgrammingElement)) {
            ElementAssignmentInfo info = new ElementAssignmentInfo(lpe, IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
            this.collectAssignmentInfo(info);
            return info.isEmpty() ? null : info;
        }
        return null;
    }

    @Override
    public final ArchitectureElementsInfo getArchitectureElementsInfo(List<Element> elements, ArchitectureFile architectureFile) {
        AssignedElementCollector collector;
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getAssignedElements' must not be empty";
        ArrayList<NamedElement> physicalArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> logicalArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> uncheckedArchitectureElements = new ArrayList<NamedElement>();
        ArrayList<NamedElement> physicalAssignables = new ArrayList<NamedElement>();
        ArrayList<NamedElement> logicalAssignables = new ArrayList<NamedElement>();
        for (Element element : elements) {
            NamedElement nextNamedElement;
            ArchitectureFile nextArchitectureFile;
            if (element instanceof IComponent) {
                IComponent nextComponent = (IComponent)((Object)element);
                if (nextComponent.isExcluded() || nextComponent.getNamedElement().getRefactoringState().hasBeenDeleted()) continue;
                physicalAssignables.add(nextComponent.getNamedElement());
                continue;
            }
            if (element instanceof LogicalModuleProgrammingElement) {
                LogicalModuleProgrammingElement nextLogicalModuleProgrammingElement = (LogicalModuleProgrammingElement)element;
                if (nextLogicalModuleProgrammingElement.getParent() instanceof LogicalModuleProgrammingElement) continue;
                logicalAssignables.add(nextLogicalModuleProgrammingElement);
                continue;
            }
            if (!(element instanceof IArchitectureDefinitionElement) || (nextArchitectureFile = (nextNamedElement = ((IArchitectureDefinitionElement)((Object)element)).getNamedElement()).getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT)) == null) continue;
            if (nextArchitectureFile.isChecked()) {
                if (nextArchitectureFile.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    physicalArchitectureElements.add(nextNamedElement);
                    continue;
                }
                logicalArchitectureElements.add(nextNamedElement);
                continue;
            }
            uncheckedArchitectureElements.add(nextNamedElement);
        }
        if (!physicalAssignables.isEmpty()) {
            for (ArchitectureFile architectureFile2 : this.m_architectureFiles.values()) {
                if (architectureFile != null && architectureFile2 != architectureFile || !architectureFile2.isChecked() || !architectureFile2.modelLoaded() || !architectureFile2.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) continue;
                collector = new AssignedElementCollector(physicalAssignables, physicalArchitectureElements);
                architectureFile2.accept(collector);
            }
            if (architectureFile == null) {
                for (UnassignedElements unassignedElements : this.getArchitectureDirectory().getChildren(UnassignedElements.class)) {
                    if (!unassignedElements.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) continue;
                    collector = new AssignedElementCollector(physicalAssignables, physicalArchitectureElements);
                    unassignedElements.accept(collector);
                }
            }
        }
        if (!logicalAssignables.isEmpty()) {
            for (ArchitectureFile architectureFile3 : this.m_architectureFiles.values()) {
                if (architectureFile != null && architectureFile3 != architectureFile || !architectureFile3.isChecked() || !architectureFile3.modelLoaded() || !architectureFile3.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) continue;
                collector = new AssignedElementCollector(logicalAssignables, logicalArchitectureElements);
                architectureFile3.accept(collector);
            }
            if (architectureFile == null) {
                for (UnassignedElements unassignedElements : this.getArchitectureDirectory().getChildren(UnassignedElements.class)) {
                    if (!unassignedElements.getModel().equals((Object)IArchitecturalModelProvider.ArchitectureModel.LOGICAL)) continue;
                    collector = new AssignedElementCollector(logicalAssignables, logicalArchitectureElements);
                    unassignedElements.accept(collector);
                }
            }
        }
        return new ArchitectureElementsInfo(physicalArchitectureElements, logicalArchitectureElements, uncheckedArchitectureElements);
    }

    private Artifact find(Artifact artifact, Collection<? extends IAssignableToArtifact> assignables) {
        assert (artifact != null) : "Parameter 'artifact' of method 'find' must not be null";
        assert (assignables != null) : "Parameter 'assignables' of method 'find' must not be null";
        if (artifact.contains(assignables)) {
            return artifact;
        }
        for (Artifact nextArtifact : artifact.getChildren(Artifact.class)) {
            Artifact found = this.find(nextArtifact, assignables);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Artifact find(ArchitectureFile file, Collection<? extends IAssignableToArtifact> assignables, boolean toplevel) {
        assert (file != null) : "Parameter 'file' of method 'find' must not be null";
        assert (assignables != null) : "Parameter 'assignables' of method 'find' must not be null";
        List<Artifact> artifactChildren = file.getChildren(Artifact.class);
        if (!artifactChildren.isEmpty()) {
            for (Artifact nextArtifact : artifactChildren) {
                Artifact found = this.find(nextArtifact, assignables);
                if (found == null) continue;
                return toplevel ? nextArtifact : found;
            }
        }
        return null;
    }

    @Override
    public Artifact getParentArtifact(ArchitectureFile file, Element element, boolean toplevel) {
        assert (file != null) : "Parameter 'file' of method 'getParentArtifact' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getParentArtifact' must not be null";
        if (file.isChecked()) {
            IArchitecturalModelProvider.ArchitectureModel architectureModel = file.getModel();
            if (element instanceof IComponent) {
                if (architectureModel.equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    return this.find(file, Collections.singletonList((IComponent)((Object)element)), toplevel);
                }
                TopLevelProgrammingElementCollector collector = new TopLevelProgrammingElementCollector();
                ((IComponent)((Object)element)).getNamedElement().accept(collector);
                THashSet logicalProgrammingElements = new THashSet();
                for (ProgrammingElement next : collector.getProgrammingElements()) {
                    LogicalProgrammingElement nextLogicalProgrammingElement = NamespaceUtility.getLogicalProgrammingElement(next, false);
                    if (nextLogicalProgrammingElement == null) continue;
                    logicalProgrammingElements.add(nextLogicalProgrammingElement);
                }
                if (!logicalProgrammingElements.isEmpty()) {
                    return this.find(file, (Collection<? extends IAssignableToArtifact>)logicalProgrammingElements, toplevel);
                }
            } else if (element instanceof IDirectoryPath) {
                List<IComponent> components = ((IDirectoryPath)((Object)element)).getNamedElement().getChildren(IComponent.class).stream().filter(c -> !c.isExcluded() && !c.getNamedElement().getRefactoringState().hasBeenDeleted()).collect(Collectors.toList());
                if (architectureModel.equals((Object)IArchitecturalModelProvider.ArchitectureModel.PHYSICAL)) {
                    return this.find(file, components, toplevel);
                }
                TopLevelProgrammingElementCollector collector = new TopLevelProgrammingElementCollector();
                components.forEach(c -> c.getNamedElement().accept(collector));
                HashSet<LogicalProgrammingElement> logicalProgrammingElements = new HashSet<LogicalProgrammingElement>();
                for (ProgrammingElement next : collector.getProgrammingElements()) {
                    LogicalProgrammingElement nextLogicalProgrammingElement = NamespaceUtility.getLogicalProgrammingElement(next, false);
                    if (nextLogicalProgrammingElement == null) continue;
                    logicalProgrammingElements.add(nextLogicalProgrammingElement);
                }
                if (!logicalProgrammingElements.isEmpty()) {
                    return this.find(file, logicalProgrammingElements, toplevel);
                }
            } else if (element instanceof LogicalNamespace) {
                switch (architectureModel) {
                    case LOGICAL: {
                        return this.find(file, ((LogicalNamespace)element).getChildren(LogicalProgrammingElement.class), toplevel);
                    }
                    case PHYSICAL: {
                        THashSet components = new THashSet();
                        for (ProgrammingElement next : ((LogicalNamespace)element).getTopLevelProgrammingElements()) {
                            IComponent nextComponent = next.getParent(IComponent.class, new Class[0]);
                            if (nextComponent == null) continue;
                            components.add(nextComponent);
                        }
                        return this.find(file, (Collection<? extends IAssignableToArtifact>)components, toplevel);
                    }
                }
                assert (false) : "Unhandled model: " + String.valueOf((Object)architectureModel);
            }
        }
        return null;
    }

    private List<Element> getElements(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getElements' must not be empty";
        ArrayList<Element> expanded = new ArrayList<Element>();
        for (Element next : elements) {
            if (next instanceof INamedElementAdapter) {
                for (NamedElement nextNamedElement : ((INamedElementAdapter)((Object)next)).getAdaptedTo()) {
                    expanded.add(nextNamedElement.getElement());
                }
                continue;
            }
            expanded.add(next.getElement());
        }
        return expanded;
    }

    @Override
    public List<NamedElement> getArchitectureRelatedElements(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArchitectureRelatedElements' must not be empty";
        ArrayList<NamedElement> relevant = new ArrayList<NamedElement>();
        for (Element next : this.getElements(elements)) {
            if (next instanceof IDiffElement && (next = ((IDiffElement)((Object)next)).getCurrentElement()) == null) {
                return Collections.emptyList();
            }
            if (next instanceof Issue) {
                Artifact artifact;
                Issue nextIssue = (Issue)next;
                next = ((Issue)next).getAffectedElement();
                if (nextIssue instanceof ArchitectureViolationIssue && (artifact = this.find(((ArchitectureViolationIssue)nextIssue).getArtifactFromPath())) != null) {
                    next = artifact;
                }
            } else if (next instanceof INamedElementNode) {
                next = ((INamedElementNode)((Object)next)).getNamedElement();
            }
            if (next.isExcluded()) {
                return Collections.emptyList();
            }
            if (next instanceof IArchitectureDefinitionElement) {
                relevant.add(((IArchitectureDefinitionElement)((Object)next)).getNamedElement());
                continue;
            }
            ElementAssignmentInfo assignmentInfo = this.getAssignmentInfo(next);
            if (assignmentInfo != null) {
                relevant.add(assignmentInfo.getAssignable().getNamedElement());
                continue;
            }
            return Collections.emptyList();
        }
        return relevant;
    }

    protected final UnassignedInternal getUnassignedInternalNode(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedInternalNode' must not be null";
        return this.getArchitectureDirectory().getChildren(UnassignedInternal.class).stream().filter(c -> c.getModel().equals((Object)model)).findFirst().orElse(null);
    }

    protected final UnassignedExternal getUnassignedExternalNode(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'getUnassignedExternalNode' must not be null";
        return this.getArchitectureDirectory().getChildren(UnassignedExternal.class).stream().filter(c -> c.getModel().equals((Object)model)).findFirst().orElse(null);
    }

    @Override
    public final List<AutoCompletionProposal> getAutoCompletionProposals(ArchitectureFile file, String text, int offset, int line) {
        assert (file != null) : "Parameter 'file' of method 'getAutoCompletionProposals' must not be null";
        return AutoCompletionProposalsCollector.getAutoCompletionProposals(text, offset, line, file.getIdentifyingPath(), this.getArchitectureDirectory());
    }

    @Override
    public final AggregatedViolationInfo getAggregatedViolationInfo(List<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getAggregatedViolationInfo' must not be null";
        return ArchitectureViolationAggregator.getAggregatedViolationInfo(elements, this.m_softwareSystem.getCurrentModel(IVirtualModel.class), this);
    }

    @Override
    public AggregatedDeprecationInfo getAggregatedDeprecationInfo(List<NamedElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getAggregatedDeprecationInfo' must not be null";
        return ArchitectureViolationAggregator.getAggregatedDeprecationInfo(elements, this.m_softwareSystem.getCurrentModel(IVirtualModel.class), this);
    }
}

