/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.enterprise;

import com.hello2morrow.sonargraph.core.controllerinterface.system.ISonargraphEnterpriseExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.enterprise.IConnectionValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteReportInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.SnapshotInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.IConnectionConsumer;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SonargraphEnterpriseExtension
extends Extension
implements ISonargraphEnterpriseExtension {
    @Override
    public IConnectionValidator getConnectionValidator() {
        return new ConnectionValidator();
    }

    @Override
    public ISonargraphEnterpriseProvider.IEnterpriseInfoProvider createInfoProvider(SonargraphEnterpriseConnection connectionData, ProxySettings proxySettings, IConnectionConsumer consumer) {
        assert (connectionData != null) : "Parameter 'connectionData' of method 'createInfoProvider' must not be null";
        assert (proxySettings != null) : "Parameter 'proxySettings' of method 'createInfoProvider' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'createInfoProvider' must not be null";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("X-ClientKey", connectionData.getClientKey());
        ProxySettings actualProxySettings = proxySettings.getHost() == null || proxySettings.getHost().trim().length() == 0 ? null : proxySettings;
        return new HttpInfoProvider(connectionData.getServerUrl(), requestHeaders, actualProxySettings, consumer);
    }

    @Override
    public OperationResultWithOutcome<List<RemoteSystemInfo>> listSystems(ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider) {
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'listSystems' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading list of systems");
        String systemsContent = infoProvider.loadSystemsContent();
        if (systemsContent == null || systemsContent.trim().length() == 0) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, "Failed to load systems. No content available!", new Object[0]);
            return result;
        }
        ArrayList<RemoteSystemInfo> systemInfos = new ArrayList<RemoteSystemInfo>();
        try {
            JSONParser jsonParser = new JSONParser();
            Object root = jsonParser.parse(systemsContent);
            if (root instanceof JSONArray) {
                for (Object next : (JSONArray)root) {
                    String lastUpdate;
                    String description;
                    String name;
                    JSONObject systemObject;
                    String systemId;
                    if (!(next instanceof JSONObject) || (systemId = this.getStringValueFromJsonObject(systemObject = (JSONObject)next, "id", true, (OperationResult)result)) == null || (name = this.getStringValueFromJsonObject(systemObject, "name", true, (OperationResult)result)) == null || (description = this.getStringValueFromJsonObject(systemObject, "description", false, (OperationResult)result)) == null || (lastUpdate = this.getStringValueFromJsonObject(systemObject, "lastUpdate", true, (OperationResult)result)) == null) continue;
                    systemInfos.add(new RemoteSystemInfo(systemId, name, description, lastUpdate));
                }
            }
        }
        catch (ParseException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to parse systems JSON content", new Object[]{e});
        }
        result.setOutcome(systemInfos);
        return result;
    }

    private String getStringValueFromJsonObject(JSONObject jsonObject, String attribute, boolean isRequired, OperationResult result) {
        assert (jsonObject != null) : "Parameter 'jsonObject' of method 'getStringValueFromJsonObject' must not be null";
        assert (attribute != null && attribute.length() > 0) : "Parameter 'attribute' of method 'getStringValueFromJsonObject' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'getStringValueFromJsonObject' must not be null";
        Object value = jsonObject.get((Object)attribute);
        if (value != null) {
            return value.toString();
        }
        if (isRequired) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Missing required attribute '" + attribute + "' in " + jsonObject.toJSONString(), new Object[0]);
        }
        return null;
    }

    @Override
    public OperationResultWithOutcome<List<RemoteReportInfo>> listReports(String systemIdentifier, String systemName, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider) {
        assert (systemIdentifier != null && systemIdentifier.length() > 0) : "Parameter 'systemIdentifier' of method 'listReports' must not be empty";
        assert (systemName != null) : "Parameter 'systemName' of method 'listReports' must not be null";
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'listReports' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading list of reports");
        String content = infoProvider.loadXmlReportsContent(systemIdentifier);
        if (content == null || content.trim().length() == 0) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, "Failed to load reports. No content available!", new Object[0]);
            return result;
        }
        ArrayList<RemoteReportInfo> reports = new ArrayList<RemoteReportInfo>();
        try {
            JSONParser jsonParser = new JSONParser();
            Object object = jsonParser.parse(content);
            if (object instanceof JSONArray) {
                JSONArray reportList = (JSONArray)object;
                for (Object next : reportList) {
                    String downloadUrl;
                    String branch;
                    assert (next != null && next instanceof JSONObject) : "Unexpected class in method 'listReports': " + String.valueOf(next);
                    JSONObject report = (JSONObject)next;
                    String timestamp = this.getStringValueFromJsonObject(report, "timestamp", true, (OperationResult)result);
                    if (timestamp == null || (branch = this.getStringValueFromJsonObject(report, "branch", true, (OperationResult)result)) == null || (downloadUrl = this.getStringValueFromJsonObject(report, "downloadUrl", true, (OperationResult)result)) == null) continue;
                    String version = this.getStringValueFromJsonObject(report, "version", false, (OperationResult)result);
                    String commitId = this.getStringValueFromJsonObject(report, "commitId", false, (OperationResult)result);
                    String contextInfo = this.getStringValueFromJsonObject(report, "context", false, (OperationResult)result);
                    RemoteReportInfo info = new RemoteReportInfo(systemIdentifier, systemName, downloadUrl, timestamp, version, branch, commitId, contextInfo);
                    reports.add(info);
                }
            }
        }
        catch (ParseException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed parsing snapshot JSON content", new Object[]{e});
        }
        reports.sort(new Comparator<RemoteReportInfo>(){

            @Override
            public int compare(RemoteReportInfo r1, RemoteReportInfo r2) {
                return r2.getTimestamp().compareTo(r1.getTimestamp());
            }
        });
        result.setOutcome(reports);
        return result;
    }

    @Override
    public OperationResultWithOutcome<List<SnapshotInfo>> listSnapshots(String systemIdentifier, String systemName, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider snapshotProvider) {
        assert (snapshotProvider != null) : "Parameter 'snapshotProvider' of method 'listSnapshots' must not be null";
        assert (systemIdentifier != null && systemIdentifier.length() > 0) : "Parameter 'systemIdentifier' of method 'listSnapshots' must not be empty";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'listSnapshots' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading list of snapshots");
        String content = snapshotProvider.loadSnapshotsContent(systemIdentifier);
        if (content == null || content.trim().length() == 0) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, "Failed to load snaphosts. No content available!", new Object[0]);
            return result;
        }
        ArrayList<SnapshotInfo> snapshots = new ArrayList<SnapshotInfo>();
        try {
            JSONParser jsonParser = new JSONParser();
            Object object = jsonParser.parse(content);
            if (object instanceof JSONArray) {
                JSONArray snapshotList = (JSONArray)object;
                for (Object next : snapshotList) {
                    String downloadUrl;
                    String branch;
                    assert (next != null && next instanceof JSONObject) : "Unexpected class in method 'listSnapshots': " + String.valueOf(next);
                    JSONObject snapshot = (JSONObject)next;
                    String timestamp = this.getStringValueFromJsonObject(snapshot, "timestamp", true, (OperationResult)result);
                    if (timestamp == null || (branch = this.getStringValueFromJsonObject(snapshot, "branch", true, (OperationResult)result)) == null || (downloadUrl = this.getStringValueFromJsonObject(snapshot, "downloadUrl", true, (OperationResult)result)) == null) continue;
                    String version = this.getStringValueFromJsonObject(snapshot, "version", false, (OperationResult)result);
                    String commitId = this.getStringValueFromJsonObject(snapshot, "commitId", false, (OperationResult)result);
                    String contextInfo = this.getStringValueFromJsonObject(snapshot, "context", false, (OperationResult)result);
                    SnapshotInfo info = new SnapshotInfo(systemIdentifier, systemName, downloadUrl, timestamp, version, branch, commitId, contextInfo);
                    snapshots.add(info);
                }
            }
        }
        catch (ParseException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed parsing snapshot JSON content", new Object[]{e});
        }
        snapshots.sort(new Comparator<SnapshotInfo>(){

            @Override
            public int compare(SnapshotInfo s1, SnapshotInfo s2) {
                return s2.getTimestamp().compareTo(s1.getTimestamp());
            }
        });
        result.setOutcome(snapshots);
        return result;
    }

    @Override
    public OperationResultWithOutcome<TFile> downloadSnapshot(IWorkerContext workerContext, RemoteSystemInfo remoteSystem, SnapshotInfo snapshotInfo, TFile targetFile, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider enterpriseInfoProvider) {
        TFile content;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'downloadSnapshot' must not be null";
        assert (remoteSystem != null) : "Parameter 'remoteSystem' of method 'downloadSnapshot' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'downloadSnapshot' must not be null";
        assert (enterpriseInfoProvider != null) : "Parameter 'enterpriseInfoProvider' of method 'downloadSnapshot' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Downloading snapshot for system " + remoteSystem.getName());
        if (targetFile.exists()) {
            try {
                targetFile.setWritable(true);
                TFile.rm_r((File)targetFile);
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete existing snapshot file", new Object[0]);
                return result;
            }
        }
        if ((content = enterpriseInfoProvider.downloadSnapshot(remoteSystem, snapshotInfo, targetFile)) == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, "Failed to download snapshot!", new Object[0]);
        } else {
            result.setOutcome((Object)content);
        }
        return result;
    }

    @Override
    public String getSnapshotFileName(ISoftwareSystemProvider provider, TFile snapshotDirectory, String fileNameCandidate) {
        assert (provider != null) : "Parameter 'provider' of method 'getSnapshotFileName' must not be null";
        assert (snapshotDirectory != null) : "Parameter 'snapshotDirectory' of method 'getSnapshotFileName' must not be null";
        assert (fileNameCandidate != null && fileNameCandidate.length() > 0) : "Parameter 'fileNameCandidate' of method 'getSnapshotFileName' must not be empty";
        if (provider.hasSoftwareSystem()) {
            SoftwareSystem softwareSystem = provider.getSoftwareSystem();
            if (!FileUtility.areEqual((TFile)softwareSystem.getSnapshot(), (TFile)new TFile((File)snapshotDirectory, fileNameCandidate))) {
                return fileNameCandidate;
            }
            String fileName = fileNameCandidate.substring(0, fileNameCandidate.length() - CoreFileType.SNAPSHOT.getDefaultExtension().length());
            int i = 1;
            while (true) {
                String nextFileName;
                if (!new TFile((File)snapshotDirectory, nextFileName = String.format("%s_%02d%s", fileName, i, CoreFileType.SNAPSHOT.getDefaultExtension())).exists()) {
                    return nextFileName;
                }
                ++i;
            }
        }
        return fileNameCandidate;
    }

    @Override
    public OperationResultWithOutcome<TFile> downloadReport(IWorkerContext workerContext, ISoftwareSystemProvider provider, RemoteSystemInfo remoteSystem, RemoteReportInfo reportInfo, TFile targetFile, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider enterpriseInfoProvider) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'downloadReport' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'downloadReport' must not be null";
        assert (remoteSystem != null) : "Parameter 'remoteSystem' of method 'downloadReport' must not be null";
        assert (reportInfo != null) : "Parameter 'reportInfo' of method 'downloadReport' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'downloadReport' must not be null";
        assert (enterpriseInfoProvider != null) : "Parameter 'enterpriseInfoProvider' of method 'downloadReport' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Download baseline report");
        if (targetFile.exists()) {
            try {
                targetFile.rm();
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete existing XML report.", new Object[]{e});
                return result;
            }
        }
        try {
            TFile xmlReport = enterpriseInfoProvider.downloadXmlReport(remoteSystem, reportInfo, targetFile);
            if (xmlReport == null) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.DOWNLOAD_ERROR, "Failed to download XML report.", new Object[0]);
            } else {
                if (provider.hasSoftwareSystem()) {
                    result.addMessagesFrom(provider.getSoftwareSystem().getExtension(ISystemDiffExtension.class).addBaseline(workerContext, xmlReport));
                }
                result.setOutcome((Object)xmlReport);
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)e, "Failed to write XML report", new Object[0]);
        }
        return result;
    }

    private static class ConnectionValidator
    implements IConnectionValidator {
        private ConnectionValidator() {
        }

        @Override
        public ValidationResult validate(SonargraphEnterpriseConnection connection) {
            boolean inputChanged = false;
            ValidationResult result = new ValidationResult(false);
            result.addMessagesFrom(this.validateServer(connection.getServer(), false));
            result.addMessagesFrom(this.validatePort(connection.getPort(), false));
            result.addMessagesFrom(this.validateClientKey(connection.getClientKey(), false));
            return result;
        }

        @Override
        public ValidationResult validateServer(String server, boolean inputChanged) {
            ValidationResult result = new ValidationResult(inputChanged);
            if (server == null || server.trim().isEmpty()) {
                result.addError("Server url must not be empty");
                return result;
            }
            String trimmedLowerCase = server.trim().toLowerCase();
            if (!trimmedLowerCase.startsWith("http://") && !trimmedLowerCase.startsWith("https://")) {
                result.addError("URL must start with 'http://' or 'https://'.");
                return result;
            }
            try {
                new URI(server.trim()).toURL();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                result.addError(exception.getMessage());
            }
            return result;
        }

        @Override
        public ValidationResult validatePort(String portString, boolean inputChanged) {
            ValidationResult result = new ValidationResult(inputChanged);
            if (portString == null || portString.trim().isEmpty()) {
                return result;
            }
            try {
                int port = Integer.parseInt(portString.trim());
                if (port <= 0) {
                    result.addError("Invalid port");
                }
            }
            catch (NumberFormatException nfe) {
                result.addError("Invalid port");
            }
            return result;
        }

        @Override
        public ValidationResult validateClientKey(String clientKey, boolean inputChanged) {
            ValidationResult result = new ValidationResult(inputChanged);
            if (clientKey == null || clientKey.trim().isEmpty()) {
                result.addError("Client key must not be empty");
            }
            return result;
        }
    }

    private static class HttpInfoProvider
    implements ISonargraphEnterpriseProvider.IEnterpriseInfoProvider {
        private static final Logger LOGGER = LoggerFactory.getLogger(HttpInfoProvider.class);
        private final String m_serverUrl;
        private final Map<String, String> m_requestHeaders;
        private final ProxySettings m_proxySettings;
        private final IConnectionConsumer m_connectionConsumer;

        public HttpInfoProvider(String serverUrl, Map<String, String> requestHeaders, ProxySettings proxySettings, IConnectionConsumer connectionConsumer) {
            assert (serverUrl != null && serverUrl.length() > 0) : "Parameter 'serverUrl' of method 'HttpSnapshotInfoProvider' must not be empty";
            assert (requestHeaders != null) : "Parameter 'requestHeaders' of method 'HttpSnapshotInfoProvider' must not be null";
            assert (connectionConsumer != null) : "Parameter 'connectionConsumer' of method 'HttpSnapshotInfoProvider' must not be null";
            this.m_serverUrl = serverUrl;
            this.m_requestHeaders = requestHeaders;
            this.m_proxySettings = proxySettings;
            this.m_connectionConsumer = connectionConsumer;
        }

        @Override
        public String loadSystemsContent() {
            String url = this.m_serverUrl + "/downloads/listSystems";
            LOGGER.info("Loading systems from {}", (Object)url);
            String content = HttpConnectionCheck.getContent((String)url, this.m_requestHeaders, (ProxySettings)this.m_proxySettings, (IConnectionConsumer)this.m_connectionConsumer);
            return content;
        }

        @Override
        public String loadSnapshotsContent(String systemId) {
            String url = this.m_serverUrl + "/downloads/listSnapshots/" + systemId;
            LOGGER.info("Loading snapshots from {}", (Object)url);
            return HttpConnectionCheck.getContent((String)url, this.m_requestHeaders, (ProxySettings)this.m_proxySettings, (IConnectionConsumer)this.m_connectionConsumer);
        }

        @Override
        public String loadXmlReportsContent(String systemId) {
            String url = this.m_serverUrl + "/downloads/listReports/" + systemId;
            LOGGER.info("Loading reports from {}", (Object)url);
            return HttpConnectionCheck.getContent((String)url, this.m_requestHeaders, (ProxySettings)this.m_proxySettings, (IConnectionConsumer)this.m_connectionConsumer);
        }

        @Override
        public TFile downloadSnapshot(RemoteSystemInfo systemInfo, SnapshotInfo snapshotInfo, TFile targetFile) {
            assert (systemInfo != null) : "Parameter 'systemInfo' of method 'downloadSnapshot' must not be null";
            assert (snapshotInfo != null) : "Parameter 'snapshotInfo' of method 'downloadSnapshot' must not be null";
            assert (targetFile != null) : "Parameter 'targetFile' of method 'downloadSnapshot' must not be null";
            String url = this.m_serverUrl + snapshotInfo.getDownloadUrl();
            LOGGER.info("Loading snapshot for system {} from {}", (Object)systemInfo.getName(), (Object)url);
            return HttpConnectionCheck.getFileContent((String)url, this.m_requestHeaders, (ProxySettings)this.m_proxySettings, (TFile)targetFile);
        }

        @Override
        public TFile downloadXmlReport(RemoteSystemInfo systemInfo, RemoteReportInfo reportInfo, TFile targetFile) throws IOException {
            assert (systemInfo != null) : "Parameter 'systemInfo' of method 'downloadXmlReport' must not be null";
            assert (reportInfo != null) : "Parameter 'reportInfo' of method 'downloadXmlReport' must not be null";
            assert (targetFile != null) : "Parameter 'targetFile' of method 'downloadXmlReport' must not be null";
            String url = this.m_serverUrl + reportInfo.getDownloadUrl();
            LOGGER.info("Loading XML report for system {} from {}", (Object)systemInfo.getName(), (Object)url);
            TFile file = HttpConnectionCheck.getFileContent((String)url, this.m_requestHeaders, (ProxySettings)this.m_proxySettings, (TFile)targetFile);
            return file;
        }
    }
}

