/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ModifyGroovyScriptRunConfigurationCommand
extends SoftwareSystemBasedCommand<IModifyGroovyScriptRunConfigurationInteraction> {
    public ModifyGroovyScriptRunConfigurationCommand(ISoftwareSystemProvider provider, IModifyGroovyScriptRunConfigurationInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_GROOVY_SCRIPT_RUN_CONFIGURATION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ModifyGroovyScriptRunConfigurationData data = new ModifyGroovyScriptRunConfigurationData();
        if (!((IModifyGroovyScriptRunConfigurationInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IGroovyExtension groovyExtension = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class);
        boolean requiresSave = groovyExtension.editRequiresSave(data.getRunConfiguration(), data.getName());
        if (requiresSave && !((IModifyGroovyScriptRunConfigurationInteraction)this.getInteraction()).confirmSaveOnEdit()) {
            return;
        }
        OperationResult result = groovyExtension.modifyRunConfiguration(workerContext, data.getRunConfiguration(), data.getName(), data.getDescription(), data.getRunConfigurationParameters());
        ((IModifyGroovyScriptRunConfigurationInteraction)this.getInteraction()).processModificationResult(result);
    }

    public static interface IModifyGroovyScriptRunConfigurationInteraction
    extends ICommandInteraction {
        public boolean collect(ModifyGroovyScriptRunConfigurationData var1);

        public boolean confirmSaveOnEdit();

        public void processModificationResult(OperationResult var1);
    }

    public final class ModifyGroovyScriptRunConfigurationData
    implements ICommandInteractionData {
        private FileBasedRunConfiguration m_runConfiguration;
        private String m_name = "";
        private String m_description = "";
        private RunConfigurationParameters m_runConfigurationParameters;

        public void setRunConfiguration(FileBasedRunConfiguration runConfiguration) {
            assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'setRunConfiguration' must not be null";
            this.m_runConfiguration = runConfiguration;
        }

        FileBasedRunConfiguration getRunConfiguration() {
            return this.m_runConfiguration;
        }

        public void setName(String name) {
            assert (name != null) : "Parameter 'name' of method 'setName' must not be null";
            this.m_name = name;
        }

        String getName() {
            return this.m_name;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        String getDescription() {
            return this.m_description;
        }

        public void setRunConfigurationParameters(RunConfigurationParameters parameters) {
            assert (parameters != null) : "Parameter 'parameters' of method 'setRunConfigurationParameters' must not be null";
            this.m_runConfigurationParameters = parameters;
        }

        public RunConfigurationParameters getRunConfigurationParameters() {
            return this.m_runConfigurationParameters;
        }
    }
}

