/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterInfo;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public class EditQualityGateExcludeFilterCommand
extends SoftwareSystemBasedCommand<IEditFilterInteraction> {
    public EditQualityGateExcludeFilterCommand(ISoftwareSystemProvider provider, IEditFilterInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_QUALITY_GATE_EXCLUDE_FILTER;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (((IEditFilterInteraction)this.getInteraction()).collect(data)) {
            IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
            OperationResultWithOutcome<QualityGateExcludeFilter> result = extension.editExcludeFilter(workerContext, data.getQualityGate(), data.getExcludeFilterToEdit(), data.getFilterInfo());
            ((IEditFilterInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface IEditFilterInteraction
    extends ICommandInteraction {
        public boolean collect(InteractionData var1);

        public void processResult(OperationResultWithOutcome<QualityGateExcludeFilter> var1);
    }

    public static final class InteractionData
    implements ICommandInteractionData {
        private QualityGateExcludeFilter m_excludeFilter;
        private QualityGateExcludeFilterInfo m_filterInfo;
        private QualityGate m_qualityGate;

        public QualityGateExcludeFilterInfo getFilterInfo() {
            return this.m_filterInfo;
        }

        public void setFilterInfo(QualityGateExcludeFilterInfo filterInfo) {
            assert (filterInfo != null) : "Parameter 'filterInfo' of method 'setFilterInfo' must not be null";
            this.m_filterInfo = filterInfo;
        }

        public void setQualityGate(QualityGate qualityGate) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'setQualityGate' must not be null";
            this.m_qualityGate = qualityGate;
        }

        public QualityGate getQualityGate() {
            return this.m_qualityGate;
        }

        public void setExcludeFilterToEdit(QualityGateExcludeFilter filter) {
            assert (filter != null) : "Parameter 'filter' of method 'setFilter' must not be null";
            this.m_excludeFilter = filter;
        }

        public QualityGateExcludeFilter getExcludeFilterToEdit() {
            return this.m_excludeFilter;
        }
    }
}

