/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.base;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public abstract class InstallationBasedCommand<T extends ICommandInteraction>
extends SonargraphCommand {
    private final T m_interaction;
    private final Installation m_createdForInstallation;

    public InstallationBasedCommand(ISoftwareSystemProvider provider, T interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'InstallationBasedCommand' must not be null";
        this.m_interaction = interaction;
        this.m_createdForInstallation = provider.getInstallation();
        assert (this.m_createdForInstallation != null) : "'m_createdForInstallation' of method 'InstallationBasedCommand' must not be null";
    }

    @Override
    public final INavigationState getNavigationState() {
        return null;
    }

    protected final T getInteraction() {
        return this.m_interaction;
    }

    protected final Installation getInstallation() {
        return this.m_createdForInstallation;
    }

    @Override
    protected final boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result result = new Result();
        if (this.getController().getInstallation() != this.m_createdForInstallation) {
            result.addErrorMessage("Command was created for different installation");
        }
        return result;
    }
}

