/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collection;
import java.util.List;

public final class RenameArchitectureElementCommand
extends SoftwareSystemBasedCommand<IRenameInteraction> {
    public static final ICommandId ID = CoreCommandId.EDIT_ARCHITECTURE_FILE;

    public RenameArchitectureElementCommand(ISoftwareSystemProvider provider, IRenameInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return ID;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        EditData data;
        IRenameInteraction interaction = (IRenameInteraction)this.getInteraction();
        if (!interaction.collect(data = new EditData())) {
            return;
        }
        IPhysicalArchitectureElement architectureElement = data.getArchitectureElement();
        assert (architectureElement != null) : "Parameter 'architectureFile' of method 'internalRun' must not be null";
        IArchitectureExtension architectureExtension = this.getController().getSoftwareSystem().getExtension(IArchitectureExtension.class);
        Collection<ArchitectureFile> applyingFiles = architectureExtension.getApplyingAndRequiringFiles(List.of(architectureElement));
        if (!interaction.confirmSaveOnRename(architectureElement, applyingFiles)) {
            return;
        }
        OperationResult result = architectureExtension.renameArchitectureElement(workerContext, data.getArchitectureElement(), data.getName());
        interaction.processRenameResult(result);
    }

    public static final class EditData
    implements ICommandInteractionData {
        private IPhysicalArchitectureElement m_architectureElement;
        private String m_name;

        public IPhysicalArchitectureElement getArchitectureElement() {
            return this.m_architectureElement;
        }

        public void setArchitectureElement(IPhysicalArchitectureElement architectureElement) {
            assert (architectureElement != null) : "Parameter 'architectureElement' of method 'setArchitectureFile' must not be null";
            this.m_architectureElement = architectureElement;
        }

        public String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }
    }

    public static interface IRenameInteraction
    extends ICommandInteraction {
        public boolean collect(EditData var1);

        public boolean confirmSaveOnRename(IPhysicalArchitectureElement var1, Collection<ArchitectureFile> var2);

        public void processRenameResult(OperationResult var1);
    }
}

