/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public final class ExportArchitectureToXmlFileCommand
extends SoftwareSystemBasedCommand<IExportArchitectureToXmlFileInteraction> {
    public ExportArchitectureToXmlFileCommand(ISoftwareSystemProvider provider, IExportArchitectureToXmlFileInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPORT_ARCHITECTURE_FILE_TO_XML;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        ExportArchitectureToXmlFileData data = new ExportArchitectureToXmlFileData();
        if (!((IExportArchitectureToXmlFileInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        TFile targetFile = new TFile(data.getFilePath());
        if (targetFile.exists() && !((IExportArchitectureToXmlFileInteraction)this.getInteraction()).confirmOverwrite(data.getFilePath())) {
            return;
        }
        OperationResult result = this.getSoftwareSystem().getExtension(IArchitectureProvider.class).exportArchitectureToXmlFile(workerContext, data.getAarchitectureFile(), targetFile);
        ((IExportArchitectureToXmlFileInteraction)this.getInteraction()).processExportArchitectureResult(result);
    }

    public static final class ExportArchitectureToXmlFileData
    implements ICommandInteractionData {
        private String m_filePath;
        private ArchitectureFile m_architectureFile;

        public void setFilePath(String filePath) {
            assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'setFilePath' must not be empty";
            this.m_filePath = filePath;
        }

        String getFilePath() {
            assert (this.m_filePath != null && this.m_filePath.length() > 0) : "'m_filePath' of method 'getFilePath' must not be empty";
            return this.m_filePath;
        }

        public void setArchitectureFile(ArchitectureFile architectureFile) {
            assert (architectureFile != null) : "Parameter 'architectureFile' of method 'setArchitectureFile' must not be null";
            this.m_architectureFile = architectureFile;
        }

        ArchitectureFile getAarchitectureFile() {
            assert (this.m_architectureFile != null) : "'m_architectureFile' of method 'getAarchitectureFile' must not be null";
            return this.m_architectureFile;
        }
    }

    public static interface IExportArchitectureToXmlFileInteraction
    extends ICommandInteraction {
        public boolean collect(ExportArchitectureToXmlFileData var1);

        public boolean confirmOverwrite(String var1);

        public void processExportArchitectureResult(OperationResult var1);
    }
}

