/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collection;
import java.util.List;

public final class DeleteArchitectureElementsCommand
extends SoftwareSystemBasedCommand<IDeleteInteraction> {
    public static final ICommandId ID = CoreCommandId.DELETE_ARCHITECTURE_ELEMENTS;

    public DeleteArchitectureElementsCommand(ISoftwareSystemProvider provider, IDeleteInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return ID;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        AnalyzerConfigurationFile configurationFile;
        IDeleteInteraction deleteInteraction = (IDeleteInteraction)this.getInteraction();
        List<? extends Element> elements = deleteInteraction.getElements();
        if (elements == null || elements.isEmpty()) {
            return;
        }
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        IArchitectureExtension architectureExtension = softwareSystem.getExtension(IArchitectureExtension.class);
        IUndoRedoExtension undoRedoExtension = softwareSystem.getExtension(IUndoRedoExtension.class);
        boolean hasHistoryEntries = false;
        if (undoRedoExtension != null && (configurationFile = architectureExtension.getArchitectureCheckConfigurationFile()) != null && undoRedoExtension.getHistorySize(configurationFile) > 0) {
            hasHistoryEntries = true;
        }
        if (!deleteInteraction.confirmDeletion(architectureExtension.architectureFileElementsDeletionAffectsArchitectureCheck(elements), hasHistoryEntries)) {
            return;
        }
        deleteInteraction.processDeletionResult(architectureExtension.deleteArchitectureElements(workerContext, elements));
    }

    public static interface IDeleteInteraction
    extends ICommandInteraction {
        public List<? extends Element> getElements();

        public void processDeletionResult(OperationResult var1);

        public boolean confirmDeletion(Collection<String> var1, boolean var2);
    }
}

