/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitectureExtension;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class CreateArchitectureFileCommand
extends SoftwareSystemBasedCommand<ICreateInteraction> {
    private ArchitectureFile m_architectureFile;

    public CreateArchitectureFileCommand(ISoftwareSystemProvider provider, ICreateInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ARCHITECTURE_FILE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        CreateData data;
        ICreateInteraction interaction = (ICreateInteraction)this.getInteraction();
        if (!interaction.collect(data = new CreateData())) {
            return;
        }
        OperationResultWithOutcome<ArchitectureFile> result = this.getController().getSoftwareSystem().getExtension(IArchitectureExtension.class).createArchitectureFile(workerContext, data.getName(), data.getDirectoryPath(), data.addExampleSnippet());
        interaction.processCreateResult((OperationResult)result);
        this.m_architectureFile = (ArchitectureFile)result.getOutcome();
    }

    public ArchitectureFile getArchitectureFile() {
        return this.m_architectureFile;
    }

    public static final class CreateData
    implements ICommandInteractionData {
        private String m_name;
        private DirectoryPath m_directoryPath;
        private boolean m_addExampleSnippet;

        public String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name.trim();
        }

        public DirectoryPath getDirectoryPath() {
            assert (this.m_directoryPath != null) : "'m_directoryPath' of method 'getDirectoryPath' must not be null";
            return this.m_directoryPath;
        }

        public void setDirectoryPath(DirectoryPath directoryPath) {
            assert (directoryPath != null) : "Parameter 'directoryPath' of method 'setDirectoryPath' must not be null";
            this.m_directoryPath = directoryPath;
        }

        public void addExampleSnippet(boolean add) {
            this.m_addExampleSnippet = add;
        }

        public boolean addExampleSnippet() {
            return this.m_addExampleSnippet;
        }
    }

    public static interface ICreateInteraction
    extends ICommandInteraction {
        public boolean collect(CreateData var1);

        public void processCreateResult(OperationResult var1);
    }
}

