/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class SetSortModeCommand
extends ArchitecturalViewCommand<ISetLevelizationModeInteraction> {
    public SetSortModeCommand(ISoftwareSystemProvider provider, ISetLevelizationModeInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SET_EXPLORATION_VIEW_SORT_MODE;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected String getCommandName() {
        return "Set Sort Mode";
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        SetLevelizationModeData data = new SetLevelizationModeData();
        if (!((ISetLevelizationModeInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.setSortMode(workerContext, data.getRepresentation(), data.getMode());
        ((ISetLevelizationModeInteraction)this.getInteraction()).processSetModeResult(result);
    }

    public static interface ISetLevelizationModeInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(SetLevelizationModeData var1);

        public void processSetModeResult(OperationResult var1);
    }

    public static final class SetLevelizationModeData
    extends ArchitecturalViewRepresentationData {
        private ExplorationViewSortMode m_mode;

        public void setMode(ExplorationViewSortMode mode) {
            assert (mode != null) : "Parameter 'mode' of method 'setMode' must not be null";
            this.m_mode = mode;
        }

        ExplorationViewSortMode getMode() {
            assert (this.m_mode != null) : "'m_mode' of method 'getMode' must not be null";
            return this.m_mode;
        }
    }
}

