/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteArchitecturalViewFileInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteArchitecturalViewsCommand
extends ArchitecturalViewCommand<IDeleteArchitecturalViewsInteraction> {
    public DeleteArchitecturalViewsCommand(ISoftwareSystemProvider provider, IDeleteArchitecturalViewsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEWS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        DeleteArchitecturalViewsData data = new DeleteArchitecturalViewsData();
        if (!((IDeleteArchitecturalViewsInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        DeleteArchitecturalViewFileInfo info = extension.isDeleteArchitecturalViewsPossible(data.getFiles());
        assert (info != null) : "Parameter 'info' of method 'internalRun' must not be null";
        assert (info.getNumberOfAllFiles() > 0) : "No files to delete";
        StringBuilder question = new StringBuilder("This will delete ");
        question.append(info.getNumberOfAllFiles()).append(" architectural view file(s):\n");
        int i = 1;
        for (ArchitecturalViewFile nextFile : info.getFiles()) {
            question.append("\n(").append(i).append(") ").append(nextFile.getIdentifyingPath());
            ++i;
        }
        for (ArchitecturalViewFile nextFile : info.getDependingFiles()) {
            question.append("\n(").append(i).append(") ").append(nextFile.getIdentifyingPath()).append(" (depending)");
            ++i;
        }
        question.append("\n\nThis cannot be undone. Continue?");
        if (!((IDeleteArchitecturalViewsInteraction)this.getInteraction()).confirmDeletion(question.toString())) {
            return;
        }
        OperationResult result = extension.delete(workerContext, info);
        ((IDeleteArchitecturalViewsInteraction)this.getInteraction()).processDeletionResult(result);
    }

    public static final class DeleteArchitecturalViewsData
    implements IArchitecturalViewCommandInteractionData {
        private List<ArchitecturalViewFile> m_files;

        protected DeleteArchitecturalViewsData() {
        }

        public void setFiles(List<ArchitecturalViewFile> files) {
            assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'setFiles' must not be empty";
            this.m_files = new ArrayList<ArchitecturalViewFile>(files);
        }

        List<ArchitecturalViewFile> getFiles() {
            assert (this.m_files != null && !this.m_files.isEmpty()) : "'m_files' of method 'getFiles' must not be empty";
            return Collections.unmodifiableList(this.m_files);
        }
    }

    public static interface IDeleteArchitecturalViewsInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(DeleteArchitecturalViewsData var1);

        public boolean confirmDeletion(String var1);

        public void processDeletionResult(OperationResult var1);
    }
}

